/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macinst.h
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

/*
 * Instruction decode
 * defines
 */

/*
 * Generic operation
 * sizes
 */
#define OPSIZE_BYTE		0x0
#define OPSIZE_WORD		0x1
#define OPSIZE_LONG		0x2
#define OPSIZE_DBLONG		0x3
#define OPSIZE_NONE		0x4

/*
 * Extension word defines
 */
struct exten_brief {
  unsigned short ext_iregtyp:1,
                 ext_ireg:3,
                 ext_isize:1,
                 ext_scale:2,
                 ext_full:1,
                 ext_disp:8;
};

struct exten_full {
  unsigned short ext_iregtyp:1,
                 ext_ireg:3,
                 ext_isize:1,
                 ext_scale:2,
                 ext_full:1,
                 ext_bs:1,
                 ext_is:1,
                 ext_bdsize:2,
                 :1,
                 ext_isel:3;
};

/*
 * Memory Cell
 * allows access to
 * shorts and bytes.
 */
struct cell {
  union {
    struct {
      unsigned char msbyte;
      unsigned char msmbyte;
      unsigned char lsmbyte;
      unsigned char lsbyte;
    } bytes;
    struct {
      unsigned short hiword;
      unsigned short loword;
    } shortwords;
    unsigned char byte;
    unsigned short word;
    unsigned long longword;
  } un;
};

#define c_lsbyte un.bytes.lsbyte
#define c_msmbyte un.bytes.msmbyte
#define c_lsmbyte un.bytes.lsmbyte
#define c_lsbyte un.bytes.lsbyte
#define c_hiword un.shortwords.hiword
#define c_loword un.shortwords.loword
#define c_byte un.byte
#define c_word un.word
#define c_longword un.longword

/*
 * Instruction decode
 */
#define DIGIT_0_MASK    0xf000
#define DIGIT_1_MASK    0x0f00
#define DIGIT_2_MASK    0x00f0
#define DIGIT_3_MASK    0x000f

/*
 * privileged instruction groups
 */
#define INST_ANDI_SR    0
#define INST_EORI_SR    1
#define INST_ORI_SR     2
#define INST_MOVE_F_SR  3
#define INST_MOVE_T_SR  4
#define INST_MOVE_USP   5
#define INST_MOVEC      6
#define INST_MOVES      7
#define INST_RESET      8
#define INST_RTE        9
#define INST_STOP       10
#define INST_cpBcc      11
#define INST_cpDBcc     12
#define INST_cpGEN      13
#define INST_cpRESTORE  14
#define INST_cpSAVE     15
#define INST_cpScc      16
#define INST_cpTRAPcc   17
