/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macbus_cycle.c
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

#include <sys/param.h>

#include <mac2/pcb.h>

#include <mac2dev/via.h>

#include <mac2emul/macdefs.h>
#include <mac2emul/macvia.h>
#include <mac2emul/macuser.h>

/*
 * Handle bus cycle errors.  Only
 * get called for data cycle faults.
 */
macdevice_cycle(frame, regs)
register struct normal_exception_frame *frame;
register struct regs *regs;
{
    if (frame->f_fmt == STKFMT_SHORT_BUSERR) {
	register struct short_buserr_exception_frame *b =
	    (struct short_buserr_exception_frame *)frame;

	if (valid_device(b->f_fault, &b->f_dob, b->f_size, b->f_rw)) {
	    b->f_dfault = 0;
	    return (1);
	}
	else
	    return (0);
    }
    else {
	register struct long_buserr_exception_frame *b =
	    (struct long_buserr_exception_frame *)frame;

	if (b->f_rw) {
	    if (valid_device(b->f_fault, &b->f_dib, b->f_size, b->f_rw)) {
		b->f_dfault = 0;
		return (1);
	    }
	    else
		return (0);
	}
	else {
	    if (valid_device(b->f_fault, &b->f_dob, b->f_size, b->f_rw)) {
		b->f_dfault = 0;
		return (1);
	    }
	    else
		return (0);
	}
    }
}

macram_cycle(frame, regs)
register struct normal_exception_frame *frame;
register struct regs *regs;
{
    if (frame->f_fmt == STKFMT_SHORT_BUSERR) {
	register struct short_buserr_exception_frame *b =
	    (struct short_buserr_exception_frame *)frame;

	if (wrapped_ram(b->f_fault, &b->f_dob, b->f_size, b->f_rw)) {
	    b->f_dfault = 0;
	    return (1);
	}
	else
	    return (0);
    }
    else {
	register struct long_buserr_exception_frame *b =
	    (struct long_buserr_exception_frame *)frame;

	if (b->f_rw) {
	    if (wrapped_ram(b->f_fault, &b->f_dib, b->f_size, b->f_rw)) {
		b->f_dfault = 0;
		return (1);
	    }
	    else
		return (0);
	}
	else {
	    if (wrapped_ram(b->f_fault, &b->f_dob, b->f_size, b->f_rw)) {
		b->f_dfault = 0;
		return (1);
	    }
	    else
		return (0);
	}
    }
}


wrapped_ram(addr, data, size, rw)
register unsigned long addr;
register unsigned long *data;
register size, rw;
{
    register struct mac_internal *mac = current_thread_pcb()->pcb_emul;

    if (mac->flags&MAC_F_24BIT)
	addr &= 0x00ffffff;

    if (addr > 0x08000000)
	return (0);

    switch (mac->via2.portA.reg&(VIA_PORT_v2RAM1|VIA_PORT_v2RAM0)) {
      case VIA_PORT_v2RAM1|VIA_PORT_v2RAM0:
	/* 16 Mbyte simms */
	if (addr >= 0x08000000) {
	    addr &= 0x07ffffff;
	    access_ram(addr, data, size, rw);
	}
	else if (addr >= 0x06000000) {
	    addr &= 0x05ffffff;
	    access_ram(addr, data, size, rw);
	} else if (addr >= 0x04800000) {
	    addr &= 0x047fffff;
	    access_ram(addr, data, size, rw);
	}
	else if (addr >= 0x04200000) {
	    addr &= 0x041fffff;
	    access_ram(addr, data, size, rw);
	}
	break;

      case VIA_PORT_v2RAM1:
	/* 4 Mbyte simms */
	if (addr >= 0x02000000) {
	    addr &= 0x01ffffff;
	    access_ram(addr, data, size, rw);
	}
	else if (addr >= 0x01800000) {
	    addr &= 0x017fffff;
	    access_ram(addr, data, size, rw);
	}
	else if (addr >= 0x01200000) {
	    addr &= 0x011fffff;
	    access_ram(addr, data, size, rw);
	}
	break;

      case VIA_PORT_v2RAM0:
	/* 1 Mbyte simms */
	if (addr >= 0x00800000) {
	    addr &= 0x007fffff;
	    access_ram(addr, data, size, rw);
	}
	else if (addr >= 0x00500000) {
	    addr &= 0x004fffff;
	    access_ram(addr, data, size, rw);
	}
	break;

      case 0:
	/* 256 Kbyte simms */
	if (addr >= 0x00200000) {
	    addr &= 0x001fffff;
	    access_ram(addr, data, size, rw);
	}
	break;
    }
    return (1);
}

access_ram(addr, data, size, rw)
register unsigned long addr;
register unsigned long *data;
register size, rw;
{
    unsigned long l;
    unsigned short s;
    unsigned char c;

    if (rw == BUSERR_READ)
	switch (size) {
	  case BUSERR_SIZE_BYTE:
	    FETCH(addr, &c, unsigned char);
	    *data = c;
	    break;
	    
	  case BUSERR_SIZE_WORD:
	    FETCH(addr, &s, unsigned short);
	    *data = s;
	    break;
	    
	  case BUSERR_SIZE_LONG:
	    FETCH(addr, &l, unsigned long);
	    *data = l;
	    break;
	}
    else
	switch (size) {
	  case BUSERR_SIZE_BYTE:
	    c = *data;
	    STORE(addr, &c, unsigned char);
	    break;
	    
	  case BUSERR_SIZE_WORD:
	    s = *data;
	    STORE(addr, &s, unsigned short);
	    break;
	    
	  case BUSERR_SIZE_LONG:
	    l = *data;
	    STORE(addr, &l, unsigned long);
	    break;
	}
}
