#!/bin/sh -
#
# Copyright (c) 1980, 1986 Regents of the University of California.
# All rights reserved.  The Berkeley software License Agreement
# specifies the terms and conditions for redistribution.
#
#	@(#)newvers.sh	7.1 (Berkeley) 6/5/86
#
######################################################################
# HISTORY
#  5-Jun-88  Michael Young (mwyoung) at Carnegie-Mellon University
#	Move copyright name to the first argument, followed all version
#	identifiers.  [The patch is typcally the null string, causing
#	confusion if argument appear afterwards.]
#
# 29-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
#	Take copyright file name as a fifth argument.
#
# 13-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
#	Double size of version string.  I don't know why it can't just
#	be open-sized, but I don't want to find out now.
#
# 19-Apr-88  Mike Accetta (mja) at Carnegie-Mellon University
#	Changed to include only the last two components of the current
#	directory in the build version string;  added sanity check
#	for non-null working directory, hst name and date;  added
#	fifth argument to supply version patch level.
#	[ V5.1(XF23) ]
#
# 09-Nov-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Change to use proper argument order for version files.
#	[ V5.1(XF21) ]
#
# 16-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Version suffix is now .<config> instead of -<config>.
#	[ V5.1(XF19) ]
#
# 10-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Updated to also provide version components as kernel variables
#	and to create a version suffix for kernel images in the
#	"vers.suffix" file (unless it is empty)
#	[ V5.1(XF18) ]
#
# 25-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
#	No longer place an SCCS line in binary.
#
# 28-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Changed to embed "copyright" rather than "agreement" file in
#	binary.
#	[ V5.1(F8) ]
#
# 13-Feb-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Moved copyright agreement file to "conf" sub-directory from top
#	level.
#	[ V5.1(F2) ]
#
# 15-Nov-86  Mike Accetta (mja) at Carnegie-Mellon University
#	Changed version edit file to be specified by first argument;
#	removed increment of version number which is now done by the
#	Makefile and which depends only on changes to the source files
#	and not the build directory;  rearranged version string to use
#	only one line and to stay fixed width (to simplify binary
#	comparisons);  updated to include CMU copyright notice in
#	kernel binary.
#	[ V5.1(F1) ]
#
######################################################################
#
#if [ ! -r version ]
#then
#	/bin/echo 0 > version
#fi
#touch version
edit="$5"; major="$2"; minor="$3"; variant="$4"; patch="$6"; copyright="$1"
v="${major}.${minor}(${variant}${edit}${patch})" d=`pwd` h=`hostname` t=`date`
if [ -z "$d" -o -z "$h" -o -z "$t" ]; then
    exit 1
fi
CONFIG=`expr "$d" : '.*/\([^/_]*\).*$'`
d=`expr "$d" : '.*/\([^/]*/[^/]*\)$'`
(
  /bin/echo "int  version_major      = ${major};" ;
  /bin/echo "int  version_minor      = ${minor};" ;
  /bin/echo "char version_variant[9] = \"${variant}\";" ;
  /bin/echo "char version_patch[3]   = \"${patch}\";" ;
  /bin/echo "int  version_edit       = ${edit};" ;
  /bin/echo "char version[256] = \"Mach/4.3 #${v}: ${t}; $d ($h)\\n\";" ;
  /bin/echo "char cmu_copyright[] = \"\\" ;
  sed <$copyright -e '/^#/d' -e 's;[ 	]*$;;' -e '/^$/d' -e 's;$;\\n\\;' ;
  /bin/echo "\";";
) > vers.c
if [ -s vers.suffix -o ! -f vers.suffix ]; then
    echo ".${variant}${edit}${patch}.${CONFIG}" >vers.suffix
fi
exit 0
#/bin/echo `expr ${v} + 1` > version
