/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afsaux.c,v $
 * Revision 2.4  89/06/24  23:59:34  jsb
 * 	Newer ITC sources.
 * 	[89/06/24  23:48:27  jsb]
 * 
 * Revision 2.3  89/06/03  15:34:09  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:10:21  jsb]
 * 
 * Revision 2.2  89/04/22  15:18:23  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

#ifndef lint
#endif

/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifdef KERNEL
#include <afs/param.h>
#include <sys/types.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <afsint/afsint.h>
#else KERNEL
# include <afs/param.h>
# include <rx/xdr.h>
# include "afsint.h"
#endif KERNEL

#define MAXBS	2048		/* try to avoid horrible allocs */
static long bslosers = 0;

#ifdef KERNEL
#define	NVALLOC(a)	osi_Alloc(a)
#define	NVFREE(a,b)	osi_Free(a,b)
#else KERNEL
#define	NVALLOC(a)	malloc(a)
#define	NVFREE(a,b)	free(a)
#endif KERNEL

/* these things are defined in R (but not RX's) library.  For now, we add them
    only for the kernel system.  Later, when R is expunged, we'll remove the ifdef */
#ifdef KERNEL
#ifndef	AFS_VFS40
/*
 * XDR chars; from user mode xdr package.
 */
bool_t
xdr_char(xdrs, sp)
	register XDR *xdrs;
	char *sp;
{
	long l;

	switch (xdrs->x_op) {

	case XDR_ENCODE:
		l = (long) *sp;
		return (XDR_PUTLONG(xdrs, &l));

	case XDR_DECODE:
		if (!XDR_GETLONG(xdrs, &l)) {
			return (FALSE);
		}
		*sp = (char) l;
		return (TRUE);

	case XDR_FREE:
		return (TRUE);
	}
	return (FALSE);
}
#endif	AFS_VFS40

/* 
 * Wrapper for xdr_string that can be called directly from 
 * routines like clnt_call; from user-mode xdr package.
 */
bool_t
xdr_wrapstring(xdrs, cpp)
	XDR *xdrs;
	char **cpp;
{
	if (xdr_string(xdrs, cpp, 1024)) {
		return(TRUE);
	}
	return(FALSE);
}

/*
 * xdr_vector():
 *
 * XDR a fixed length array. Unlike variable-length arrays,
 * the storage of fixed length arrays is static and unfreeable.
 * > basep: base of the array
 * > size: size of the array
 * > elemsize: size of each element
 * > xdr_elem: routine to XDR each element
 */
bool_t
xdr_vector(xdrs, basep, nelem, elemsize, xdr_elem)
	register XDR *xdrs;
	register char *basep;
	register u_int nelem;
	register u_int elemsize;
	register xdrproc_t xdr_elem;	
{
	register u_int i;
	register char *elptr;

	elptr = basep;
	for (i = 0; i < nelem; i++) {
		if (! (*xdr_elem)(xdrs, elptr, (u_int) (~0))) {
			return(FALSE);
		}
		elptr += elemsize;
	}
	return(TRUE);	
}
#endif KERNEL

#ifndef KERNEL
xdr_CBS(x, abbs)
    XDR *x;
    struct CBS *abbs; {
    long len;
    if (x->x_op == XDR_FREE) {
	NVFREE(abbs->SeqBody,abbs->SeqLen);
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) NVALLOC(len);
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}

xdr_BBS(x, abbs)
    XDR *x;
    struct BBS *abbs; {
    long maxLen, len;
    if (x->x_op == XDR_FREE) {
	NVFREE(abbs->SeqBody, abbs->MaxSeqLen);
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->MaxSeqLen);
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &maxLen);
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS || len > maxLen) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) NVALLOC(maxLen);
	abbs->MaxSeqLen = maxLen;
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}

xdr_AFSAccessList(x, abbs)
    XDR *x;
    struct BBS *abbs; {
    long maxLen, len;
    if (x->x_op == XDR_FREE) {
	NVFREE(abbs->SeqBody, abbs->MaxSeqLen);
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->MaxSeqLen);
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &maxLen);
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS || len > maxLen) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) NVALLOC(maxLen);
	abbs->MaxSeqLen = maxLen;
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}
#endif KERNEL
