/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	fcrypt.c,v $
 * Revision 2.5  89/06/24  23:59:26  jsb
 * 	Sigh... AFSLITTLE_ENDIAN not defined for this module, thus must use
 * 	'(MACH && !BYTE_MSF)'.
 * 	[89/06/24  23:44:14  jsb]
 * 
 * Revision 2.4  89/06/03  15:30:52  jsb
 * 	Merged with newer ITC sources.
 * 	[89/06/02  22:11:02  jsb]
 * 
 * Revision 2.3  89/05/30  10:30:51  rvb
 * 	Keyed byteorder dependencies on BYTE_MSF
 * 	[89/05/16            af]
 * 
 * Revision 2.2  89/04/22  15:16:27  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifndef lint
#endif

/* $ Log:	fcrypt.c,v $
 * Revision 1.4  89/06/07  11:13:09  vasilis
 * handled byte order for dec mips workstation.
 * 
 * Revision 1.3  88/11/23  15:58:26  ota
 * Fix byte order problem with fcrypt on the Vax.
 * 
 * Revision 1.2  88/11/20  15:15:27  kazar
 * improve splitting things up
 * 
 * Revision 1.1  88/11/18  10:46:50  ota
 * Initial revision
 *  */

#define DEBUG 0

#ifdef KERNEL
#include <sys/types.h>
#include <netinet/in.h>

#else KERNEL

#include <sys/types.h>
#include <netinet/in.h>
#endif KERNEL

#include "sboxes.h"
#include "fcrypt.h"

int ROUNDS = 16;

int fc_keysched (key, schedule)
  struct ktc_EncryptionKey *key;
  fc_KeySchedule    schedule;
{   unsigned char *keychar = (unsigned char *)key;
    unsigned long  kword[2];

    unsigned int   temp;
    int		   i;

    /* first, flush the losing key parity bits. */
    kword[0] = (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[1] = kword[0] >> 4;		/* get top 24 bits for hi word */
    kword[0] &= 0xf;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar++) >> 1;
    kword[0] <<= 7;
    kword[0] += (*keychar) >> 1;

    schedule[0] = kword[0];
    for (i=1; i<ROUNDS; i++) {
	/* rotate right 3 */
	temp = kword[0] & ((1<<11)-1);	/* get 11 lsb */
	kword[0] = (kword[0] >> 11) | ((kword[1] & ((1<<11)-1)) << (32-11));
	kword[1] = (kword[1] >> 11) | (temp << (56-32-11));
	schedule[i] = kword[0];
    }
    return 0;
}

void fc_ecb_encrypt(clear, cipher, schedule, encrypt)
  unsigned long  *clear;
  unsigned long  *cipher;
  fc_KeySchedule  schedule;
  int		  encrypt;		/* 0 ==> decrypt, else encrypt */
{   unsigned long  L,R;
    unsigned long  S,P;
    unsigned char *Pchar = (unsigned char *)&P;
    unsigned char *Schar = (unsigned char *)&S;
    int i;

#if defined(vax) || (defined(mips) && defined(MIPSEL)) || (MACH && !BYTE_MSF)
#define Byte0 3 
#define Byte1 2
#define Byte2 1
#define Byte3 0
#else
#define Byte0 0
#define Byte1 1
#define Byte2 2
#define Byte3 3
#endif

#if 0
    bcopy (clear, &L, sizeof(long));
    bcopy (clear+1, &R, sizeof(long));
#else
    L = ntohl(*clear);
    R = ntohl(*(clear+1));
#endif

    if (encrypt) {
	for (i=0; i<(ROUNDS/2); i++) {
	    S = *schedule++ ^ R;	/* xor R with key bits from schedule */
	    Pchar[Byte2] = sbox0[Schar[Byte0]];	/* do 8-bit S Box substitution and */
	    Pchar[Byte3] = sbox1[Schar[Byte1]];	/* permute the result */
	    Pchar[Byte1] = sbox2[Schar[Byte2]];
	    Pchar[Byte0] = sbox3[Schar[Byte3]];
	    P = (P >> 5) | ((P & ((1<<5)-1)) << (32-5)); /* rotate 5 bits right */
	    L ^= P;			/* we're done with L, so save there */
	    S = *schedule++ ^ L;	/* this time xor with L */
	    Pchar[Byte2] = sbox0[Schar[Byte0]];
	    Pchar[Byte3] = sbox1[Schar[Byte1]];
	    Pchar[Byte1] = sbox2[Schar[Byte2]];
	    Pchar[Byte0] = sbox3[Schar[Byte3]];
	    P = (P >> 5) | ((P & ((1<<5)-1)) << (32-5)); /* rotate 5 bits right */
	    R ^= P;
	}
    }
    else {
	schedule = &schedule[ROUNDS-1];	/* start at end of key schedule */
	for (i=0; i<(ROUNDS/2); i++) {
	    S = *schedule-- ^ L;	/* xor R with key bits from schedule */
	    Pchar[Byte2] = sbox0[Schar[Byte0]];	/* do 8-bit S Box substitution and */
	    Pchar[Byte3] = sbox1[Schar[Byte1]];	/* permute the result */
	    Pchar[Byte1] = sbox2[Schar[Byte2]];
	    Pchar[Byte0] = sbox3[Schar[Byte3]];
	    P = (P >> 5) | ((P & ((1<<5)-1)) << (32-5)); /* rotate 5 bits right */
	    R ^= P;			/* we're done with L, so save there */
	    S = *schedule-- ^ R;	/* this time xor with L */
	    Pchar[Byte2] = sbox0[Schar[Byte0]];
	    Pchar[Byte3] = sbox1[Schar[Byte1]];
	    Pchar[Byte1] = sbox2[Schar[Byte2]];
	    Pchar[Byte0] = sbox3[Schar[Byte3]];
	    P = (P >> 5) | ((P & ((1<<5)-1)) << (32-5)); /* rotate 5 bits right */
	    L ^= P;
	}
    }
#if 0
    bcopy (&L, cipher, sizeof(long));
    bcopy (&R, cipher+1, sizeof(long));
#else
    *cipher = htonl(L);
    *(cipher+1) = htonl(R);
#endif
}

#if 0
void ecb_rencrypt(ROUNDS, clear, cipher, schedule, encrypt)
  int            ROUNDS;
  unsigned long *clear;
  unsigned long *cipher;
  fc_KeySchedule schedule;
  int		 encrypt;		/* 0 ==> decrypt, else encrypt */
{   unsigned long  L,R;
    unsigned long  S,P;
    unsigned long  K;
    unsigned long  temp;
    unsigned char *Pchar = (unsigned char *)&P;
    unsigned char *Schar = (unsigned char *)&S;
    int		  i;

    if (encrypt) {
	L = *clear++;
	R = *clear;
    }
    else {				/* do initial L/R swap if decoding */
	R = *clear++;
	L = *clear;
    }
    
    for (i=0; i<ROUNDS; i++) {
	/* for decrypt use schedule backwards */
	if (encrypt) K = schedule[i];
	else K = schedule[ROUNDS-i-1];

	S = K ^ R;			/* xor R with key bits from schedule */
	Pchar[2] = sbox0[Schar[0]];	/* do 8-bit S Box substitution and */
	Pchar[3] = sbox1[Schar[1]];	/* permute the result */
	Pchar[1] = sbox2[Schar[2]];
	Pchar[0] = sbox3[Schar[3]];
	P = (P >> 5) | ((P & ((1<<5)-1)) << (32-5)); /* rotate 5 bits right */
#if DEBUG
	printf ("L=%.8x  R=%.8x  S=%.8x  P=%.8x  K=%.8x\n", L,R,S,P,K);
#endif

	temp = R;
	R = L ^ P;			/* left xor f(key) goes to right */
	L = temp;			/* right goes to left */
    }
    if (encrypt) {
	*cipher++ = L;
	*cipher = R;
    }
    else {
	*cipher++ = R;
	*cipher = L;
    }
}
#endif

int fc_cbc_encrypt (input, output, length, key, iv, encrypt)
  char		*input;
  char		*output;
  long		 length;		/* in bytes */
  int		 encrypt;		/* 0 ==> decrypt, else encrypt */
  fc_KeySchedule key;			/* precomputed key schedule */
  unsigned long *iv;			/* 8 bytes of initialization vector */
{   unsigned long i,j;
    unsigned long t_input[2];
    unsigned long t_output[2];
    unsigned char *t_in_p = (unsigned char *) t_input;
    unsigned long xor[2];

    bcopy (iv, xor, sizeof(xor));
    if (encrypt) {
	for (i = 0; length > 0; i++, length -= 8) {
	    /* get input */
	    bcopy (input, t_input, sizeof(t_input));
	    input += sizeof(t_input);

	    /* zero pad */
	    for (j = length; j <= 7; j++)
		*(t_in_p+j)= 0;

	    /* do the xor for cbc into the temp */
	    xor[0] ^= t_input[0] ;
	    xor[1] ^= t_input[1] ;
	    /* encrypt */
	    fc_ecb_encrypt (xor, t_output, key, encrypt);

	    /* copy temp output and save it for cbc */
	    bcopy (t_output, output, sizeof(t_output));
	    output += sizeof(t_output);

	    /* calculate xor value for next round from plain & cipher text */
	    xor[0] = t_input[0] ^ t_output[0];
	    xor[1] = t_input[1] ^ t_output[1];


	}
	t_output[0] = 0;
	t_output[1] = 0;
	xor[0] = 0;
	xor[1] = 0;
	return 0;
    }

    else {
	/* decrypt */
	for (i = 0; length > 0; i++, length -= 8) {
	    /* get input */
	    bcopy (input, t_input, sizeof(t_input));
	    input += sizeof(t_input);

	    /* no padding for decrypt */
	    fc_ecb_encrypt(t_input, t_output, key, encrypt);

	    /* do the xor for cbc into the output */
	    t_output[0] ^= xor[0] ;
	    t_output[1] ^= xor[1] ;

	    /* copy temp output */
	    bcopy (t_output, output, sizeof(t_output));
	    output += sizeof(t_output);

	    /* calculate xor value for next round from plain & cipher text */
	    xor[0] = t_input[0] ^ t_output[0];
	    xor[1] = t_input[1] ^ t_output[1];
	}
    }
}

/* Calculates checksum of length bytes at input.  Checksum is stored at output.
   Length of checksum is returned. */

int fc_checksum (seed, input, output, length)
  short *seed;				/* seed value to start cksum with */
  char  *input;				/* input text to be checksummed */
  char  *output;			/* place to put checksum */
  int    length;			/* length of input */
{   long  cksum;
    short out;
    int	  i;
    unsigned char c;

    if (seed) cksum = *seed;
    else cksum = 0;

    for (i=0; i<length; i++) {
	c = *input++;
	cksum = cksum ^ ((c&0xf) | ((c&0xf0) << 4) | 0xf0f0);
	cksum = (cksum*cksum) % 60031;
    }
    out = cksum & 0xffff;
    out = htons(out);
    if (output) bcopy (&out, output, sizeof(out));
    return sizeof(out);
}
