#include "random.h"
#include <mach/message.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#if	!defined(KERNEL) && !defined(MIG_NO_STRINGS)
#include <strings.h>
#endif
/* LINTLIBRARY */

extern port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msg_request_port	msg_remote_port
#define msg_reply_port		msg_local_port

mig_external void init_random
#if	(defined(__STDC__) || defined(c_plusplus))
	(port_t rep_port)
#else
	(rep_port)
	port_t rep_port;
#endif
{
#ifdef	lint
	rep_port++;
#endif
}

/* Procedure init_seed */
mig_external void init_seed
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	dbl seed
)
#else
	(server_port, seed)
	port_t server_port;
	dbl seed;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t seedType;
		dbl seed;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 36;

#if	UseStaticMsgType
	static msg_type_t seedType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->seedType = seedType;
#else	UseStaticMsgType
	InP->seedType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->seedType.msg_type_size = 32;
	InP->seedType.msg_type_number = 2;
	InP->seedType.msg_type_inline = TRUE;
	InP->seedType.msg_type_longform = FALSE;
	InP->seedType.msg_type_deallocate = FALSE;
	InP->seedType.msg_type_unused = 0;
#endif	UseStaticMsgType

	InP->seed /* seed */ = /* seed */ seed;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 500;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		{ MsgError(msg_result); return; }
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 600)
		{ MsgError(MIG_REPLY_MISMATCH); return; }

#if	TypeCheck
	if (((msg_size != 32) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		{ MsgError(MIG_TYPE_ERROR); return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		{ MsgError(MIG_TYPE_ERROR); return; }
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		{ MsgError(OutP->RetCode); return; }

	/* Procedure - no return needed */
}

/* Function get_randomf */
mig_external int get_randomf
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port
)
#else
	(server_port)
	port_t server_port;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t get_randomfType;
		int get_randomf;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 24;

#if	UseStaticMsgType
	static msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t get_randomfCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 501;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		{ MsgError(msg_result); return OutP->get_randomf; }
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 601)
		{ MsgError(MIG_REPLY_MISMATCH); return OutP->get_randomf; }

#if	TypeCheck
	if (((msg_size != 40) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		{ MsgError(OutP->RetCode); return OutP->get_randomf; }

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->get_randomfType != * (int *) &get_randomfCheck)
#else	UseStaticMsgType
	if ((OutP->get_randomfType.msg_type_inline != TRUE) ||
	    (OutP->get_randomfType.msg_type_longform != FALSE) ||
	    (OutP->get_randomfType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->get_randomfType.msg_type_number != 1) ||
	    (OutP->get_randomfType.msg_type_size != 32))
#endif	UseStaticMsgType
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck

	return OutP->get_randomf;
}

/* Routine get_random */
mig_external kern_return_t get_random
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	int *num
)
#else
	(server_port, num)
	port_t server_port;
	int *num;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t numType;
		int num;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 24;

#if	UseStaticMsgType
	static msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t numCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 502;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 602)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 40) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->numType != * (int *) &numCheck)
#else	UseStaticMsgType
	if ((OutP->numType.msg_type_inline != TRUE) ||
	    (OutP->numType.msg_type_longform != FALSE) ||
	    (OutP->numType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->numType.msg_type_number != 1) ||
	    (OutP->numType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*num /* num */ = /* *num */ OutP->num;

	return OutP->RetCode;
}

/* Routine get_secret */
mig_external kern_return_t get_secret
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	string25 password
)
#else
	(server_port, password)
	port_t server_port;
	string25 password;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[3];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[3];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 56;

#if	UseStaticMsgType
	static msg_type_t passwordType = {
		/* msg_type_name = */		MSG_TYPE_STRING,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t passwordCheck = {
		/* msg_type_name = */		MSG_TYPE_STRING,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->passwordType = passwordType;
#else	UseStaticMsgType
	InP->passwordType.msg_type_name = MSG_TYPE_STRING;
	InP->passwordType.msg_type_size = 200;
	InP->passwordType.msg_type_number = 1;
	InP->passwordType.msg_type_inline = TRUE;
	InP->passwordType.msg_type_longform = FALSE;
	InP->passwordType.msg_type_deallocate = FALSE;
	InP->passwordType.msg_type_unused = 0;
#endif	UseStaticMsgType

	(void) mig_strncpy(InP->password /* password */, /* password */ password, 25);
	InP->password /* password */[24] = '\0';

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_ENCRYPTED | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 503;

	msg_result = msg_rpc(&InP->Head, RCV_TIMEOUT, sizeof(Reply), 0, 10000);
	if (msg_result != RPC_SUCCESS) {
		if ((msg_result == RCV_INVALID_PORT) ||
		    (msg_result == RCV_TIMED_OUT))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 603)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 64) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->passwordType != * (int *) &passwordCheck)
#else	UseStaticMsgType
	if ((OutP->passwordType.msg_type_inline != TRUE) ||
	    (OutP->passwordType.msg_type_longform != FALSE) ||
	    (OutP->passwordType.msg_type_name != MSG_TYPE_STRING) ||
	    (OutP->passwordType.msg_type_number != 1) ||
	    (OutP->passwordType.msg_type_size != 200))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	(void) mig_strncpy(password /* password */, /* password */ OutP->password, 25);
	password /* password */[24] = '\0';

	return OutP->RetCode;
}

/* Routine get_confidential */
mig_external kern_return_t get_confidential
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	int wait,
	int mtype | MSG_TYPE_RPC,
	page_ptr *data
)
#else
	(server_port, wait, mtype, data)
	port_t server_port;
	int wait;
	int mtype;
	page_ptr *data;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t dataType;
		page_ptr data;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 24;

#if	UseStaticMsgType
	static msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = mtype | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 504;

	msg_result = msg_rpc(&InP->Head, RCV_TIMEOUT, sizeof(Reply), 0, wait);
	if (msg_result != RPC_SUCCESS) {
		if ((msg_result == RCV_INVALID_PORT) ||
		    (msg_result == RCV_TIMED_OUT))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 604)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 48) || (msg_simple != FALSE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->dataType.msg_type_header.msg_type_inline != FALSE) ||
	    (OutP->dataType.msg_type_header.msg_type_longform != TRUE) ||
	    (OutP->dataType.msg_type_long_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->dataType.msg_type_long_number != 4096) ||
	    (OutP->dataType.msg_type_long_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*data /* data */ = /* *data */ OutP->data;

	return OutP->RetCode;
}

/* SimpleRoutine use_random */
mig_external kern_return_t use_random
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	string80 info_seed,
	comp_arr info,
	words info_1,
	unsigned int info_1Cnt
)
#else
	(server_port, info_seed, info, info_1, info_1Cnt)
	port_t server_port;
	string80 info_seed;
	comp_arr info;
	words info_1;
	unsigned int info_1Cnt;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t info_seedType;
		string80 info_seed;
		msg_type_t infoType;
		comp_arr info;
		msg_type_long_t info_1Type;
		words info_1;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 10368;

#if	UseStaticMsgType
	static msg_type_t info_seedType = {
		/* msg_type_name = */		MSG_TYPE_CHAR,
		/* msg_type_size = */		8,
		/* msg_type_number = */		80,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t infoType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2560,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_long_t info_1Type = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->info_seedType = info_seedType;
#else	UseStaticMsgType
	InP->info_seedType.msg_type_name = MSG_TYPE_CHAR;
	InP->info_seedType.msg_type_size = 8;
	InP->info_seedType.msg_type_number = 80;
	InP->info_seedType.msg_type_inline = TRUE;
	InP->info_seedType.msg_type_longform = FALSE;
	InP->info_seedType.msg_type_deallocate = FALSE;
	InP->info_seedType.msg_type_unused = 0;
#endif	UseStaticMsgType

	InP->info_seed /* info_seed */ = /* info_seed */ info_seed;

#if	UseStaticMsgType
	InP->infoType = infoType;
#else	UseStaticMsgType
	InP->infoType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->infoType.msg_type_size = 32;
	InP->infoType.msg_type_number = 2560;
	InP->infoType.msg_type_inline = TRUE;
	InP->infoType.msg_type_longform = FALSE;
	InP->infoType.msg_type_deallocate = FALSE;
	InP->infoType.msg_type_unused = 0;
#endif	UseStaticMsgType

	{ typedef struct { char data[10240]; } *sp; * (sp) InP->info /* info */ = * (sp) /* info */ info; }

#if	UseStaticMsgType
	InP->info_1Type = info_1Type;
#else	UseStaticMsgType
	InP->info_1Type.msg_type_long_name = MSG_TYPE_INTEGER_32;
	InP->info_1Type.msg_type_long_size = 32;
	InP->info_1Type.msg_type_header.msg_type_inline = FALSE;
	InP->info_1Type.msg_type_header.msg_type_longform = TRUE;
	InP->info_1Type.msg_type_header.msg_type_deallocate = FALSE;
	InP->info_1Type.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	InP->info_1 /* info_1 */ = /* info_1 */ info_1;

	InP->info_1Type.msg_type_long_number /* info_1Cnt */ = /* info_1Type.msg_type_long_number */ info_1Cnt;

	InP->Head.msg_simple = FALSE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 505;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleProcedure exit */
mig_external void exit
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port
)
#else
	(server_port)
	port_t server_port;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	msg_return_t msg_result;

	unsigned int msg_size = 24;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server_port;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 506;

	msg_result = msg_send(&InP->Head, MSG_OPTION_NONE, 0);
	if (msg_result != SEND_SUCCESS)
		{ MsgError(msg_result); return; }
}
