#ifndef lint
static	char sccsid[] = "@(#)access.c	1.1 (Berkeley) 2/25/86";
#endif
/*
 * Adb: access data in file/process address space.
 *
 * The routines in this file access referenced data using
 * the maps to access files, ptrace to access subprocesses,
 * or the system page tables when debugging the kernel,
 * to translate virtual to physical addresses.
 */

#include "defs.h"

MAP		txtmap;
MAP		datmap;
INT		wtflag;
STRING		errflg;
int		errno;

L_INT		pid;

#define vtophys(x) (x)

/*
 * Primitives: put a value in a space, get a value from a space
 * and get a word or byte not returning if an error occurred.
 */
put(addr, space, value) 
    off_t addr; { (void) access(WT, addr, space, value); }

u_int
get(addr, space)
    off_t addr; { return (access(RD, addr, space, 0)); };

u_int
chkget(addr, space)
    off_t addr; { u_int w = get(addr, space); chkerr(); return(w); }

u_int
bchkget(addr, space) 
    off_t addr; { return (byte(chkget(addr, space))); }

/*
 * Read/write according to mode at address addr in i/d space.
 * Value is quantity to be written, if write.
 *
 * This routine decides whether to get the data from the subprocess
 * address space with ptrace, or to get it from the files being
 * debugged.  
 *
 * When the kernel is being debugged with the -k flag we interpret
 * the system page tables for data space, mapping p0 and p1 addresses
 * relative to the ``current'' process (as specified by its p_addr in
 * <p) and mapping system space addresses through the system page tables.
 */
access(mode, addr, space, value)
	int mode, space, value;
	off_t addr;
{
	int rd = mode == RD;
	int file, w;

	if (space == NSP)
		return(0);
	if (pid) {
		int pmode = (space&DSP?(rd?RDUSER:WDUSER):(rd?RIUSER:WIUSER));

		w = ptrace(pmode, pid, addr, value);
		if (errno)
			rwerr(space);
		return (w);
	}
	w = 0;
	if (mode==WT && wtflag==0)
		error("not in write mode");
	if (!chkmap(&addr, space))
		return (0);
	file = (space&DSP) ? datmap.ufd : txtmap.ufd;
#if defined(vax) || defined(tahoe)
	if (kernel && space == DSP) {
		addr = vtophys(addr);
		if (addr < 0)
			return (0);
	}
#endif vax || tahoe
	if (physrw(file, addr, rd ? &w : &value, rd) < 0)
		rwerr(space);
	return (w);
}

rwerr(space)
	int space;
{

	if (space & DSP)
		errflg = "data address not found";
	else
		errflg = "text address not found";
}

physrw(file, addr, aw, rd)
	off_t addr;
	int *aw, rd;
{

	if (longseek(file,addr)==0 ||
	    (rd ? read(file,aw,sizeof(int)) : write(file,aw,sizeof(int))) < 1)
		return (-1);
	return (0);
}

chkmap(addr,space)
	REG L_INT	*addr;
	REG INT 	space;
{
	REG MAPPTR amap;

	amap=((space&DSP?&datmap:&txtmap));
	IF space&STAR ORF !within(*addr,amap->b1,amap->e1)
	THEN IF within(*addr,amap->b2,amap->e2)
	     THEN *addr += (amap->f2)-(amap->b2);
	     ELSE rwerr(space); return(0);
	     FI
	ELSE *addr += (amap->f1)-(amap->b1);
	FI
	return(1);
}

within(addr,lbd,ubd)
    u_int addr, lbd, ubd; { return(addr>=lbd && addr<ubd); }

longseek(f, a)
    off_t a; { return(lseek(f, a, 0) != -1); }
