.\"Format with:  tbl RELNOTES.ms | $(ROFF) -ms
.nr PD 1.25v
.EF '\fBX Window System Release Notes\fP''\fBX, Version 11, Release 4\fP'
.OF '\fBX Window System Release Notes\fP''\fBX, Version 11, Release 4\fP'
.EH ''\fB- % -\fP''
.OH ''\fB- % -\fP''
.DA "December 31, 1989"
.TL
X Window System, Version 11
.br
Release 4
.br
Release Notes
.AU
Jim Fulton
.AI
X Consortium
MIT Laboratory for Computer Science
.AB
The X Window System is a portable, network-transparent window system 
originally developed at MIT.  It can be used on a wide variety of raster 
display devices, ranging from from simple monochrome frame buffers to deep, 
true color graphics processors.  This document describes contents of 
the fourth public release of X, Version 11 from MIT and how it has changed
from previous releases.
.AE
.NH 1
Overview
.LP
This is the fourth release of the X Window System, Version 11 from MIT.
Substantial progress has been made in optimizing the sample server, 
window manager, and programming libraries.  In addition, 
major improvements 
to the user interface of several of the key applications (in particular,
\fIxmh\fP, \fItwm\fP, \fIxman\fP, and \fIxterm\fP) should make release
noticably nicer to use.  Sample implementations
of the various new Consortium Standards are included as well as prototype 
implementations of several efforts currently under development.
No incompatible changes have been made to either the
core Protocol or to the \fIXlib\fP programming library.  The 
\fIXt Intrinsics\fP
should be source compatible with the previous release.  Changes have been
made to the \fIXaw\fP widget set, but a configuration option for providing
backwards compatibility interfaces is available.
.LP
Several new sets of fonts have been added: a new fixed width family of
fonts, a Kanji and Kana font,
the Lucida family from Bigelow & Holmes and Sun Microsystems,
a terminal emulator font from Digital Equipment Corporation,
and 100 dots-per-inch (dpi) versions of all 75dpi fonts.
.FS
\fIX Window System\fP is a trademark of MIT.
.sp
Copyright \(co\ 1989 by the Massachusetts Institute of Technology.
.sp
Permission to use, copy, modify, distribute, and sell this
software and its documentation for any purpose is hereby granted without
fee, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.  
.sp
This software is not
subject to any license of the American Telephone and Telegraph
Company or of the Regents of the University of California.
.FE
.LP
This release contains two types of software:  that which is supported
by the staff of the X Consortium and which forms the core of the X Window
System, and that which has been contributed by the user community and is
provided as a public service
without support from MIT.  The core distribution also contains
public implementations of certain software management 
utilities that may not be available on all
platforms (such as \fIpatch\fP and a \fIcpp\fP that can handle large numbers of
symbols) as well as the tools that are used
to build X software.
.LP
The servers, libraries, and applications provided in this release are
\fIsample\fP rather than \fIreference\fP implementations.  The X 
Consortium standardizes specifications, not particular instances of code.
In particular, the document \fIX Window System Protocol, Version 11\fP is the
final authority on what is and is not part of the core X Window System 
protocol.  For additional information, see 
the \fIXStandards(1)\fP manual page.
.LP
Since the last release, the X Consortium has made significant additions to
the Xlib standard (see \fImit/doc/Xlib/R4Xlib.tbl.ms\fP) and to the
X Toolkit Intrinsics standard, and has approved the following specifications
as new standards:
.RS .5in
.IP "\fIInter-Client Communications Conventions Manual\fP"
.br
The Inter-Client Communications Conventions Manual (ICCCM, whose specification
may be found in \fImit/doc/ICCCM/icccm.tbl.ms\fP)
establishes a
set of conventions that allow clients to cooperate in the areas of selections,
cut buffers, window management, session management, and resources.  Programming
interfaces have been added to both \fIXlib\fP and the \fIXt Intrinsics\fP to
simplify the task of writing compliant applications.  The core \fItwm\fP
window manager, as well as the user-contributed \fIgwm\fP, \fIolwm\fP,
and \fItekwm\fP window managers, is intended to be be compliant.
.IP "\fIX11 Non-rectangular Window Shape Extension\fP"
.br
The SHAPE extension (whose specification may be found in 
\fImit/doc/extensions/shape.ms\fP) provides non-rectangular, disjoint
windows.  Samples of its use may be found in the \fIXaw\fP \fBCommand\fP
and \fBMailbox\fP widgets,
in the \fItwm\fP window manager, and in the \fIoclock\fP and \fIxeyes\fP
clients.
.IP "\fIX Display Manager Control Protocol\fP"
.br
The X Display Manager Control Protocol (XDMCP) (whose specification may be
found in \fImit/doc/XDMCP/xdmcp.ms\fP) is a datagram-based protocol for 
managing
remote displays (particularly X terminals) in a network.  Implementations of
the various elements of the protocol are provided in the sample server and
the \fIxdm\fP display manager.
.IP "\fICompound Text Encoding\fP"
.br
Compound Text (whose specification may be found in
\fImit/doc/CTEXT/ctext.tbl.ms\fP) is an interchange format for multiple 
character set data such as multi-lingual text.  It is based on ISO
standards for encoding and combining characters and is intended to be
used in the following contexts:  inter-client communication using selections,
window properties, and resources.  Routines for
parsing Compound Text may be found in \fImit/lib/Xmu/Xct.c\fP.
.IP "\fIX Logical Font Description Conventions\fP"
.br
The X Logical Font Description Conventions (XLFD, whose specification may
be found in \fImit/doc/XLFD/xlfd.tbl.ms\fP) are a set of guidelines for
naming fonts and font properties such that fonts can be uniquely named
and queried in a consistent manner by applications.  All of the text
fonts in the core distribution follow the XLFD conventions.  In addition,
the new \fIxfontsel\fP program can be used to view and select fonts that 
have XLFD names.
.RE
.LP
This release been built on the following operating systems:
Ultrix 3.1 (both VAX and RISC), SunOS 4.0.3, HP-UX 6.5, Domain/OS 10.1,
A/UX 1.1, AIX RT-2.2 and PS/2-1.1, AOS-4.3, UTEK 4.0, NEWS-OS 3.2,
UNICOS 5.0.1, and UNIX System V, Release 3.2 (AT&T 6386 WGS).
It should work correctly, or with a minor amount of work, on a variety of 
other systems as well.
Before building the release, see the \fIREADME\fP files in 
\fImit/config/\fP and \fImit/server/ddx/*/\fP, for any special
instructions.
.FS
\(dd Ultrix and VAX are trademarks of Digital Equipment Corporation;
SunOS is a trademark of Sun Microsystems, Inc.; HP-UX and Domain are
trademarks of the Hewlett-Packard Company; 
PostScript is a trademark of Adobe Systems, Inc.; 
A/UX is a trademark of Apple Computer;
UNICOS is a trademark of Cray Research; 
AIX and AOS are trademarks of the IBM Corporation;
UNIX is a registered trademark of AT&T Bell Laboratories;
OPEN LOOK is a trademark of AT&T;
Times, Helvetica, and New Century Schoolbook are registered trademarks of
Linotype; Lucida is a registered trademark of Bigelow & Holmes;
and Charter is a registered trademark of Bitstream, Inc.
.FE
.NH 1
Building the Release
.LP
The software in this release is divided into two distributions:
one for the \fIcore\fP software that is supported by the staff 
of the X Consortium (located in the directory tree \fI./mit/\fP), 
and one for \fIuser-contributed\fP software containing everything else
(located in the directory tree \fI./contrib/\fP).
Great pains have been taken to make the core 
distribution easy to reconfigure, build and install on a wide range of 
platforms.  The user-contributed distribution, on the other hand, has not
been compiled or tested by the staff of the X Consortium and will
require building by hand.  With the addition of function prototypes in
the Xlib include files, it is virtually certain that some user-contributed
will fail to compile under picky compilers (such as \fIhc\fP).
.LP
Almost all \fIMakefiles\fP in the core software
are generated automatically by a utility called
\fIimake\fP.  The program combines machine-independent descriptions (called
\fIImakefiles\fP) of targets to be built 
with machine-dependent sets of parameters.
Initial versions of all of the \fIMakefiles\fP are included
for those sites that cannot use \fIimake\fP (they will undoubtedly
require patching for specific machines).  However, on many systems, 
X should build correctly right off the tape.
For the user-contributed distribution, and for your own applications,
the \fIxmkmf\fP script in \fImit/util/scripts/\fP
can be used to build a \fIMakefile\fP from an \fIImakefile\fP
once the core has been built and installed.
.LP
.NH 2
Installation Summary
.LP
To load and install this release of the X Window System, you will need to:
.\".ll -5
.\".in +5
.ne 4
.IP 1.
Finish reading these Release Notes.
.IP 2.
Create a directory into which you will read the distribution tapes (usually
named something like \fI/usr/local/src/X\fP or \fI/src/R4/\fP).  You will need
roughly 50 megabytes to hold the core software and up to 90 megabytes for
the user-contributed software.  Note that compiling will require anywhere
from 50 to 110% more disk space, depending on your machine (e.g. RISC vs.
CISC and whether or not you have shared libraries).
.IP 3.
Unload the core tape into the directory created in step #2.  Since the
user-contributed software must be built by hand, you may wait and load it
in later.  Each of the tapes contains one (very large) UNIX \fItar\fP file 
stored at 1600 bits per inch.  
.IP 4.
Read the file \fImit/config/README\fP for instructions on how to
configure the build for your particular site.  Also, make sure that you 
follow the directions in \fIREADME\fP files in \fImit/server/ddx/\fP 
directories for which you plan to build servers.  In particular, you
must make sure that the \fIOSMajorVersion\fP and \fIOSMinorVersion\fP
configuration parameters, as well as those indicated at the top of
\fImit/config/site.def\fP, are appropriate for your system.
.IP 5.
If you plan to compile the release on more than one machine and have a 
distributed file system, you may wish to use the
script \fImit/util/scripts/lndir.sh\fP to create symbolic link trees on each of
the target machines.  This allows all of the platforms on which you wish
to run X to share a single set of sources.  In either case, the phrase
\fIbuild tree\fP will be used to refer to the directory tree in 
which you are compiling (to distinguish it from the \fIsource tree\fP
which contains the actual files).
.IP 6.
If you are building on a Macintosh II, make sure you read the file
\fImit/server/ddx/macII/README\fP and follow the directions for running the
\fIX11R4\fP script in that directory.  If you are using GNUC on the Mac
(highly recommended; sources are available for anonymous ftp from the machine
\fIapple.com\fP), you will need to remove the \fI"-s"\fP flag on the 
\fIegrep\fP command in the GNUC \fIfixincludes\fP script.  Otherwise, you
will have to build and install the C preprocessor in \fImit/util/cpp/\fP.
.IP 7.
If you are running on a VAX or 680x0 processor, you should consider using the
GNU C compiler (available via anonymous ftp from the machine
\fIprep.ai.mit.edu\fP) to compile the server.  It can result in up to a 
factor of 2 improvement in performance.  See the \fIHasGcc\fP parameter
in the files \fIsun.cf\fP,
\fIultrix.cf\fP, \fImacII.cf\fP, and \fIsite.def\fP in \fImit/config/\fP
.IP 8.
Check the \fIimake\fP configuration parameters in \fImit/config/imakemdep.h\fP
and \fImit/config/Imake.tmpl\fP.
.IP 9.
Once you are satisfied with the configuration, you are ready to build the
core distribution.  Look at the \fI.cf\fP file for your system.
There may be a line in it that sets an \fImake\fP variable named
\fIBootstrapCFlags\fP.
If you don't find such a variable, you can use the following command to
start the build:
.DS
%  make World >& make.world &
.DE
If you do find the variable,
you should append that definition to the command line, using the
\fImake\fP variable BOOTSTRAPCFLAGS.
This is used by \fIimake\fP to set particular \fIcpp\fP symbols for all
compiles (if you are porting to a different platform, see
\fImit/util/imake/imakemdep.h\fP).  Special BOOTSTRAPCFLAGS are required
on the following systems for which \fI.cf\fP files are supplied:
MacII, AT&T 6386, IBM workstations, and the Tektronix 4310 series.  For 
example:
.DS
%  make BOOTSTRAPCFLAGS=-DmacII\ \ World\ \ >& make.world &
.DE
Do not call the output file \fImake.log\fP as the \fImake clean\fP done by
\fImake World\fP removes all files of this name.  This will rebuild all of
the \fIMakefiles\fP and execute a \fImake -k all\fP to compile everything 
in the core distribution.  This will take anywhere from 15 minutes (on a
Cray Y-MP) to 12 hours, depending on your machine.
.IP 10.
When the \fImake\fP is done, check the log file for any problems.  There should
be no serious errors.  A/UX \fIpcc\fP users can ignore compiler warnings about 
enumeration type clashes, and Apollo and IBM users can ignore optimizer
warnings.  Most
optimizers will also give warnings about the C code that is generated by
\fIlex\fP and \fIyacc\fP in \fImit/clients/twm\fP; these may be safely ignored.
.IP 11.
If you are satisfied that everything has built correctly, 
test the various critical programs (servers, \fIxterm\fP, \fIxinit\fP,
etc.) by hand.  You may need to be root to run the server or \fIxterm\fP.
A second workstation or terminal will be particularly useful if you run
into problems.
.IP 12.
Make backup copies of your old X header files, binaries, fonts, libraries, etc.
.IP 13.
Go to the top of the build tree and type
.DS
#  make install\ \ >& make.install
.DE
You will either have to do this as root, or have write access to the
appropriate directories (see DIRS_TO_BUILD in the top level \fIImakefile\fP and
\fImit/config/Imake.tmpl\fP).  The
\fIxterm\fP program should be installed setuid to root on most systems and
the \fIxload\fP program should be installed setgid to whichever group the
file \fI/dev/kmem\fP belongs to (it is installed setuid to root by default).
.IP 14.
If you would like to install the manual pages, type the following at the
top of the build tree:
.DS
#  make install.man
.DE
.IP 15.
If you would like to create and install lint libraries, type the following
at the top of the build tree:
.DS
%  make install.ln
.DE
.\".in -5
.\".ll +5
.LP
If you are installing X for the first time, you may also need to do 
some of the steps listed below.
Check the various README files in the \fImit/server/ddx\fP directories
for additional instructions.
.\".ll -5
.\".in +5
.IP 16.
Add device drivers or reconfigure your kernel.
.IP 17.
Create additional pseudoterminals.  See your operating system 
script \fI/dev/MAKEDEV\fP and site administrator for details.
.IP 18.
Read the manual page for the Display Manager \fIxdm\fP and configure it
for your site.  This program
provides a portable way of running X automatically and has many hooks for
creating a nice interface for novice users.  \fBWarning: the \-L
flag is no longer supported by xterm.  If you are running xterm
from /etc/init you will have to convert to xdm or else save your
old binary.\fR
.IP 19.
Make sure that all X11 users have the directory \fI/usr/bin/X11\fP
in their search paths.
.IP 20.
Give it a try!
.\".in -5
.\".ll +5
.LP
Release 4 of Version 11 of the X Window System should now be ready to use.
.LP
.ne 12
.NH 2
Operating System Requirements
.LP
One of the reasons why X is so popular is that it does not require very much
operating system support.
Although this distribution only contains sample implementations for BSD
and UNIX derivative platforms, support for other operating 
systems is available from a wide variety of vendors.  The servers in this 
release have been built on the following systems:
.sp
.ce 8
Ultrix 3.1 (both VAX and RISC)
SunOS 4.0.3
HP-UX 6.5
Domain/OS 10.1
A/UX 1.1
AIX RT-2.2 and PS/2-1.1
IBM AOS-4.3
UTEK 4.0
.sp
The client libraries and applications have been built on all of the above
systems, plus:
.sp
.ce 3
NEWS-OS 3.2
UNICOS 5.0.1
UNIX System V, Release 3.2 (AT&T 6386 WGS)
.sp
If you are using versions prior to these, you may well run into trouble.
In particular, the server will not run on IBM 4.2A release 2 and there
is no longer support for Apollo SR9.7.  The \fIREADME\fP
files in the various \fImit/server/ddx/\fR describe particular requirements 
such 
as compilers, libraries, preprocessors, etc.  As was noted above, 
A/UX 1.0 users will need to build a new version of the C preprocessor.
.LP
You should verify that your networking and interprocess 
communication facilities are working properly before trying to use X.
If programs such as \fItalk\fP and \fIrlogin\fP don't work, X probably
won't either.
.LP
.NH 2
Reading in the Release Tapes
.LP
This release may be obtained electronically from the Internet, 
the UUNET Project, several consulting firms, 
and various UUCP archive sites.  In addition, 
a set of 2400 foot, 1600 BPI magnetic tapes (MIT does not distribute
on cartridge tapes or floppy disks)
and printed documentation is available from the
MIT Software Center; call (617) 258-8330 for details.
.LP
Each tape from MIT contains one large \fItar\fP archive with
software and documentation for part of the release.
If you have a limited amount of disk space, you should load tape #1,
prune out any servers that you don't need, and generate listings of the 
user-contributed tapes for later retrieval.  In particular, you will 
probably want to extract the \fImit/doc\fP directory from tape #2.
All filenames are given as relative paths (i.e. beginning
with a period instead of a slash) so that the release may be placed anywhere
in your file system.
.LP
.ne 8
Before reading in the tapes, make sure that you have enough disk space.  Each
of the tapes contains roughly 35 megabytes, split as follows:
.sp
.\"    tbl me!
.TS
center tab (/) ;
c l l .
\fITape #/Contents/Status\fP

1/core software for \fImake World\fP/required
2/core docs and contrib clients/recommended
3/contrib libs and toolkits/optional
4/contrib Andrew and games/optional
.TE
.sp
The compiled versions of the programs will occupy yet again as much 
disk space (particularly on RISC machines without shared libraries),
so plan accordingly.
.LP
Create a directory into which you will put all of the sources.  In this 
directory, execute the appropriate operating system commands to read in the
core tapes.  If your site is set up so that \fItar\fP uses a 1600bpi tape
drive by default, you will probably type something like:
.ne 6
.sp
.DS
%  mkdir /usr/local/src/X
%  cd /usr/local/src/X
%  tar xv
.DE
.sp
See your system administrator for help.
.LP
.NH 2
Using Symbolic Links
.LP
This release uses links (symbolic, on machines that support them) in 
several places to avoid duplication of certain files (mostly header files).  
If you are building this release on a system
for which configuration files have not been supplied, you should check
the LN configuration parameter in the appropriate
\fImit/config/*.cf\fP file.  If your operating
system does not support soft links, LN should be set either to create hard
links or to copy the source file.
.LP
If you need to move the release to another machine after it has been built,
use \fItar\fP instead of \fIcp\fP or \fIrcp\fP so that you 
preserve dates and links.  This is usually done with a command of the form:
.sp
.DS
%  (chdir /usr/local/src/X; tar cf - .) | rsh othermachine "(chdir /moredisk/X; tar xpBf -)"
.DE
.sp
See your system administrator for help.
.LP
.NH 2
Configuring the Release
.LP
This release makes extensive use of a utility called \fIimake\fP to generate
machine-specific \fIMakefiles\fP from machine-independent \fIImakefiles\fP.
Another utility, called \fImakedepend\fP, is used to generate \fIMakefile\fP
dependencies for C language files.  
Sample \fIMakefiles\fP are provided, although you are strongly urged to
use \fIimake\fP and \fImakedepend\fP so that your software works across
releases.
.LP
The configuration files for \fIimake\fP are located in the directory
\fImit/config/\fP.  \fIMakefiles\fP are created from a template file
named \fIImake.tmpl\fP, a machine-specific \fI.cf\fP file, and a
site-specific \fIsite.def\fP file.  With only a few exceptions, configuration
parameters are \fIcpp\fP symbols that may be defined on a per-server basis
or for all servers in a given site.  The template file should \fInot\fP be
modified.
.LP
.ne 10
The file \fImit/config/README\fP describes each of the build 
parameters.  The defaults have been chosen
to work properly on a wide range of machines and to be easy to maintain.
An overview of the configuration system may be found in the file
\fImit/doc/config/usenixws/paper.ms\fP.
Site-specific configurations should be described in the file \fIsite.def\fP
using the following syntax:
.DS
#ifndef \fIBuildParameter\fP
#define \fIBuildParameter\fP \fIsite-specific-value\fP
#endif
.DE
.LP
.NH 2
Compiling the Release
.LP
Once the configuration parameters are set, you should be able to type the
following command at the top of the build tree to compile the core software:
.DS
%  make World\ \ >& make.world\ \ &
.DE
Remember to set BOOTSTRAPCFLAGS if your system needs it.
Don't redirect the output to \fImake.log\fP as this
particular file is deleted as part of the build process.
This will take anywhere up to 24 hours, depending on the machine used,
and should complete without any significant errors on most machines.
.LP
If you need to restart the build after all of the \fIMakefiles\fP 
and dependencies have been
created, type the following command at the top of the build tree:
.DS
%  make -k >& make.out &
.DE
If you later decide to change any of the configuration parameters, you'll need
to do another full \fImake World\fP.
.LP
.NH 2
Installing the Release
.LP
If everything compiles successfully, you may install the software by 
typing the following as root from the top of the build tree:
.DS
#  make install
.DE
If you would rather not do the installation as root, make the necessary
directories writable by you and do the install from your account.  Then, 
check the ownership and protections on \fIxterm\fP and \fIxload\fP in 
the BINDIR directory (usually \fI/usr/bin/X11/\fP): on most systems
\fIxterm\fP must be 
installed setuid to root so that it can set the ownership of its
pseudoterminal
and update \fI/etc/utmp\fP, and \fIxload\fP needs to be setuid to root or
setgid to the group owning the file \fI/dev/kmem\fP so that it can get
the system load average.
.LP
If your \fI/etc/termcap\fP and \fI/usr/lib/terminfo\fP databases don't have 
entries for \fIxterm\fP, sample entries are provided in the directory
\fImit/clients/xterm/\fP.  System V users may need to compile and install the 
\fIterminfo\fP entry with the \fItic\fP utility.
.LP
If you plan to use the \fIxinit\fP program to run X, you should create a
link named \fIX\fP pointing to the appropriate server program (usually
named something like \fIXmachine\fP in the directory \fI/usr/bin/X11/\fP).
However, \fIxinit\fP is not intended for most users; instead, 
site administrators are expected to either configure \fIxdm\fP or
provide user-friendly interfaces.
.LP
If you would like to have manual pages installed, check the
\fIManDirectoryRoot\fP, \fIManDir\fP
and \fILibManDir\fP configuration parameters in \fImit/config/\fP 
and type the following at the top of the build tree:
.DS
#  make install.man
.DE
.LP
If you would like to have lint libraries created and installed, type the
following at the top of the build tree:
.DS
#  make install.ln
.DE
.LP
Finally, make sure that all users have the BINDIR (usually \fI/usr/bin/X11/\fP)
in their PATH environment variable.
.LP
.NH 2
Notes on Kernels and Special Files
.LP
On some machines, it may be necessary to rebuild the kernel with a new
device driver, or to at least reconfigure it.  If you have never run X
before and are using a system not listed in these notes, you might need
verify that the CSR addresses in your kernel configuration file match
your hardware.  In addition, you should make sure that the kernel 
autoconfigures the display when booting.
.LP
You may need to create special devices for your display, mouse, or keyboard.
For example, 
.sp
.\"    tbl me!
.TS
center tab (&) ;
l c l .
#  MAKEDEV cgfour&    &# for Sun 3/60
#  MAKEDEV displays&    &# for displays on the RT/PC
.TE
.sp
The protection modes on the display device files should be set so that only 
the server can open them.  If the server is started by \fI/etc/init\fP, the
protections can be root read/write, everyone else no access; otherwise, they 
will have to be read/write for everyone or else your server will have to
be setuid to root.
.LP
On a Digital QVSS (VAXStation II) under older versions of Ultrix,
you may need to use \fIadb\fP to make sure 
that the kernel variable \fIqv_def_scrn\fP is set to 2 so that the full width
of the VR-260 monitor is used (otherwise there will be an unused black strip 
down the right edge of the screen).  This can be done by changing the
value either in \fI/vmunix\fP directly or in \fI/sys/vaxuba/qv.o\fP and 
relinking and reinstalling the kernel.  You will need to reboot for the new
value to take effect.
.LP
For more information, see the appropriate \fIREADME\fP files and manual pages
in the \fImit/server/ddx/\fP directories.
.LP
.NH 2
Testing the Release
.LP
Even if you plan on using \fIxdm\fP to run X all the time, 
you should first run it by hand from another terminal to 
check that everything is installed and working properly.  Error messages
from the X server will then appear on your terminal, rather than being written
to the \fIxdm-errors\fP or to 
\fI/usr/adm/X?msgs\fP (where \fI?\fP is the number of the display).  
.LP
The easiest way to test the server is to go to \fI/usr/bin/X11\fP (or wherever
you have installed the various X programs), and run \fIxinit\fP as follows:
.sp
.DS
%  cd /usr/bin/X11
%  xinit
.DE
.sp
If all is well, you should see a gray stipple pattern covering the screen,
a cursor shaped like an ``X'' that tracks the pointer, and a terminal
emulator window.  Otherwise, check the following:
.IP 1.
If the gray background doesn't appear at all, check the
permissions on any special device files (usually stored in \fI/dev/\fP)
described in the \fIREADME\fP in the appropriate \fImit/server/ddx/\fP 
subdirectories.
.IP 2.
If the background appears, but the cursor is a white square that doesn't
change, make sure that the fonts have been installed (in particular,
the font named \fIcursor.snf\fP in the directory
\fI/usr/lib/X11/fonts/misc/\fP; see the configuration parameter
\fIDefaultFontPath\fP).  Also make sure that there is a file named
\fIfonts.dir\fP in each font directory.  This file is created by the
\fImkfontdir\fP program and is used by the server to find fonts in a
directory.
.IP 3.
If the cursor appears but doesn't track the pointer, make sure that any
special device files (often named something like \fI/dev/mouse\fP)
are installed (see the server's \fIREADME\fP file).  
.IP 4.
If the server starts up and then goes black a few seconds later, the initial
client (usually \fIxterm\fP or \fIxdm\fP) is dying.  Make sure that \fIxterm\fP
is installed setuid to root and that you have created enough pseudoterminals.
If you are running \fIxinit\fP,  and have a file named \fI.xinitrc\fP in your
home directory, make sure that it is executable and that the last program
that it starts is run in the foreground (i.e. that there is no ampersand
at the end of the line).  Otherwise, the \fI.xinitrc\fP will finish
immediately, which \fIxinit\fP assumes means that you are through.
.LP
.ne 8
Once you have the initial window working properly, try running some other
programs from the \fIxterm\fP.  To position a new window with
the \fItwm\fP window manager, press Button1 (usually the left-most button on
the pointer) when the flashing rectangle appears:
.sp
.DS
%  xclock -g 200x200-0+0 &
%  twm &
%  xlogo &
%  xeyes &
\&\.\.\.
.DE
.LP
X should now be ready to use.  Read the manual pages for the new programs,
look at the new fonts, and have fun.
.LP
.ne 12
.NH 2
Creating Extra Pseudoterminals
.LP
Since each \fIxterm\fP will need a separate pseudoterminal, you should create a
large number of them
(you probably will want at least 32 on a small, multiuser system).
Each pty has two devices, a master and a slave, which are usually
named /dev/tty[pqrstu][0-f] and
/dev/pty[pqrstu][0-f].  If you don't have at least the ``p'' and ``q'' lines
configured (do an ``ls /dev''), you should have your system administrator add
them.  This is often done by running the MAKEDEV script in \fI/dev\fP:
.DS
#  cd /dev
#  ./MAKEDEV pty0
#  ./MAKEDEV pty1
.DE
.LP
.NH 2
Starting X from /etc/rc
.LP
The X Display Manager is used to run the X server and initial login window.
It is normally started from the system startup file \fI/etc/rc\fP, and is
designed to be
easily tailored to the needs of each specific site.  \fIXdm\fP takes care of
keeping the server running, prompting for username and password and
managing the user's session.  The sample configuration currently uses shell 
scripts to provide a fairly simple environment.  This will be an area of
continuing work in future releases.
.LP
The key to \fIxdm\fP's flexibility is its extensive use of resources, allowing
site administrators to quickly and easily test alternative setups.  When
\fIxdm\fP starts up, it reads a configuration file (the default is
\fI/usr/lib/X11/xdm/xdm-config\fP but can be specified with the \fI-config\fP
command line flag) listing the names of the various datafiles, default
parameters, and startup and shutdown programs to be run.  Because it uses the 
standard X Toolkit resource file format, any parameters that may be set
in the \fIxdm-config\fP file may also be specified on the command line using
the standard \fI-xrm\fP option.  
.LP
.ne 10
The default configuration contains the following lines:
.sp
.\"    tbl me!
.TS
center tab (&) ;
l c l .
DisplayManager.servers: &    &/usr/lib/X11/xdm/Xservers
DisplayManager.errorLogFile: &    &/usr/lib/X11/xdm/xdm-errors
DisplayManager*resources: &    &/usr/lib/X11/xdm/Xresources
DisplayManager*startup: &    &/usr/lib/X11/xdm/Xstartup
DisplayManager*session: &    &/usr/lib/X11/xdm/Xsession
DisplayManager*reset: &    &/usr/lib/X11/xdm/Xreset
.TE
.sp
The \fImit/servers\fP file contains the list of
servers to start.  The \fIerrorLogFile\fP is where output from \fIxdm\fP
is redirected.  The \fIresources\fP file contains default resources for
the \fIxdm\fP login window.  In particular, this is where special key sequences
can be specified (in the \fIxlogin*login.translations\fP resource).  The
\fIstartup\fP file should be a program or executable script that is run
after the user has provided a valid password.  It is a hook for doing
site-specific initialization, logging, etc.  The \fIsession\fP entry is the
name of a session manager program or executable script that is run to start
up the user's environment.  A simple version has been supplied that provides
an \fIxterm\fP window and \fItwm\fP window manager if the user does not
have an executable \fI.xsession\fP file in his or her home directory.  Finally,
the \fIreset\fP program or executable script is run after the user logs out.
It is a hook for cleaning up after the \fIstartup\fP program.
.LP
To run \fIxdm\fP using the default configuration, add the following line to
your system boot file (usually named \fI/etc/rc\fP or \fI/etc/rc.local\fP):
.DS
/usr/bin/X11/xdm
.DE
Most sites will undoubtedly want to build their own configurations.  We 
recommend that you place any site-specific \fIxdm-config\fP and other
\fIxdm\fP files in a different directory so that they are not overwritten
if somebody ever does a \fImake install\fP.  If you were to store the files
in \fI/usr/local/lib/xdm\fP, the following command could be used to 
start \fIxdm\fP:
.DS
/usr/bin/X11/xdm -config /usr/local/lib/xdm/xdm-config
.DE
.LP
Many servers set the keyboard to do non-blocking I/O under the assumption that
they are the only programs attempting to read from the keyboard.
Unfortunately, some versions of \fI/etc/getty\fP (A/UX's in particular) will
immediately see a continuous stream of zero-length reads which they interpret 
as end-of-file indicators.  Eventually, \fI/etc/init\fP will disable logins 
on that line until somebody types the following as root:
.DS
#  kill -HUP 1
.DE
Under A/UX, one alternative is to disable logins on the console 
and always
run \fIxdm\fP from \fI/etc/inittab\fP.  However, make sure that you save
a copy of the old \fI/etc/inittab\fP in case something goes wrong and you
have to restore logins from over the network or from single-user mode.
.LP
Another less drastic approach is to set up an account whose shell is the
\fIxdmshell\fP program found in \fImit/clients/xdm/\fP.  This program is not
installed by default so that site administrators will examine it to see if
it meets their needs.  The \fIxdmshell\fP utility makes sure that it is 
being run from the appropriate type of terminal, starts \fIxdm\fP, waits for
it to finish, and then
resets the console if necessary.  If the \fIxdm\fP resources file
(specified by the \fIDisplayManager*resources\fP entry in the 
\fIxdm-config\fP file) contains a binding to the \fIabort-display\fP action
similar to the following
.DS
xlogin*login.translations: #override  Ctrl<Key>R: abort-display()
.DE
the console can then by restored by pressing the indicated key 
(Control-R in the above example) in the \fIxdm\fP login window.
.LP
.ne 10
The \fIxdmshell\fP program is usually
installed setuid to root but executable only by members of a special group,
of which the account which has \fIxdmshell\fP as its shell is the only member:
.DS
%  grep xdm /etc/passwd
x:aB9i7vhDVa82z:101:51:Account for starting up X:/tmp:/etc/xdmshell
%  grep 51 /etc/group
xdmgrp:*:51:
%  ls -lg /etc/xdmshell
-rws--x---   1 root     xdmgrp     20338 Nov  1 01:32 /etc/xdmshell
.DE
.LP
If the \fIxdm\fP resources have not been configured to have a key bound to
the \fIabort-display()\fP action, there will be no way for general users to
login to the console directly.  Whether or not this is desirable depends on
the particular site.
.ne 8
.NH 1
How to Report Bugs or Request Enhancements
.LP
If you find a \fIreproducible\fP bug in the core distribution supported by MIT 
(i.e. not in \fIcontrib/\fP) or would like to suggest an
enhancement (preferably with sample code), please fill in a copy of the form
located in \fImit/doc/bugs/bug-report\fP and mail it to:
.sp
.ce
\fIxbugs@expo.lcs.mit.edu\fP
.sp 
Please fill in all sections (even if the bug appears on all systems) and
please include any test cases; a small sample program is almost always
the best information we can receive.
Sites that do not have access to the various 
.ne 7
networks may send printed copies of bug reports and tests cases to:
.sp
.ce 6
X Bugs
X Consortium
MIT Laboratory for Computer Science
room NE43-218
545 Technology Square
Cambridge, MA  02139
.sp
Bug reports that are not sent in electronic form cannot be guaranteed a 
response.  Also, any media containing bug reports, contributions, etc. will
not be returned.
.LP
Bugs in user-contributed software should be sent to the author of the 
particular program, \fBnot\fP to the address listed above.
The X Consortium will not track or forward bugs in code located
in \fIcontrib/\fP.

.ne 6
.NH 1
What's New in this Release
.LP
The primary focus of this release has been optimization of the server
and improvements in the key applications.
.NH 2
Changes to the core distribution
.LP
The following additions, deletions, and modifications have been made to the
software in the core distribution.  Widget writers should read the new
X Toolkit Intrinsics specification.
Application developers who use the Athena Widget Set should read the
list of changes in the file \fImit/lib/Xaw/CHANGES\fP and the conversion
document \fImit/doc/Xaw/ConvertToR4\fP, and read the new
\fIAthena Widget Set\fP documentation.
.\".ll -5
.\".in +5
.IP "many, many bugs fixed"
.br
A large number of bugs have been fixed in the server, the libraries, 
and the clients.  Servers are now robust enough that they have been known
to run for more than 3 months without experiencing any problems.  The
server is now much stricter about disallowing extraneous bits in masks 
(particularly the \fIdo_not_propagate_mask\fP window attribute), causing
some improperly coded applications to generate protocol errors.  A new,
non-standard extension is provided (see \fIxset bc\fP) to enable 
backwards-compatibility for broken clients.
.IP "server optimized, data space reduced"
.br
A substantial number of optimizations to both the device-independent (dix)
and device-dependent (ddx) code.  The monochrome (mfb) and color (cfb) frame
buffer code is now capable of driving many displays at memory speeds.  In
addition, the amount of heap memory that is used by the server has been
reduced by roughly two-thirds since the last release.
.IP "SHAPE extension"
.br
Non-rectangular windows are now supported by the new SHAPE
extension.  Round windows such as round clocks (see \fIoclock\fP),
oval buttons (see \fIxmh\fP and \fIxcalc\fP), and shaped desktop icons (see 
\fIxbiff\fP) are now possible.  This extension is a Consortium standard.
.IP "prototype extensions"
.br
Prototypes of two extensions that are currently under development are 
provided in this release.  The \fIMulti-Buffering\fP extension provides
the ability to do simple animation (see \fIico -dbl\fP), and the 
\fIXInputExtension\fP provides
access to alternate input devices.  These extensions are \fBdraft\fP 
Consortium standards and are subject to change.
.IP "build configuration moved and simplified"
.br
The configuration files have been moved to \fImit/config/\fP and have been
rewritten to make better use of preprocessor symbols and macros.  Support
for System V with and without the STREAMS transport layers has been added.
.IP "new servers"
.br
New support has been added to the sample server for the following platforms:
Sun \fIcgthree\fP and \fIcgsix\fP frame buffers, Digital DECstation
frame buffers, Tektronix 4319 frame buffer, and all HP framebuffers.
Reorganizations within the machine-independent (mi) graphics code make porting
to new platforms even easier than it was before.
.IP "security hooks"
.br
Programming hooks in \fIXlib\fP and the server are provided for passing
authorization information at connection setup time.  A sample implementation
(called MIT-MAGIC-COOKIE-1) based on secret tokens is used by \fIxdm\fP and
the server to provide greater security than the host-based mechanism.
.IP "new fonts"
.br
Adobe Systems and Digital Equipment Corporation have jointly donated 
100dpi versions of the 75dpi fonts that they provided in the last release.
In addition, Digital has donated a set of terminal emulator fonts.
Bigelow & Holmes and Sun Microsystems have jointly donated a collection
of fonts from the \fILucida\fP family.  Sun has also donated a set of
OPEN LOOK glyph fonts.  Sony has donated a set of Kanji and Kana fonts,
and several individuals have donated additional fixed-width fonts.
.IP "ICCCM support"
.br
\fIXlib\fP, the \fIX Toolkit Intrinsics\fP, \fItwm\fP, and various clients are
now hoped to be ICCCM-compliant.  The following window managers in
\fIcontrib/windowmgrs/\fP also claim to be compliant: \fIgwm\fP, \fIolwm\fP,
and \fItekwm\fP.
.IP "new rgb color database"
.br
A new color database containing many new colors, gray scales, and
color spectra tuned for some of the common monitors is included.
.IP "function prototypes"
.br
ANSI C function prototypes have been added to the \fIXlib\fP and \fIXt\fP 
header files;
the include files should now also be usable from C++ without modification.
The \fIXlib\fP prototypes are enabled by default (on systems that support 
them),
while the \fIXt\fP prototypes are disabled (they were added too late in our
release cycle).  Picky compilers (such as \fIhc\fP) will now catch many
type incompatibilities.
.IP "shared libraries"
.br
Support for SunOS-style shared libraries has been added to \fIXlib\fP,
\fIXt\fP, \fIXaw\fP, and \fIXmu\fP.  This substantially reduces the amount
of disk spaced used for executable programs.
.IP "new Xt Intrinsics"
.br
The \fIX Toolkit Intrinsics\fP now provide windowless objects,
varargs-style interfaces, better caching of resources, fallback resources,
locale-driven finding of data files.
.IP "Athena widget enhancements"
.br
Most of the \fIXaw\fP library has been rewritten to substantially improve 
functionality, robustness, and performance.  New \fBSimpleMenu\fP and
\fBMenuButton\fP widgets support pop-up and pull-down menus.  The \fBText\fP
widget has been rewritten and is now quite usable for general editing.
The \fBVPaned\fP widget has been generalized to include horizontal paning
(and is now called \fBPaned\fP).  The \fBLabel\fP widget now supports 
multi-line labels.  A new \fBToggle\fP widget has been provided for
implementing radio-buttons.  Finally, the \fBCommand\fP widget has been
enhanced to use the SHAPE extension to provide true round buttons.
.IP "standard colormap routines"
.br
A new set of routines for manipulating standard colormaps (see the
\fIXStandardColormap\fP structure in the \fIXlib\fP documentation)
has been added to the \fIXmu\fP library.  The \fIxstdcmap\fP client
uses these routines to create standard colormaps.
.IP "additional converters"
.br
A variety of new converters have been added to \fIXmu\fP.  In addition,
multi-display programs should now be able to use these converters (and
might find the utilities for managing the multiple display data structures
useful).
.IP "new window manager"
.br
The \fIuwm\fP window manager has been moved from the core distribution
to the user-contributed distribution.  A substantially rewritten version
of the \fItwm\fP window manager is now supported.
.IP "improvements in xdm"
.br
The \fIxdm\fP display manager has been rewritten to reduce the number of
processes it requires and to make it much more robust.  This is now the
only supported means for starting the server at boot time (the \fI-L\fP
command line option has been removed from \fIxterm\fP).
.IP "new utilities"
.br
Several new utility programs have been provided:  \fIappres\fP for determining
which resources are loaded into particular applications, \fIlistres\fP for
printing the resource hierarchy for a widget, \fIoclock\fP for people who
like truly round clocks, \fIxauth\fP for manipulating authorization files,
\fIxditview\fP for previewing \fIditroff\fP files, \fIxfontsel\fP for 
interactively selecting fonts, \fIxlsatoms\fP for determining the value
of various atoms, \fIxlsclients\fP for listing the clients currenting being
run, and \fIxstdcmap\fP for manipulating standard colormaps.
.IP "new demos"
.br
A new demo of how various GC attributes (\fIxgc\fP) affect what is displayed
on the screen is provided.
.IP "new features in \fIxterm\fP"
.br
The following features have been added to \fIxterm\fP:  8-bit input and output,
on-the-fly changing of the current font through escape sequences and a new
menu, new resources for controlling whether or not synthetic key events are
ignored, increased portability, and improved menus using the new Athena
\fBSimpleMenu\fP widget.
.IP "new CLX and documentation"
.br
A substantially improved version of CLX, the Common Lisp interface to X,
is provided.  In addition, comprehensive documentation of the CLX interface
is provided, courtesy of Texas Instruments.
.IP "sample copyright notice in \fImit/COPYRIGHTS\fP"
.br
The file \fImit/COPYRIGHTS\fP in the top level directory contains a sample
copyright notice recommended for people who are interested in contributing
software to the public releases.
.IP "X Standards in \fImit/Standards.man\fP"
.br
The \fIXStandards(1)\fP manual page contains a description
of what is and is not an MIT X Consortium standard for the X Window
System.  For further information about the X Consortium, see the manual
page \fIXConsortium(1)\fP.
.NH 2
Highlights of the User-Contributed Distribution
.LP
The user-contributed distribution is set up in a tree very similar to 
that used by the core distribution.  New versions of several packages are
available, and a variety of new donations have been received.  Since this is
\fBnot\fP a superset of the previous user-contributed tape, sites are
encouraged to save any R3 user-contributed software that they use.  Note that
this distribution is of no relation to the \fI/contrib\fP directory available
for anonymous ftp on \fIexpo.lcs.mit.edu\fP.
.IP "XView and olwm"
.br
The \fIXView\fP toolkit and an ICCCM-compliant OPEN LOOK window manager
from Sun Microsystems have been added to this release.
This toolkit implements the OPEN LOOK graphical user interface
guidelines and the SunView application programming interface.
.IP "Gwm"
.br
The \fIGeneric Window Manager\fP from Groupe Bull has been added.  Unlike
other window managers, \fIgwm\fP provides a programming language for
tailoring its user interface.  It is believed to be ICCCM-compliant.
.IP "Tektronix Window Manager"
.br
The \fITektronix Window Manager\fP, derived from the \fIawm\fP window
manager in the previous release, is also new to this release.  Like \fIgwm\fP
and \fIolwm\fP, \fItekwm\fP is believed to be ICCCM-compliant.
.IP "Sigma toolkit and window manager"
.br
The Sigma Project has donated its Sigma User Interface Toolkit (SUIT) and
window manager (\fIm_swm\fP).
.IP "toolkits updated"
.br
New versions of \fIInterViews\fP, \fIXw\fP, \fIandrew\fP, and \fIclue\fP
are included.  New toolkits include: \fIxgks\fP and \fIXcu\fP.
.IP "Serpent UIMS"
.br
The \fISerpent\fP user interface management system is included in this
release.
.IP "new libraries"
.br
Several libraries for doing Japanese input (see \fIXJ\fP and \fIWnn\fP),
multi-language input (see \fImlx\fP and \fIim\fP), and compose processing
(see \fIXCompose\fP) are provided.
.IP "new programming examples"
.br
The examples from the O'Reilly and Associates books on \fIXlib\fP and \fIXt\fP
have been provided.
.IP "new demos"
.br
A variety of eye-catching demos have been added.
.IP "new clients"
.br
A number of useful packages have been added: image analysis (see \fINCSA\fP
and \fIimg\fP), multi-language libraries and utilities (see \fIkinput\fP,
\fIkterm\fP, and \fImlxterm\fP), a user interface prototyping system (see
\fIwinterp\fP), plus improved versions of \fIxfed\fP, \fIxcolors\fP, 
\fIxpic\fP, \fIxplaces\fP, \fIxtek\fP (formerly \fItexx\fP), \fIxtroff\fP,
and \fIxwebster\fP.
.IP "games"
.br
A variety of new games have been contributed since the new release.
.NH 1
Writing Portable X Software
.LP
A favorite saying around here goes:  There's no such thing as portable
software, only software that has been ported.  However, there are few rules
of thumb that go a long way towards making programs written for X easy to
getting running on a wide variety of machines:
.IP 1.
Keep all source filenames to 12 characters or less.  This is the maximum
number of characters that older System V file systems allow when using
a source code control system.
.IP 2.
Use \fIImakefiles\fP.  They are the only way to generate 
correct \fIMakefiles\fP.
The \fIxmkmf\fP shell script in \fImit/util/scripts/\fP makes it
trivial create \fIMakefiles\fP outside of the core source tree.
The easiest way to construct an \fIImakefile\fP is to start with one that
does something similar and modify it.  The various macros that are used 
are defined in the file \fImit/config/Imake.rules\fP.
.IP 3.
If you absolutely must use \fIMakefiles\fP instead of \fIImakefiles\fP,
link against \fI-lX11\fP instead of \fI-lX\fP.  If you are using \fIimake\fP,
use the symbolic names $(XAWLIB), $(XMULIB), $(XTOOLLIB), 
$(EXTENSIONLIB), and $(XLIB).  \fIXaw\fP clients may use the symbol
\fPXawClientLibs\fP to refer to the appropriate libraries.
.IP 4.
Include header files using the syntax \fI<X11/file.h>\fP instead of 
\fI"X11/file.h"\fP, \fI<X/file.h>\fP, or \fI"X/file.h"\fP.
.IP 5.
Include \fI<X11/Xos.h>\fP if you need \fItypes.h\fP,
\fIstring.h\fP or \fIstrings.h\fP (then use the routines \fIindex\fP and
\fIrindex\fP instead of \fIstrchr\fP and \fIstrrchr\fP), \fIfile.h\fP, 
\fItime.h\fP, or \fIunistd.h\fP.
.IP 6.
If you need to put in System V vs. BSD dependencies, use \fI#ifdef SYSV\fP.
If you need SVR3 vs. SVR2, use \fI#ifdef USG\fP.
.IP 7.
Do not assume that the root window's Visual (returned by the 
\fIDefaultVisual\fP macro) is the only one available.  Some color screens
may use a black and white window for the root or could provide StaticColor
as well as PseudoColor visuals.  Unfortunately, most libraries do not have 
adequate support for locating visuals to use.  In the mean time, use
\fIXGetVisualInfo()\fP.
.IP 8.
Use \fI-display displayname\fP to specify the X server to contact.  Do not
simply assume that if a command line argument has a colon in it that it is
a \fIdisplayname\fP.  If you accept command line abbreviations, make sure that
you also accept the full \fI-display\fP.
.IP 9.
Use \fI-geometry geomspec\fP to specify window geometry.  Do not simply
assume that if a command line argument begins with an equal sign that it is
a window geometry.  If you accept command line abbreviations, make sure that
you also accept the full \fI-geometry\fP.
.IP 10.
Use the \fI.man\fP suffix for program manual page sources.
.IP 11.
If you are interested in contributing software to the MIT public release,
please use a copyright notice that is no more restrictive than the one
shown in the files \fI./COPYRIGHTS\fP and \fIcontrib/COPYRIGHTS\fP.
.LP
We hope you enjoy Release 4.
