:
:        CDC 114 SYSTEM EXERCISER
:
: File - stageII.sh
:
: This is the control shell for Stage II testing.
:
: Input parameters are
:  1 Maxpass - maximum number of passes allowed.
:  2 hdexp   - hard disk expansion flag - y or n.
:  3 fdflag  - flexible disk test flag - y or n.
:  4 prflag  - serial printer flag - y or n.
:  5 nterm   - number on terminals on this system.
:  6 srcport - sending serial i/o port number, or n.
:  7 dstport - receiving serial i/o port number, or n.
:  8 p1      - process id of sleep on sending port.
:  9 p2      - process id of sleep on receiving port.
: . . . . . . . . . . . . . . . . . . . .
:
: Check for debug mode.
:
if test -f dbmode
   then set -xv
fi
: . . . . . . . . . . . . . . . . . . . .
:
: Find out how many passes the operator wants to run.
:
echo
echo Stage II. Concurrent tests.
echo How many passes do you want to run ?
    entry=bad
    until test $entry = good
      do
        echo Enter a number from 1 to $1,
        echo -n or depress [newline] or [return]
        echo -n " for an indefinite number of passes."
        read npass
        if test $npass
           then if test $npass -ge 1 -a $npass -le $1
                   then entry=good
                fi
        else { npass=$1
               entry=good
             }
        fi
      done
echo
echo If an error occurs, the test will not stop,
echo but errors will be logged, and the test will continue.
echo
echo To terminate Stage II testing at any time,
echo depress the DEL key.
: . . . . . . . . . . . . . . . . . . . .
:
: Set up the test loop so that the operator may interrupt
: testing by depressing the DEL key.
:
stopgo=go
trap 'stopgo=stop' 2
:
: Write initial entry to test log file.
:
echo -n System Exerciser Stage II. . .  >> sysck.log
date >> sysck.log
: . . . . . . . . . . . . . . . . . . . .
:
: Initialize pass number and error counters.
:
passn=1
nmemerr=0
nfcerr=0
nrderr=0
nederr=0
nfderr=0
nserr=0
sfile=display.s
: . . . . . . . . . . . . . . . . . . . .
:
: Test loop begins here.
:
until test $stopgo = stop
  do
    nerr=0
    rm -f sio.d
    echo . . . . . . . . . >> sysck.log
    echo Pass $passn . >> sysck.log
    echo
    echo Pass $passn in progress.
 
    if test $3 = y
       then fdwr.sh > fdwr.t &
    fi
    if test $6 != n
       then siochk.sh $6 $7 $sfile 2> /dev/null &
    fi
    if test $4 != n
       then cp print2.s /dev/lp &
    fi
    cp rdisk.s rdisk.d > rdisk.t &
    if test $2 = y
       then cp rdisk.s /hd1/rdisk.d > edisk.t &
    fi
    memck.o > memck.t1 &
    memck.o > memck.t2 &
    crtcntrl.sh $5 $6 $7 2 > crt.t &
    wait
    cat memck.t1 memck.t2 > memck.t
    if test -s memck.t
       then
          {  cat memck.t >> sysck.log
             echo Error in memory check. >> sysck.log
             echo Error in memory check.
             nmemerr=`expr $nmemerr + 1`
             nerr=`expr $nerr + 1`
          }
    fi
    cmp rdisk.s rdisk.d >> rdisk.t
    if test -s rdisk.t
       then
          { cat rdisk.t >> sysck.log
            echo Error in rigid disk write/read check. >> sysck.log
            echo Error in rigid disk write/read check.
            nrderr=`expr $nrderr + 1`
            nerr=`expr $nerr + 1`
          }
    fi
    if test $2 = y
       then { cmp rdisk.s /hd1/rdisk.d >> edisk.t
              if test -s edisk.t
                 then
                    { cat edisk.t >> sysck.log
                  echo Error in expansion hard disk write/read check. >> sysck.log
                      echo Error in expansion hard disk write/read check.
                      nederr=`expr $nederr + 1`
                      nerr=`expr $nerr +1`
                    }
                fi
            }
    fi
    if test $3 = y
       then { cmp rdisk.s fdisk.d > fdwr.t
              if test $? != 0
                 then
                    { cat fdwr.t >> sysck.log
                      echo Error in flexible disk write/read check. >> sysck.log
                      echo Error in flexible disk write/read check.
                      nfderr=`expr $nfderr + 1`
                      nerr=`expr $nerr + 1`
                    }
               fi
             }
    fi
    if test $6 != n
       then { cmp $sfile sio.d >> siochk.t
              if test $? != 0
                 then
                    { cat siochk.t >> sysck.log
                      echo Error in serial I/O check. >> sysck.log
                      echo Error in serial I/O check.
                      nserr=`expr $nserr + 1`
                      nerr=`expr $nerr + 1`
                    }
               fi
             }
    fi
: . . . . . . . . . . . . . . . . . . . .
:
: Check for last pass.
: If not, increment pass number.
:
    echo
    echo Pass $passn complete.
    if test $nerr = 0
       then echo No errors. >> sysck.log
    fi
    rm -f rdisk.d fdisk.d sio.d /hd1/rdisk.d edisk.t
    rm -f memck.t memck.t1 memck.t2 rdisk.t fdwr.t siochk.t crt.t
    if test $passn = $npass
       then break
       elif test $stopgo = go
            then passn=`expr $passn + 1`
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: End of test loop. Write message to test log file and crt.
:
echo . . . >> sysck.log
echo -n End of Stage II. . .  >> sysck.log
date >> sysck.log
echo
echo End of Stage II.
: . . . . . . . . . . . . . . . . . . . .
:
: Display summary information.
:
echo
echo Stage II Summary.
echo
esumm.sh $passn $nmemerr $nfcerr $nrderr $nederr $nfderr $nserr
: . . . . . . . . . . . . . . . . . . . .
:
: restore serial i/o ports to original state.
:
if test $6 != n
   then { siofin.sh $6 $7 2> /dev/null
          waketty.sh $8 $9 2> /dev/null
        }
fi
:
: . . . . . . . . . . . . . . . . . . . .
:
: Clean up file litter.
:
rm -f print2.s rdisk.s display.s
: . . . . . . . . . . . . . . . . . . . .
:
: Execute test log file display shell.
:
dlog.sh
: . . . . . . . . . . . . . . . . . . . .
:
: End of Stage II shell.
:
