#include "stdio.h"
#include "sgtty.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "sys/dir.h"

#define BLKLEN	2048
#define	TERMCH	3

#define	NAK	0
#define	ACK	1

char buf[BLKLEN+4], iline[133], qname[133], file[133], user[133], cmnd[133];
int iochan, inchan, count, cmndno, dirch, cmndch, ffflg;
long filesize;
char messno;

struct sgttyb iomode, old_iomode;
struct tchars iochar, old_iochar;

struct direct direct;
struct stat stat;

main(cmndc, cmndv)
int cmndc;
char *cmndv;
{
   inchan = 0;
   messno = '0';
   cmndno = 1;
   filesize = 0;
   ffflg = 0;

   for( count = 1; (count <= 3)&&((iochan = creat("lock",0)) == -1); count++ ) {
      sleep(5);
   };

   if (iochan == -1) return;	/* Already running once */
/*
   iochan = fork();
*/
   iochan = 0;
   if (iochan) {
      fprintf(stdout, "%d\n", iochan);
      return; /* Exit main process w/ lock intact */
   };

   dirch = open(".",0);
   if(dirch == -1) {
      fprintf(stderr, "Unable to open spool directory.\n");
      return;
   }

NXDIR:

   count = read(dirch, direct, DIRSIZ);
   if (count == 0) goto UNLNK;

   strcpy(file, &direct.d_name);
   fprintf(stdout,"Scan: %s\n",file);

   if (file[0]!='d' || file[1]!='f') goto NXDIR;

   cmndch = open(file,0);
   if (cmndch == -1) goto NXDIR;		/* Try each command file */

   sprintf(qname,"@LPT");

NXCMD:

   count = read(cmndch, cmnd, 132);		/* Get a command line    */
   if (count == 0) goto NXDIR;

   fprintf(stdout,"Command: %s\n",cmnd);
   switch(cmnd[0]) {
   case 'L':
      strcpy(user, &cmnd[1]);
      break;
   case 'B':
      strcpy(file, &cmnd[1]);
      ffflg = 0;
      sendfile(file);
      break;
   case 'F':
      strcpy(file, &cmnd[1]);
      ffflg = 1;
      sendfile(file);
      break;
   };

   goto NXCMD;

UNLNK:

   unlink("lock");

}

sendfile(afile)
char *afile;
{
   if ((iochan = open("/dev/tty8",2)) == -1) {
      fprintf(stderr,"Unable to open /dev/tty8. ABORT.\n");
      return NAK;
   };

   if ((inchan = open(afile, 0)) == -1) {
      fprintf(stderr,"File does not exist or is unreadable: %s\n",afile);
      return NAK;
   };

   fstat(inchan, &stat);
   if (getpw(stat.st_uid, user)) sprintf(user, "NOUSER");

   sprintf(stdout, "Processing User: %s Que: %s File: %s\n",user, qname, afile);
   ioctl(iochan, TIOCGETP, &old_iomode);
   ioctl(iochan, TIOCGETC, &old_iochar);

   iomode = old_iomode;
   iochar = old_iochar;

   iomode.sg_flags &= ~ECHO & ~LCASE & ~CRMOD & ~ALLDELAY;
   iochar.t_brkc    = TERMCH;

   ioctl(iochan, TIOCSETP, &iomode);
   ioctl(iochan, TIOCSETC, &iochar);

   sprintf(cmnd, "%cOD=%s\nS=%s\nU=%s\n%c", messno, qname, afile, user, TERMCH);
   write(iochan, cmnd, strlen(cmnd));

   if (waitfor(messno) != ACK) {
      fprintf(stderr, "Error: (%c) %s\n", iline[1], &iline[2]);
      goto EXITNAK; /* Must GOTO to reset terminal characteristics */
   }

   incr(&messno);

   while((count = read(inchan, &buf[2], BLKLEN)) > 0) {
      buf[0] = messno;
      buf[1] = 'D';
      buf[count+2] = TERMCH;
      write(iochan, buf, count+3);

      filesize += count;

      if (waitfor(messno) != ACK) {
	 fprintf(stderr, "Error: (%c) %s\n", iline[1], &iline[2]);
	 break;
      };

      incr(&messno);
   };

   sprintf(cmnd, "%cC%c", messno, TERMCH);
   write(iochan, cmnd, strlen(cmnd));

   if (waitfor(messno) != ACK) {
      fprintf(stderr, "Error: (%c) %s\n", iline[1], &iline[2]);
   };

EXIT:

   ffflg = ACK;

EXIT1:

   ioctl(iochan, TIOCSETP, &old_iomode);
   ioctl(iochan, TIOCSETC, &old_iochar);
   return ACK;

EXITNAK:

   ffflg = NAK;
   goto EXIT1;

}

waitfor(digit)
char digit;
{
   long larg;
   int linsiz;

   do { linsiz = read(iochan, iline, 132); } while (iline[0] != digit);
   switch(iline[1]) {
   case 'A':
      return ACK;
   case 'E':
      return NAK;
   case 'L':
      sscanf(&iline[2], "%ld", &larg);
      if (larg == filesize) return ACK;
      sprintf(&iline[2], "Host/slave file sizes do not agree. H:%ld S:%ld\n",
	 larg, filesize);
      return NAK;
   default:
      return NAK;
   };
}

incr(digit)
char *digit;
{
   (*digit)++;
   if ((*digit < '0') | (*digit > '9')) *digit = '0';
}
