/*
 * This structure describes the layout information stored on the disk.
 *   There are ten user definable areas on the disk.
 *
 * 	0	Should always be the whole disk 
 *	1	Is currently assumed to be the swap area.
 *	2	Is currently assumed to be the root file system.
 *		   And includes the whole rest of the disk.
 *	3-8	Currently unused (could be used for other file systems).
 *
 *	If you would like to have more file systems, you should
 *	make area 2 smaller (but still large enough for the root fs).
 *	Split the extra space in to the other file systems.
 *
 *	The layout numbers correspond to minor device numbers.
 *	Other minor device numbers are as follows.
 *	9	Extra sectors for bad sectors to be mapped into.
 *	10	Future expansion
 *	11	All of track0
 *	12	Place where boot program is placed.
 *	13	Rest of cylinder zero, is used for fsck temporary file.
 *	14	Layout information.
 *	15	Sector to sector map (see sspare.h)
 */

#define	LAYBLK	3		/* Layout info is kept in the 3 block on disk */
#define	LAYOUTS	10		/* Number of user definable layouts */

struct layout {
	daddr_t	l_blkoff;	/* Block offset to the area */
	daddr_t l_nblocks;	/* Number of blocks in the area */
};
