/* nlist.c - List text (file) with line numbers.
		waf
4/26/84	waf	Allow either file or stdin as input.
			Note - Only one file arg currently supported.

*/

#include	<stdio.h>

#define	RLN	01		/* restart line numbers flag */
#define	NS	2		/* # spaces after line# */

unsigned	linecnt;


main( argc, argv )

int	argc;
char	*argv[];
{

	char	*sp;
	char	nc,lc;		/* next char, last char */
	FILE	*fp ;		/* input file ptr */


	/* Get input fp */
	if ( argc == 1 || strcmp(argv[1], "-") == 0 )
		/* Use stdin */
		fp = stdin ;
	else {
		/* Use file arg */
		fp = fopen(argv[1], "r") ;
		if ( fp == (char *) 0 ) {
			printf("%s: Can't open file >%s<\n", argv[0], argv[1]) ;
			exit(-1) ;
			}
		}


	linecnt = 1 ;
	prlno();

	/* get 1st char */
	lc = getc(fp) ;

	while ( (nc=getc(fp)) != (char) EOF ) {
		/* print last char read */

		/* chk for RLN */
		if ( lc == (char) RLN ) {
			/* start new text */
			linecnt = 1 ;
			/* putchar( '\f' );		/* form feed */
			}

		/* chk for '\n' */
		else if ( lc == '\n' ) {
			putchar( lc );		/* show it */

			/* chk for next char = '\f'.
			   If so, don't show line#, but do inc line cnt */
			if ( nc == '\f' )
				linecnt++ ;		/* don't show line# */
			else
				prlno();		/* show line# */
			}

		else {

			/* show char */
			putchar( lc );
			}

		/* buffer next char */
		lc = nc;
		}		/* end while */

	putchar( '\n' );
	}

prlno()

/*	Show line # & inc line cntr */
{
	int	i;

	printf( "%3u", linecnt );
	linecnt++ ;

	/* show space(s) after line# */
	for ( i=NS ; i-- ; )
		putchar( ' ' );
	}
