/*
	sqz - reads in file and writes it back out lseeking over
		zeroes in the input file, it then mv's the file 
		to the original name
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define BUFSIZE 62*512

main(argc,argv)
int	argc;
char	*argv[];
{
	register unsigned j;
	register int	n;
	int	i;
	long	l;
	long	tot;
	char	buf[BUFSIZE],oname[512];
	FILE	*fpi,*fpo;
	char	*prg;
	struct	stat stbuf;

	prg = argv[0];

	if (argc < 2) {
		fprintf(stderr,"%s: usage %s file1 [file2..]\n",prg,prg);
		exit(-1);
	}

	for (i=1; i < argc; ++i) {  /* do all files given */
		stat(argv[i],&stbuf);
		if ((stbuf.st_mode & S_IFREG) != S_IFREG) {
			fprintf(stderr,"%s: Can't squeeze %s\n",prg,argv[i]);
			continue;
		}
		if ((fpi = fopen(argv[i],"r")) == NULL) {
			fprintf(stderr,"%s: Can't open %s\n",prg,argv[i]);
			continue;
		}
		strcpy(oname,argv[i]);
		strcat(oname,".$");
		if ((fpo = fopen(oname,"w")) == NULL) {
			fprintf(stderr,"%s: Can't create %s\n",prg,oname);
			exit(-1);
		}

		printf("%s: Squeezing %s\n",prg,argv[i]);
		
		tot = 0;

		while((n = fread(buf,sizeof(char),BUFSIZE,fpi)) > 0) {
			for(j = 0, l = 0; j < n; ++j) {
				if (buf[j] == '\0') {
					++l;
					if (j % 511 == 0 && j != 0 && l >= 512)
						++tot; /* skipped a sector */
					continue;
				}
				if (l != 0) {
					fseek(fpo,l,1);
					l = 0;
				}
				putc(buf[j],fpo);
			}
			if (l != 0)	/* lseek over any thing left */
				fseek(fpo,l,1);
		}
		fclose(fpi);
		fclose(fpo);

		if (unlink(argv[i]) < 0) {
			fprintf(stderr,"%s: Can't unlink %s\n",prg,argv[i]);
			exit(-1);
		}
		if (link(oname,argv[i]) < 0) {
			fprintf(stderr,"%s: Can't link %s to %s\n",prg,argv[i],
									oname);
			exit(-1);
		}
		if (unlink(oname) < 0) {
			fprintf(stderr,"%s: Can't unlink %s\n",prg,oname);
			exit(-1);
		}
		chmod(argv[i],stbuf.st_mode&07777);/*restore permission bits*/
		printf("  %D sectors skipped\n",tot);
	}
	exit(0);
}
