/*************************************************************************
*
*
*	Name:  sform.h
*
*	Description:  SForm routines include file.
*
*
*	History:
*	Date		By		Comments
*
*	03/01/84	waf
*	06/06/84	waf		Rev. 2.0
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  This file should be included with any pgm that uses the 'sform'
	(screen format and i/o) package.
	  The object library 'sform.o' should be bound in with the user's pgm.

	Note the order of the 'error' codes (see completion code notes).
	All error codes are negative.
	Note that SF_ABORT and SF_RSTWIN are 'error' codes.
*/

/* Define environment */
#define	SF_ALTOS	1		/* Altos (DG terminal)	*/
#define	SF_PC		0		/* IBM PC				*/

/* Define rev */
#define	SF_REVNUM	200		/* Rev. 2.xx */



/*************************************
**		SForm global constants		**
*************************************/


/* ** SForm completion codes **
   One of the codes below will be returned to the user after completion
   of an SForm function call.
   NOTE - The sequence defined for the comp codes must not be altered.
		  It is used to logically group the functions.
   Comp code grouping (internal) notes -
		c < 0			= Error, abort fld i/o & return to user.
		c < CB1			= Trapped by lowest level i/o fns.
		CB1 <= c < CB2	= Trapped by type specific i/o fns.
		CB2 <= c < CB3	= Trapped by high level sform fn(s).
		c >= CB3		= Unpend entry, update fld, & return code to user.
	Error code grouping (internal) notes -
		0 < c < EB1		- System error.
		EB1 <= c < EB2	- User error.
		c <= EB2		- User data conversion error.
*/
#define	SF_CB1		270
#define	SF_CB2		280
#define	SF_CB3		290
#define	SF_EB1		(-100)
#define	SF_EB2		(-200)

/* SForm user return codes.
   Normally, one of these codes will be returned to the user program upon
   exit from sf_winio() or sf_fldio(). */
#define	SF_ABORT	(-50)	/* Abort					*/
#define	SF_RSTWIN	(-51)	/* 'Reset' all data fields	*/
#define	SF_NXTFLD	300		/* Next Field				*/
#define	SF_PRVFLD	301		/* Previous Field			*/
#define	SF_NXTWIN	302		/* Next Window				*/
#define	SF_PRVWIN	303		/* Previous Window			*/
#define	SF_FINISH	310		/* Exit the updated window 	*/

/* SForm internal return codes.
   These codes are processed internally by the SForm fn's. */
#define	SF_CLRERR	260		/* Clear error				*/
#define	SF_HELP		261		/* User help routine		*/
#define	SF_FLDFMT	270		/* Show field format		*/
#define	SF_NXTENM	271		/* Next enumerator			*/
#define	SF_PRVENM	272		/* Previous enumerator		*/
#define	SF_RSTFLD	279		/* Restore field data		*/
#define	SF_NXTGRP	281		/* Next Group				*/
#define	SF_PRVGRP	282		/* Previous Group			*/

/* Function key codes.
   If the user hits a keyboard function key, and that key is not
   defined (in fnkeys.h) to represent an sform function, one of 
   the codes below is returned to the user pgm. */
#define	SF_F1		350		/* Fn Key # 1			*/
#define	SF_F2		351		/* Fn Key # 2			*/
#define	SF_F3		352		/* Fn Key # 3			*/
#define	SF_F4		353		/* Fn Key # 4			*/
#define	SF_F5		354		/* Fn Key # 5			*/
#define	SF_F6		355		/* Fn Key # 6			*/
#define	SF_F7		356		/* Fn Key # 7			*/
#define	SF_F8		357		/* Fn Key # 8			*/
#define	SF_F9		358		/* Fn Key # 9			*/
#define	SF_F10		359		/* Fn Key # 10			*/
#define	SF_F11		360		/* Fn Key # 11			*/
#define	SF_SF1		361		/* Shifted Fn Key # 1	*/
#define	SF_SF2		362		/* Shifted Fn Key # 2	*/
#define	SF_SF3		363		/* Shifted Fn Key # 3	*/
#define	SF_SF4		364		/* Shifted Fn Key # 4	*/
#define	SF_SF5		365		/* Shifted Fn Key # 5	*/
#define	SF_SF6		366		/* Shifted Fn Key # 6	*/
#define	SF_SF7		367		/* Shifted Fn Key # 7	*/
#define	SF_SF8		368		/* Shifted Fn Key # 8	*/
#define	SF_SF9		369		/* Shifted Fn Key # 9	*/
#define	SF_SF10		370		/* Shifted Fn Key # 10	*/
#define	SF_SF11		371		/* Shifted Fn Key # 11	*/

/* System completion codes.
   These codes are used primarily internally, but could be returned
   to the user by some fn's in some situations. */
#define	SF_OK		0		/* No Problem							*/
#define	SF_ERROR	(-10)	/* General error indicator				*/

/* User Errors.
   These codes define various error codes which could be returned by calls
   to the sform modules. Note that all error codes are < 0.
   Note - the order is important. */
/* General */
#define	SF_EGOPN	(-100)	/* Error while trying to open window.	*/
#define	SF_EGCLS	(-101)	/* Error while trying to close window.	*/
#define	SF_EGBWD	(-102)	/* Bad window desc paramaters.			*/
#define	SF_EGBFD	(-103)	/* Bad field desc parameters.			*/
/* User data entry errors */
#define	SF_ENOVF	(-200)	/* Numeric overflow						*/
#define	SF_ENCNV	(-201)	/* Numeric conversion error				*/
#define	SF_ENRNG	(-202)	/* Number out of range					*/
#define	SF_EENMS	(-220)	/* Bad enumerator string				*/
#define	SF_ESCHR	(-230)	/* Bad character in string data			*/
#define	SF_ENUNQ	(-231)	/* Non-unique enum abbreviation			*/
#define	SF_EINVV	(-299)	/* Invalid value						*/
/** End of completion codes **/


/**  TIP input codes  **/
/* Editing & cursor movement codes.
   All codes in the group below are handled by stgetf(), and are used
   only while editing a field.
   Some of these codes are not currently implemented; stgetf() will 'beep'
   on the unimplemented codes.
   Note that the code values are important, they are used by stgetf() to
   recognize codes to be handled at that level. */
#define	SF_EDLOW	400		/* Lowest edit code		*/
/* Cursor control */
#define	SF_CHOME	400		/* Move cursor home		*/
#define	SF_CUP		401		/* Move cursor up		*/
#define	SF_CDOWN	402		/* Move cursor down		*/
#define	SF_CRIGHT	403		/* Move cursor right	*/
#define	SF_CLEFT	404		/* Move cursor left		*/
/* Editing */
#define	SF_RUBOUT	410		/* Rubout character		*/
#define	SF_DELCHR	411		/* Delete character		*/
#define	SF_INSERT	412		/* Insert mode			*/
#define	SF_ERSEOF	414		/* Erase to end of fld	*/
#define	SF_ERSNXT	415		/* ERSEOF & unpend		*/
#define	SF_EDHI		450		/* Highest edit code	*/

/* Other input codes */
#define	SF_ENTER SF_ERSNXT	/* Unpend (\n or \l)	*/
#define	SF_ESC		452		/* Escape key			*/
#define	SF_QUIT		453		/* Quit key (^C)		*/


#define	SF_EOF		(-1)	/* End of input			*/
#define	SF_INVALID	(-2)	/* Invalid entry		*/
/** End of TIP codes **/


/* Display attribute codes.
   Each data and label field uses one of these codes to
   define its 'display attribute'.
   Note that '0' is always defined as 'normal'. */
/* Display attribute codes */
#define	SF_NORM		0		/* Normal				*/
#define	SF_LIT1		1		/* Literal type 1		*/
#define	SF_LIT2		2		/* Literal type 2		*/
#define	SF_LIT3		3		/* Literal type 3		*/
#define	SF_DSP1		4		/* Display type 1		*/
#define	SF_DSP2		5		/* Display type 2		*/
#define	SF_DSP3		6		/* Display type 3		*/
#define	SF_DSP4		7		/* Display type 4		*/
#define	SF_ATTN		8		/* Attention (Blink)	*/
/* Input attribute codes */
#define	SF_LIT4		9		/* Literal type 4		*/
#define	SF_LIT5		10		/* Literal type 5		*/
#define	SF_LIT6		11		/* Literal type 6		*/
#define	SF_INP1		12		/* Input type 1			*/
#define	SF_INP2		13		/* Input type 2			*/
#define	SF_INP3		14		/* Input type 3			*/
#define	SF_INP4		15		/* Input type 4			*/
/* Input attribute offset.
   This value is added to the display attribute code to create the
   'input display attribute', e.g. the display attribute while a field
   is being input. */
#define	SF_ATINPOS	8


/* Cursor types */
#define	SF_CUROFF	0		/* Off (no cursor)		*/
#define	SF_CURT1	1		/* Cursor type 1		*/
#define	SF_CURT2	2		/* Cursor type 2		*/
#define	SF_CURT3	3		/* Cursor type 3		*/


/* Beep types */
#define	SF_BPNORM	0		/* Normal beep			*/
#define	SF_BP1		1		/* Beep type 1			*/
#define	SF_BP2		2		/* Beep type 2			*/
#define	SF_BP3		3		/* Beep type 3			*/



/* Window I/O edit modes.
   An edit code is included in every sfwinio() or sffldio()
   call to define the action to be taken. Note that these codes
   are bitflags and can be combined. */
#define	SF_DISPLAY	1		/* Display data fields			*/
#define	SF_EDIT		2		/* Display and Input data fields*/
#define	SF_LABELS	4		/* Display label fields			*/
#define	SF_INPUT	8		/* Input data fields			*/


/* Screen size parameters.
   Note that rows & cols are 0 based.
   Note that bottom row is normally reserved for error messages. */
#define	SF_MAXCOL	79			/* Largest col #			*/
#if SF_PC
#define	SF_MAXROW	24			/* Largest row #			*/
#endif
#if SF_ALTOS
#define	SF_MAXROW	23			/* Largest row #			*/
#endif
#define	SF_ERRROW	SF_MAXROW	/* Error/Status line		*/

/************************/
/*    Structures        */
/************************/



/**  I/O Data descriptors.

   These structures include all the information necessary for the display
   and editing of a field of each type. Each descriptor includes the address
   of a dedicated 'sf_tfldio' function. There is a tight correspondence
   between the 'sf_tfldio' function and the i/o data descriptor structure
   used by that function. There must be a data descriptor for each distinct
   'type' of data field. The data 'type' is implicitly defined by the 
   sf_fldio function and the data descriptor structure used by the field.

   The data descriptors defined below are considered to be the 'system standard'
   descriptors. These descriptors correspond to the sf_fldio
   functions which are supplied to handle the 'standard' data types. If the
   user defines his/her own field type, s/he must define a new data descriptor
   and a new sf_tfldio function for that field.


   NOTE - ALL data descriptors must have the following format -		*/

	struct SF_IODATA {
		int		(*sf_fldfn)() ;		/* field i/o function ptr */
		unsigned sf_datr ;			/* field display attribute word */
		unsigned sf_flags ;			/* bit flags */
		/** type specific data goes here **/
		} ;

/* the sform functions will assume that the first fields of any data
   descriptor will follow the above template. Fields specific to the
   given data type can follow these defined fields.
*/

/* Bit mask definitions.
   These mask values are used by the standard data descriptors.
   Masks are used instead of 'c' bit-fields, as some versions of 'c' may not
   support bit-fields.
   The comments describe the meaning when the bit is set or reset.
*/

/* numeric */
#define	SF_UNSGN	0x1		/* 0 = signed numeric field.
							   1 = unsigned numeric field.					*/
#define	SF_ZFILL	0x2		/* 1 = zero fill numeric field display.			*/

/* string */
#define	SF_ALPHA	0x4		/* 1 = only alphabetic chars allowed.			*/
#define	SF_NUM		0x8		/* 1 = only numeric chars allowed.				*/
#define	SF_ANUM	(SF_ALPHA|SF_NUM)  /* 1 = only alpha-numeric chars allowed.
							Non-alphanumeric chars allowed only if ANUM=0.	*/
#define	SF_SPCHR	0x10	/* 1 = Special (user defined) character set.
							sf_spchr is ptr to null term'ed char list.
							Note - Control chars are never legal data chars.*/
#define	SF_UCASE	0x20	/* 1 = upper case input only.
							   0 = lower case input allowed.				*/
#define	SF_BFILL	0x40	/* 1 = blank fill return string data.
							   0 = null fill return string data.			*/

/* general */
#define	SF_PROTFLD	0x80	/* 1 = protected field (display only).
							Data flds can not be edited						*/
#define	SF_LABFLD	0x100	/* 1 = label (prompt) field
							Note - all label flds MUST have this bit set.	*/
#define	SF_NOECHO	0x200	/* 1 = don't echo input.
							The data is not displayed, but can be edited.	*/
#define	SF_AUTOUNP	0x400	/* 1 = auto unpend when full field input.		*/
#define	SF_RJUST	0x800	/* 1 = right justify field display.				*/
#define	SF_CJUST	0x1000	/* 1 = center justify field display.
							Default justification = left justify.			*/

/** Data Descriptors

  These structures hold type specific information about data flds.
*/


/* Integer data descriptors -
   Integer radix can be 2, 8, 10, or 16. Decimal is the default.
   Integer desc's all have explicitly defined ranges.
   Integer (and enum) desc's have a 'mask word' which is used to implement
   'bit fields'. The hi byte is the fld width, and the low byte
   is the (left) shift count. A fld width of 0 implies no masking.
*/
/* Normal Integer data descriptor.
   This i/o desc is used for 2 byte (1 'word') integer data.
*/
struct SF_IFDATA {		/* integer field data */
	int			(*sf_ifldio)() ;	/* function for integer i/o */
	unsigned	sf_idatr ;			/* display attribute word */
	unsigned	sf_iflags ;			/* numeric flags */
	unsigned	sf_iradix ;			/* numeric base */
	int			sf_ilbnd, sf_iubnd;	/* range */
	unsigned	sf_imask ;			/* mask word */
} ;

/* Long Integer data descriptor.
   This i/o desc is used for 4 byte (2 'word') integer data.
*/
struct SF_LFDATA {		/* long integer field data */
	int			(*sf_lfldio)() ;	/* function for long integer i/o */
	unsigned	sf_ldatr ;			/* display attribute word */
	unsigned	sf_lflags ;			/* flags */
	unsigned	sf_lradix ;			/* numeric base */
	long		sf_llbnd, sf_lubnd;	/* range */
	unsigned	sf_lmask ;			/* mask word */
} ;

/* Short Integer ('Byte') data descriptor.
   This i/o desc is used for 1 byte integer data.
   Note that range is defined with type int.
*/
struct SF_BFDATA {		/* short field data */
	int			(*sf_bfldio)() ;	/* function for integer i/o */
	unsigned	sf_bdatr ;			/* display attribute word */
	unsigned	sf_bflags ;			/* numeric flags */
	unsigned	sf_bradix ;			/* numeric base */
	short		sf_blbnd, sf_bubnd;	/* range */
	unsigned	sf_bmask ;			/* mask word */
} ;


/* String data descriptor.
   This i/o desc is used for string data.
*/
struct SF_SFDATA {		/* string field data */
	int			(*sf_sfldio)() ;	/* function for string i/o */
	unsigned	sf_sdatr ;			/* display attribute word */
	unsigned	sf_sflags ;			/* flags */
} ;


/* Literal data descriptor.
   This i/o desc is used for 'literal' fields.
   These fields are used for labels, prompts, headings, borders, etc.
*/
struct	SF_LBFDATA {	/* label (string literal) field data */
	int			(*sf_slfldio)() ;	/* function for label display */
	unsigned	sf_sldatr ;			/* display attribute word */
	unsigned	sf_slflags ;		/* flags */
} ;


/* Enumeration data descriptor.
   This i/o desc is used for 'enumeration' type integer data.
   The enumeration string is defined as per 'c' conventions,
   including initializers.
*/
struct	SF_EFDATA {		/* enumeration field data */
	int			(*sf_efldio)() ;	/* function for enumeration i/o */
	unsigned	sf_edatr ;			/* display attribute word */
	unsigned	sf_eflags ;			/* flags */
	char		*sf_enmstr ;		/* enumerator string */
	unsigned	sf_emask ;			/* mask word */
} ;




/** Binary Data descriptor.

   This structure is currently used as a template for the binary data
   storage. It could be used as a data descriptor.
*/

union	SF_BINDATA {

	char	sf_cdata ;		/* char */
	short	sf_idata ;		/* int */
	long	sf_ldata ;		/* long */
	float	sf_fdata ;		/* float */
	double	sf_ddata ;		/* double */
	char	sf_sdata[1] ;	/* string (template) */

} ;

/** Field descriptor.

   This structure defines a field, where a field is a single display item.
   One of these structures must be composed for each unique field within a
   window.
*/

struct	SF_FIELD {

	int		sf_row, sf_col; /* Absolute Row & Col numbers on the screen */
	int		sf_width ;		/* width of field (# chars) */
	struct SF_IODATA *sf_iodata ;
							/* This structure defines the type of the data
							   in the field, and contains information for
							   displaying and inputing the field and the
							   address of the function which handles display
							   and input. */
	union SF_BINDATA *sf_bindata ;
							/* fld_io() uses the information in this structure
							   to find the current data and to store the new
							   data.  This is normally the address of the binary
							   data, but could be the address of a data
							   descriptor. */

} ;

/** Group link entry.

	The 'group link list' is composed of SF_GRPLINK entries. It is used to
	define 'groups' of fields within a given window. Each entry contains
	links (field #'s) to the previous group and the next group correspond-
	ing to a given field. There is an entry in the group link list
	coresponding to each entry in the Field List.
	A link entry of (-1) denotes the end of the list (e.g. first and
	last fields in the window).
	NOTE that the links are field numbers, not addresses.

	The grouping information is used to make selection of fields more
	efficient.
*/

struct	SF_GRPLINK {

	int		sf_prvgrp ;		/* field # of first field in previous group */
	int		sf_nxtgrp ;		/* field # of first field in next group */
} ;

/** Window descriptor.

   This structure defines a 'window', which is a section of the crt
   screen space. The window can be, and often will be, the entire
   screen space. A window contains one or more 'fields', which are
   fully defined by a SF_FIELD structure.
*/


struct	SF_WINDOW {

	int					sf_urow, sf_lrow ;
			/* The starting and ending (upper & lower) rows for this window.
			   Rows are numbered starting at '0'. */
	int					sf_lcol, sf_rcol ;
			/* The starting and ending (left & right) columns for this window.
			   Cols are numbered starting at '0'. */
	unsigned			sf_wdatr ;
			/* Display attribute word for this window.
			   This allows 'painting' of the window. */
	struct SF_GRPLINK	(*sf_grplist)[] ;
			/* A ptr to an array of group links.
			   This optional array is used to define 'groups'. There is an
			   entry in this array corresponding to each entry in the sf_fldlist
			   array, with links to the 'next group' and 'previous group'.
			   If field grouping will not be defined, use SF_NULL */
	struct SF_FIELD		(*sf_fldlist)[] ;
			/* Field desc array address.
			   There is a field desc structure in this list for each field in
			   the window.  NOTE that a 'sf_nullfld' field desc structure MUST
			   terminate the list.
			   This entry must be a ptr to allow initializers to dynamically
			   define the array length. */
	int					sf_fwrap ;
			/* 'Field wrap' flag.
			   If set, the 'current fld' will wrap to the first or last data
			   fld in the window. If reset, control is returned to the user
			   pgm when the current fld goes out of range. */

} ;

/********************************/
/*	System Macros & Globals		*/
/********************************/


/* Define a 'null' ptr.
   This macro can be used to define 'no group link list', etc. */
#define		SF_NULL		0	/* Null ptr */


/* End of field.
   This macro must be used to terminate the field desc list in each
   window desc. It defines the data in a 'Null Field'. */
#define	SF_ENDFLD \
	{ -1, -1, -1, SF_NULL, SF_NULL }


/* Cast macros.
   These macros can be used to 'cast' various entries in the window
   data definition module. */
/* Field List cast. Used to define the field list ptr in the window desc. */
#define	SF_FLPCAST	(struct SF_FIELD (*)[])
/* Group List cast. Used to define the group list ptr in the window desc. */
#define	SF_GLPCAST	(struct SF_GRPLINK (*)[])
/* IO Data struct ptr. Defines the SF_IODATA ptr in the fld desc list */
#define	SF_IDPCAST	(struct SF_IODATA *)
/* Binary Data struct ptr. Defines the SF_BINDATA ptr in the fld desc list */
#define	SF_BDPCAST	(struct SF_BINDATA *)


/* Declare 'standard' i/o functions.
   These fn's implement i/o for the 'basic' data types.
   The user must provide his/her own routines to support 'extended' types. */
extern	sfintio() ;		/* Integer (2 byte) i/o		*/
extern	sflintio() ;	/* Long int (4 byte) i/o	*/
extern	sfbintio() ;	/* Short int (1 byte) i/o	*/
extern	sfstrio() ;		/* String i/o				*/
extern	sfenmio() ;		/* Enumerator i/o			*/
extern	sflabio() ;		/* Label (prompt) i/o		*/


/** Global user variables **/
extern	unsigned sf_inatros ;	/* Input display attribute offset	*/
