/*************************************************************************
*
*
*	Name:  strinp.c
*
*	Description:  Input string field.
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"
#include	<ctype.h>
#include	"/sform/src/stip.h"



sfstrinp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
char	*data_ptr ;

/*
  Synopsis -
	Input a string field.

  Description -
	$

  Return -
	return val	= Completion code or Fn Key value -
				Valid completion codes are
				SF_ERROR	= non-recoverable error during data entry.
				SF_CUNP		= input was unpended normally.
				Valid Fn Key return values are
					<All defined function keys>

  Notes -
  > Input display attributes are assumed already set.
  > Any chars input past the end of field are discarded.
  > sf_nchars is always the number of chars entered so far in this field.
  This is used to restore the cursor position in case of error messages.
  It is also used by the calling fn's to tell if any input was entered.
  > During string input, the 'erase' and 'kill' chars are supported.
  > If 'upper case' only is specified, lower case input is translated.
*/

{
	register unsigned flag ; /* bit flag */
	register int cval ;	/* 'value' of input char */
	int		maxc ;		/* max # chars in field */
	char	c ;			/* input char */
	int		i ;


	/* Position cursor */
	sfposcur(fld_desc->sf_row, fld_desc->sf_col) ;

	/* Get bit flag */
	flag = fld_desc->sf_iodata->sf_flags ;

	/* Init char cntrs */
	sf_nchars = 0 ;
	maxc = fld_desc->sf_width ;


	/** Input chars **/
	for (;;) {

		/* get next char */
		cval = sfegetc() ;

		if ( cval < 0 || cval > SF_CHIC ) {

			/** Non-displayable char **/

			if ( cval == SF_CBFN ) {
				/* Bad function key  <<< */
				sferwmsg("Undefined function key.") ;
				continue ;
			}

			else if ( cval >= SF_CHIC && cval <= SF_CHIFK ) {
				/* SForm function */
				switch ( cval ) {		/* act on fn key */

					case SF_ABORT :		/* abort */
						return(cval) ;	/* return ABORT flag */

					case SF_CLRFLD :	/* clear the field */
						sf_nchars = 0 ;
						goto done ;

						/* Trap 'disabled' fn keys */
					case SF_CLRERR :
						sfbeep() ;		/* not valid as input */
						continue ;

					default :			/* some other fn key */
						goto done ;
				}
			}

			else if ( cval >= SF_F1 && cval <= FNKEYHI ) {
				/* Keyboard function key.
								   Return the fn key code to user pgm. */
				goto done ;
			}

			else if ( cval == SF_CDEL || cval == SF_CKILL ) {
				/* Backspace / Kill */
				if ( sf_nchars == 0 )
					sfbeep() ;		/* ignore if no chars entered */
				else {
					/* erase char(s) */
					if ( cval == SF_CDEL )
						i = 1 ;
					else
						i = sf_nchars ;
					/* dec char cnt */
					sf_nchars -= i ;
					/* show backspace(s) */
					while ( i-- != 0 )
						bkspace() ;
				}
				continue ;
			}

			else if ( cval == SF_CUNP ) {
				/* Unpend */
				goto done ;
			}

			else {
				/* Bad char */
				sferwmsg("Illegal character.") ;
				continue ;
			}

		}


		c = (char) cval ;	/* input char */

		/* Chk for field overflow */
		if ( sf_nchars == maxc )		/* if field full */
			continue ;		/* ignore overflow */


		/** Chk bit flags **/

		/* special char set */
		if ( flag & SF_SPCHR ) {
			/* use list of allowed chars */
			if ( chkspchr(c) == 0 ) {
				continue ;
			}
		}

		/* case flags */
		if ( flag & SF_UCASE )
			/* upper case only */
			if ( isalpha(c) && isupper(c) == 0 ) {
				c = toupper(c) ;	/* translate to upper case */
			}

		/* char val flags */
		if ( c != ' ' ) {		/* ' ' is always ok (???) */
			if ( (flag & SF_ANUM) == SF_ANUM ) {
				/* alpha-numeric chars only */
				if ( isalnum(c) == 0 ) {
					sferwmsg("Alpha-numeric input only.") ;
					continue ;
				}
			}
			else if ( flag & SF_ALPHA ) {
				/* alphabetic chars only */
				if ( isalpha(c) == 0 ) {
					sferwmsg("Alphabetic input only.") ;
					continue ;
				}
			}
			else if ( flag & SF_NUM ) {
				/* numbers only */
				if ( isdigit(c) == 0 ) {
					sferwmsg("Numeric input only.") ;
					continue ;
				}
			}
		}



		/* Display char */
		if ( !(flag & SF_NOECHO) )
			stputc(c) ;


		/* Add char to string */
		*(data_ptr + sf_nchars) = c ;
		sf_nchars++ ;		/* inc char cnt */

		/* chk auto unpend */
		if ( sf_nchars == maxc )
			if ( flag & SF_AUTOUNP ) {
				cval = SF_CUNP ;	/* treat it like an unpend */
				goto done ;
			}

	}	/* end loop */


done:
	/* All data entered.
		   'cval' = unpend code. */


	/* Fill the rest of the field with blanks/nulls */
	if ( flag & SF_BFILL )
		c = ' ' ;	/* blank fill */
	else
		c = '\0' ;	/* null fill */
	i = sf_nchars ;		/* # chars in input */
	while ( i != maxc )
		*(data_ptr + i++) = c ;

	return(cval) ;
}

static	chkspchr ( c )

char	c ;

/* Chk to see if 'c' is one of the chars in the 'special character set'
   which is pointed to by 'sf_spchr'.
   Return '0' if c is not in the set.
*/

{
	register char	*cp ;
	register char	nc ;


	/* Get ptr to special char list */
	cp = sf_spchr ;
	/***> Chk char list ptr ???  */

	/* search list */
	while ( (nc = *cp++) != 0 ) {
		if ( nc == c )
			/* found it */
			return(1) ;
	}

	/* end of list */
	sferwmsg("Character is not in legal character set.") ;
	return(0) ;
}



static	bkspace ()

/*  Show a backspace.  */

{


	stputc(TO_MCL) ;		/* backup to last char */
	stputc(' ') ;		/* del last char */
	stputc(TO_MCL) ;		/* and position cursor */
}
