/*************************************************************************
*
*
*	Name:  errs.c
*
*	Description:  Error handler & message diplay routines.
*					sferrmsg()	- Show message on error line.
*					sferwmsg()	- Show error msg & wait for CLRERR.
*					sferrwait() - Wait for 'Clear Error' fn key.
*					sfpanic()	- Panic.
*					sfbeep()	- Beep.
*					sfnotimp()	- Report unimplemented feature.
*					sfclrerm()	- Clear error message line.
*					sf_msg()	- Show a message on the error line.
*
*
*	History:
*	Date		By		Comments
*
*	03/14/84	waf
*	05/10/84	waf		Call sfexit() after panic.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	All error output is made to stdout (not stderr).

*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"



sferrmsg ( msg )

char	msg[] ;

/* Report error on error line.
   Note - The 'sferrwait()' fn can not be called, because there may be
   a user error handler. If the user does not trap the error, the sferrwait()
   fn should be invoked by the caller.
*/
{

	errmsg(msg, 0) ;
}



sferwmsg ( msg )

char	msg[] ;

/* Report an error and wait for 'Clear Error' fn key.
   This fn should be used whenever the error can not be trapped by the
   user.
*/

{

	errmsg(msg, 1) ;
}



static	errmsg ( msg, waitflag )

char	msg[] ;
int		waitflag ;

/* Show error msg and, if waitflag set, wait for 'Clear Error'.
*/

{


	sfbeep() ;
	sf_msg(msg, waitflag) ;
}



sf_msg ( msg, waitflag )

char	*msg ;
int		waitflag ;

/* Show a (user or system) message on the error line.
   If waitflag is set, wait for 'Clear Error' fn key, then clear msg.
*/

{


	ermset() ;
	sfprintf((char *)0, msg) ;
	if ( waitflag ) {
		sferrwait() ;
		sfclrerm() ;
	}
	ermrst() ;
}



sferrwait ()

/* Wait for 'Clear Error' fn key to be hit.
   Beep if any other key is hit.
*/

{


	while ( sfegetc() != SF_CLRERR )
		sfbeep() ;
}



sfclrerm ()

/* Clear the error message line.
   NOTE - the cursor position is not saved.
*/

{


	sfposcur(-1, 0) ;		/* position cursor to error message line */
	sfceoln() ;				/* clear to end of line */
}

sfpanic ( msg )

char	*msg ;

/* Report unmanagable error and exit.

   Note - message should include fn name (for debugging).
*/
{


	ermset() ;
	sfprintf((char *)0, "\7**>> SForm panic - %s", msg) ;	/* show message */

	sfexit() ;			/* return terminal control */

	stputc('\n') ;
	exit(-1) ;
}


sfnotimp ()

/* We tried to invoke a feature/function which is not yet implemented.
   Show message and continue.

   Note - cursor position not saved.
*/

{


	sferrmsg("Feature is not currently implemented.") ;
}


sfbeep ()

/* Output a 'beep'. */

{

	stputc(TO_BELL) ;
}

static unsigned	datr ;	/* save attr's during error message */



static	ermset ()

/* Get ready to print error message. */

{


	datr = sf_datr ;		/* save current display attributes */
	sfsetdatr(SF_ATNORM) ;	/* reset display attributes */
	sfclrerm() ;			/* clear error message line */
	sf_errflg = -1 ;		/* flag the error */
	sfprat(-1, 0) ;			/* pos cur to error line */
}



static	ermrst ()

/* Do houskeeping after error message display */

{
	register int	row, col ;
	struct SF_FIELD *fld_desc ;


	sfsetdatr(datr) ;	/* set prev display attr's */

	if ( sf_curwin != SF_NULL ) {		/* if a window is open */
		/* Reset cursor.
				   The sf_curfld & sf_nchars vars are used to derive the
				   previous cursor position. */
		fld_desc = &(*sf_curwin->sf_fldlist)[sf_curfld] ;	/* current fld */
		row = fld_desc->sf_row ;	/* current row */
		col = fld_desc->sf_col ;	/* start col of current fld */
		col += sf_nchars ;			/*   + any chars entered */
		sfposcur(row, col) ;
	}

}
