/*************************************************************************
*
*
*	Name:  egetc.c
*
*	Description:  'Extended' getc function for SForm input routines.
*
*
*	History:
*	Date		By		Comments
*
*	03/15/84	waf
*	03/29/84	waf		Changed calling convention.
*	04/24/84	waf		Changed to use TIP interface.
*	05/14/84	waf		Externally defined fn key table.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  The Altos code assumes that CBREAK mode is set (e.g. single char i/o),
	and echo is turned off.

	04/24/84
	  This code is an interface between the Terminal Independent Package
	routines and the sform routines.
	  This code uses the system specific TIP code as a interface to the
	terminal. See <sys>tip.h for code definitions for each specific <sys>.

	05/14/84
	  The global var sf_fntable is assumed to be the address of the fn
	key translation table. (See sfdata.c).

*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"



sfegetc ()

/*
  Synopsis -
	Extended getchar routine.
	Returns a signed integer, representing the input value.

  Description -
	$

  Return -
	return val	= A signed value.
				  Values from 0 to 255 are reserved for 'normal' chars.
				  Other values are defined in sform.h & sdchars.h.

  Notes -
  > The value returned is of type int, and is a signed value.
*/

{
	register int	cval ;
	register int	*iptr ;
	int		j ;
	extern	(*sf_usrhelp)() ;


again:
	/* Get char */
	cval = stgetc() ;


	/* Chk char */
	if ( cval >= TI_START ) {

		/* TIP control code */
#if	SF_PC
		if ( cval == TI_ESC || cval == TI_QUIT ) {
			/* Trap interrupts */
			sfonikey() ;		/* ikey handler */
			goto again ;
		}
#endif
		if ( cval == TI_UNDEF ) {
			/* Bad char */
			egerr("Illegal input.") ;
			goto again ;
		}

		/* Search 'fn key' array to see if char
				   was defined as an 'sform fn key' */
		iptr = (int *) sf_fntable ;		/* fn key mapping table */
		while ( (j = *iptr) ) {
			if ( j == cval ) {
				/* found it */
				cval = *(iptr+1) ;		/* Fn Key code */
				goto xit ;				/* return the code */
			}
			iptr++ ; 
			iptr++ ;			/* inc to next entry */
		}

		/* Chk for keyboard fn key */
		if ( cval >= TI_F1 && cval <= TI_AF10 /* <<< */ ) {
			if ( cval > FNKEYHI ) {
				egerr("Unsupported fn key.") ;
				goto again ;
			}
			/* Convert to sform fn key code  <<< */
			if ( cval <= TI_F11 )
				/* normal fn key */
				cval = SF_F1 + (cval - TI_F1) ;
			else
				/* shifted fn key */
				cval = SF_SF1 + (cval - TI_SF1) ;
			goto xit ;
		}

		/* Chk other control codes */
		if ( cval == TI_DEL ) {
			/* erase char */
			cval = SF_CDEL ;
		}
		else if ( cval == TI_CAN ) {
			/* kill char */
			cval = SF_CKILL ;
		}
		else if ( cval == TI_UNP ) {
			/* unpend */
			cval = SF_CUNP ;
		}
		else  {
			/* Bad / unsupported control char */
			egerr("Unsupported control code.") ;
			goto again ;
		}
	}


xit:
	/* Trap certain sform fn key(s) */
	if ( cval == SF_HELP ) {
		(*sf_usrhelp)() ;
		goto again ;
	}

	/* Return char / code */
	return(cval) ;
}

#define	ERRMSG	0		/* if set, show msg & wait for 'Reset'.
if reset, just beep */


static	egerr ( msg )

char	*msg ;

/* Report error during input (e.g. bad or undefined input).
*/

{


#if	ERRMSG
	sferwmsg(msg) ;
#else
	sfbeep() ;
#endif

}
