/*************************************************************************
*
*
*	Name:  strio.c
*
*	Description:  String field i/o.
*					sfstrio()	- string i/o.
*
*
*	History:
*	Date		By		Comments
*
*	06/08/84	waf		**  Rev. 2.0  **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"
#include	<ctype.h>



sfstrio ( fld_desc, mode, data_ptr, tmp_data )
struct SF_FIELD *fld_desc ;
int		mode ;
char	*data_ptr ;
char	*tmp_data ;
/*
  Synopsis -
	String field i/o function.

  Description -
	$

  Return -
	return val	= SForm completion code.
	st_mdt		= Set (by lower level fn) if fld modified.

  Notes -
  > When chking for legal chars - a blank (' ') is always a legal char.
*/
{
	register int	sfc ;
	register int	flags ;
	int				fwid ;
	char			c ;
	int				ec ;

	fwid = fld_desc->sf_width ;				/* get fld wid */
	flags = fld_desc->sf_iodata->sf_flags ;	/* get bit flags */

	/* Copy binary data into tmp_data
	   & append a null */
	sfblkmove(tmp_data, data_ptr, fwid) ;
	tmp_data[fwid] = '\0' ;

again:
	/* Do fld i/o */
	sfc = sfgenio(fld_desc, mode, tmp_data) ;
	if (sfc < 0)
		return(sfc) ;			/* return error code */

	/* Chk comp code */
	if (sfc < SF_CB2) {
		/* Process special codes */
		switch (sfc) {
			case  SF_FLDFMT :
				/* Show fld format */
				strfmt(fld_desc, fwid, flags) ;
				goto again ;
			case  SF_NXTENM :
			case  SF_PRVENM :
				/* Not valid here */
				sfbeep() ;
				goto again ;
			default :
				/* Let caller handle it */
				return(sfc) ;
		}
	}


	/** Unpend fld **/
	/* Chk fld modified */
	if (st_mdt == 0)
		return(sfc) ;			/* fld not modified */
	

	/** Fld was modified **/
	/* Chk for SF_UCASE */
	if (flags & SF_UCASE)
		/* convert input to upper case */
		sfmakupr(tmp_data) ;

	/* Chk for illegal chars */
	if ((ec = lglchars(tmp_data, flags)) < 0) {
		(*sf_usrerr)(ec) ;
		goto again ;
	}


	/** Update the binary data **/
	/* Copy input str into data_ptr */
	sfblkmove(data_ptr, tmp_data, fwid) ;

	/* Zero/Blank fill the string */
	if (flags & SF_BFILL)
		c = ' ' ;
	else
		c = '\0' ;
	sffilstr(data_ptr, c, fwid) ;

	/* Return comp code */
	return(sfc) ;
}

sfblkmove ( dst, src, cnt )
char	*src, *dst ;
int		cnt ;
/*
  Move cnt bytes from src to dst.
  Note - no chk for cnt < 0.
  Note - no null appended to dst.
*/
{
	register char	*s,*d ;

	s = src ;
	d = dst ;
	while (cnt--)
		*d++ = *s++ ;
}


sffilstr ( str, c, fwid )
char	*str ;
char	c ;
int		fwid ;
/*
  Fill string with char 'c'.
  Str is null term'ed, and fwid is length of fld.
  Note - no chk for fwid < 0.
*/
{
	register char	*cp ;
	register int	n ;
	int				l ;

	l = strlen(str) ;
	n = fwid - l ;			/* # chars to fill */
	cp = str + l ;			/* fill ptr */
	while (n--)
		*cp++ = c ;
}


static	lglchars ( str, flags )
char	*str ;
int		flags ;
/*
  Chk the string for illegal characters, using bit flags in flags.
  Return	- 0 if all chars are legal, else error code.
  Note - A ' ' is ALWAYS a legal character.
*/
{
	register char	c ;
	register int	flg ;

	flg = flags ;
	while (c = *str++) {
		if (c == ' ')
			continue ;				/* always allow ' ' */
		if ((flg & SF_ANUM) == 0)
			continue ;				/* all chars allowed */
		if ((flg & SF_ANUM) == SF_ANUM) {
			/* Alpha-numeric only */
			if (!isalnum(c))
				return(SF_ESCHR) ;
		}
		else if (flg & SF_ALPHA) {
			/* Alphabetic only */
			if (!isalpha(c))
				return(SF_ESCHR) ;
		}
		else if (flg & SF_NUM) {
			/* Numeric only */
			if (!isdigit(c))
				return(SF_ESCHR) ;
		}
	}

	return(TRUE) ;
}


sfmakupr ( str )
char	*str ;
/*
  Convert all lowercase chars in str to upper case.
  'str' is null term'ed string.
*/
{
	register char	*cp ;
	register char	c ;

	cp = str ;
	while (c = *cp++) {
		if (islower(c)) {
			cp-- ;
			*cp++ = toupper(c) ;
		}
	}
}

static	strfmt ( fld_desc, fwid, flags )
struct SF_FIELD	*fld_desc ;
int				fwid ;
int				flags ;
/*
  Show fld format info.
*/
{
	char			msg[SF_MAXCOL+1] ;

	/* Standard infor */
	sffldfmt(msg, fwid, "String", flags) ;
	
	/* Show it */
	sfmsg(msg) ;
}




sffldfmt ( fmtstr, fwid, fldtype, flags )
char	*fmtstr ;
int		fwid ;
char	*fldtype ;
int		flags ;
/*
  Show 'standard' fld format information.
  Standard info is fld size, data type, & bit flags info.
  The fmt string is returned with fmt info and null term'ed.

  NOTE - some flags are not currently shown.
*/
{
	register int	f ;
	
	/* Size */
	strcpy(fmtstr, "Size=") ;
	sfitoa(fwid, fmtstr + 5) ;

	/* Type */
	strcat(fmtstr, " Type=") ;
	strcat(fmtstr, fldtype) ;

	/* Flags */
	strcat(fmtstr, "  ") ;				/* seperate flags */
	f = flags ;
	if (f & SF_UNSGN)
		strcat(fmtstr, "Unsigned ") ;
	if (f & SF_ALPHA)
		strcat(fmtstr, "Alpha ") ;
	if (f & SF_NUM)
		strcat(fmtstr, "Numeric ") ;
	if (f & SF_SPCHR)
		strcat(fmtstr, "Special_chars ") ;
	if (f & SF_UCASE)
		strcat(fmtstr, "Upper_case ") ;
	if (f & SF_NOECHO)
		strcat(fmtstr, "No_echo ") ;
	if (f & SF_AUTOUNP)
		strcat(fmtstr, "Auto_unpend ") ;

	strcat(fmtstr, " ") ;				/* seperate type specific info */
}
