/*************************************************************************
*
*
*	Name:  menu.h
*
*	Description:  Global definitions for Opus menu.
*
*
*	History:
*	Date		By		Comments
*
*	05/15/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  Opus routines module.  */




/*  Notes -

*/

/* Define user fn key values.
   Codes preceeded with a '*' can be returned from menu() */
#define		UF_SEND		SF_F1		/** Send		*/
#define		UF_RECV		SF_F3		/** Receive		*/
#define		UF_EDTYPE	SF_F5		/*  Edit Type	*/
#define		UF_SAVTYPE	SF_F5		/** Save Type	*/
#define		UF_DELTYPE	SF_SF5		/** Delete Type	*/
#define		UF_AUXMENU	SF_F7		/** Aux Menu	*/
#define		UF_RESTART	SF_F7		/*  Restart		*/
#define		UF_EXIT		SF_ABORT	/*  Exit		*/
/* #define	UF_HELP		SF_HELP		/** Help		*/
#define		UF_HELP		SF_F2		/** Help <<< PATCH */
#define		UF_ERSINP	SF_RSTWIN	/** Ers INP		*/



/* Some other global const's */
#define		FKLABSIZ	9		/* # chars in fn key label */
#define		PCFNSIZ		64		/* # char in pc filename */
#define		DSNSIZ		44		/* # chars in data set name */
#define		XFTSIZ		44		/* # chars in xfer type data field */


/* Define some extern's */
extern  struct SF_WINDOW
    mainwin, fnamwin, dnamwin, xftwin, rcntwin, dashwin, fnkeywin, xfpwin;
extern	char	fkdata[][FKLABSIZ+1] ;
extern	int		recfmt1, recfmt2 ;	/* rec fmt tmp vars */
extern	unsigned reccnt ;			/* record count */
extern	char	xftbuf[] ;			/* xfer type / operands tmp buf */


/* Define some 'semaphores'.
   These value are returned by some menu.c internal fn's. */
#define		OK		TRUE
#define		ERR		FALSE

/** Menu screen global constants **/

#define		NCOL	SF_MAXCOL+1		/* # cols on screen			*/

/* Filename window params */
#define		FNSROW	4	/* Starting row for window */

/* Fn key box params */
#define		FKLSIZ	1	/* # chars in fn key label numbers		*/
#define		FKDSIZ	FKLABSIZ	/* # chars in fn key label data	*/
#define		FKNL1	1	/* col for 1st fn key label number		*/
#define		FKNL2	FKNL1+FKLSIZ+FKDSIZ+1
						/* col for 2nd fn key label number		*/
#define		FKD1	FKNL1+FKLSIZ	/* start col for col 1 data	*/
#define		FKD2	FKNL2+FKLSIZ	/* start col for col 2 data	*/
#define		FKBSIZ	FKD2+FKDSIZ+1	/* Size of fn key box		*/

/* Transfer parameters window params */
#define		TP1LBL	27	/* 1st col labels					*/
#define		TP1LSIZ	14	/* size of 1st col prompts			*/
#define		TP1DATA	TP1LBL+TP1LSIZ+1	/* 1st col data		*/
/* #define	TP1DSIZ	8	/* size of 1st col data				*/
#define		TP2LBL	53	/* 2nd col labels					*/
#define		TP2LSIZ	18	/* size of 2nd col prompts			*/
#define		TP2DATA	TP2LBL+TP2LSIZ+1	/* 2nd col data		*/
/* #define	TP2DSIZ	6	/* size of 2nd col data				*/

/* Window 'frame' params */
#define		WFDSH1	2	/* Row # of 1st dashed line			*/
#define		WFDSH2	FNSROW+6	/* Row # of 2nd dashed line	*/
#define		WFHFX	FKBSIZ+2	/* Col # of vert line between
								fn key box & xfer parms		*/
