/*************************************************************************
*
*
*	Name:  sfio.c
*
*	Description:  Low level i/o for SForm routines.
*					sfoutc()	- output character.
*					sfouts()	- output a string.
*					sfoutns()	- output n characters.
*					sfinc()		- input a character.
*
*
*	History:
*	Date		By		Comments
*
*	04/18/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	**>> Cursor update code should be smarter.
*/

#include	"/sform/src/sfint.h"



sfoutc ( c )

char	c ;

/* Output the character to the terminal.

   ** NOTE **
   Cursor update code should be smarter.
*/
{

#if	(SF_ALTOS || ANSI)
	write(1, &c, 1) ;
#else
	tputc(c) ;
#endif

	}

sfouts ( str )

char	*str ;

/* Output a null terminated string.
*/
{
	register char	*ptr ;
	register char	c ;


	ptr = str ;
	while ( (c = *ptr++) )
		sfoutc(c) ;
	}



sfoutns ( str, cnt )

char	*str ;
int		cnt ;

/* Output 'cnt' chars from string.
*/
{
	register char	*ptr ;
	register int	n ;


	n = cnt ;
	ptr = str ;
	while ( n-- > 0 )
		sfoutc(*ptr++) ;
	}

sfinpc ()

/* Input a character.
   Return = integer case of input character.
*/

{
	register int	rv ;
	char	c ;


#if	(SF_ALTOS || ANSI)
	rv = read(0, &c, 1) ;
	/* >>> Check for error ??? */
	rv = (int)c & 255 ;
	return(rv) ;
#else
	rv = (int) tgetc() ;
#endif

	}
