/*************************************************************************
*
*
*	Name:  getc.c
*
*	Description:  'Extended' getc function for SForm input routines.
*
*
*	History:
*	Date		By		Comments
*
*	03/15/84	waf
*	03/29/84	waf		Changed calling convention.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  The Altos code assumes that CBREAK mode is set (e.g. single char i/o),
	and echo is turned off.

*/

#include	"/sform/src/sfint.h"
#include	"/sform/bld/sdchars.h"
#include	<sgtty.h>



sfgetc ()

/*
  Synopsis -
	Extended getchar routine.
	Returns a signed integer, representing the input value.

  Description -
	$

  Return -
	return val	= A signed value.
				  Values from 0 to 255 are reserved for 'normal' chars.
				  Other values are defined in sform.h.

  Notes -
  *> It is assumed that 'cbreak' and '-echo' modes have been set by sfinit().
  > Unpend chars are taken from sfcntrl[] array.
  > The value returned is of type int, and is a signed value.
*/

{
	register int	cval ;
	register char	c ;
	int		i ;
	int		fkv ;
	extern	char	*sfcntrl[] ;


	/** Get char **/
	c = sfinc() ;
	cval = (int)(c & 255) ;


	/** Get char type & value **/
	if ( c == sf_delchar ) {

		/* erase char */
		cval = SF_CDEL ;
		}
	
	else if ( c == sf_killchar ) {
		
		/* kill char */
		cval = SF_CKILL ;
		}

	else if ( c == *sfcntrl[27-20]
	  || c == *sfcntrl[28-20] ) {	/* primary or secondary unpend */

		/* unpend */
		cval = SF_CUNP ;
		}

	else if ( c == FKLEAD ) {

		/* Fn Key */
		c = sfinc() ;		/* fn key value */
		fkv = (int)(c & 255) ;
		i = 0 ;
		/* search the fn key array */
		for ( ;; ) {
			if ( fkary[i][0] == -1 ) {	/* end of array */
				/* unknown fn key value */
				cval = SF_CBFN ;		/* undefined fn key */
				break ;
				}
			if ( fkary[i][0] == fkv ) {
				/* found it */
				cval = fkary[i][1] ;	/* Fn Key code */
				if ( cval == -1 )
					cval = SF_CBFN ;	/* undefined fn key */
				break ;
				}
			i++ ;
			}
		}

	else {

		/* 'Normal' char - chk range */
		if ( cval < CHARLO || cval > CHARHI )
			cval = SF_CBAD ;
		}

	return(cval) ;
	}
