:! BCDBIN - Convert an 8 byte packed decimal string to a binary number
:#
:     BCDBIN converts a packed decimal (Binary Coded Decimal)
:     string in X$ to a signed BINary number in X.
:     Conversion assumes signed with hex D in the low order nibble for
:     negative and any other value positive.  The number is assumed to be
:     right justified in X$.  Leading zeros are allowed for any size
:     input number although more than 9 significant digits will result
:     in numeric over flow for X.
:     Care should be taken that the input string is valid BCD digits,
:     no editing of the input string occurs.
:> CALLING SEQUENCE
:     X$ - packed BCD string input field
:     GOSUB 8000
:     X  - signed BINary number with value of packed X$
:$ STORAGE USED
:     I% - INPUT STR CHAR POINTER
:     X% - TEMPORARY VALUE OF X
::
8100 REM \ BCDBIN
8102 LET X=0                           :Clear X
8104 FOR I%=1 TO LEN(X$)-1             :Scan X$ except for last byte
8106   LET X%=ASC(X$[I%,I%])           :Extract one byte to work with
8108   LET X=X*100+SHFT(X%,-4)*10+AND(X%,15)     :Add in digits to X
8110 NEXT I%
8112 LET X%=ASC(X$[I%+1])              :Get last byte
8114 LET X=X*10+SHFT(X%,-4)            :Add in last digit
8116 IF AND(X%,15)=13 THEN LET X=-X    :Negate on hex D as sign
8118 RETURN
8130 REM * END BCDBIN.SL 8/29/78
