/*************************************************************************
*
*
*	Name:  xltbchan.c
*
*	Description:  Translate BBasic channel to XENIX file descriptor
*				xltbchan()	- xlat bb chan to fd.
*				xltbchan()	- xltbchan() and trap file not open.
*
*
*	History:
*	Date		By	Comments
*
*	03/14/83	mas
*	04/12/83	mas	added check for closed file
*	05/10/83	mas	changed to set lastfileno
*	08/01/83	waf	If illegal chan# is input, trap BEIFN error here.
*	08/01/83	waf	xlt2bchan() added to trap BEFNO (channel not open) errors.
*	10/27/83	waf	Use BBCHANS param.
*	10/28/83	waf	Use badchan()/badfchan() macros to chk legal channel #.
*					Use frptr in xltbchan().
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	returns -1 if channel not open
	returns 0 if readable file (these return the modes used by open())
	returns 1 if writable file    "     "     "    "    "   "   "
	returns 2 if read/write file  "     "     "    "    "   "   "
	returns 16 if channel was 16, xfd set to 0


Modification notes -

8/1/83	waf
  The xltbchan() function was changed to trap illegal channel numbers,
  instead of returning an error flag to the calling code.
  An error flag of -1 is now used exclusively to flag 'channel closed'.
  The xlt2bchan() function was added to trap BEFNO (file not open) errors.


.SH */

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


xltbchan ( chan, xfd )

int	chan;	/* Basic channel number to convert */
int	*xfd;	/* Place to put Xenix file desc */
{
	register unsigned		i;
	register struct frec	*frptr;

	if ( badchan(chan) )
		/* illegal chan# */
		bberr(BEIFN);

	/* chk for console */
	if (chan == 16) {
		*xfd = 0;
		return(16);
		}

	lastfileno = chan;	/* set last channel number */

	frptr = &ust.ftab[chan] ;	/* get ptr to file table entry */

	/* get fildes */
	i = frptr->xfd ;		/* fildes for this chan */
	if ( i == IDLE)	/* check for closed file */
		return(-1);		/* channel not open */
	else
		*xfd = i ;

	/* get mode type */
	i = frptr->opmode ;		/* mode for this chan */
	if ((i & RW_FM) == RW_FM)
		return(2);
	if ((i & WR_FM) == WR_FM)
		return(1);
	if ((i & RD_FM) == RD_FM)
		return(0);
	
	return(-1);	/* should never get here */
	}

/* 
.SH */

xlt2bchan ( chan, xfd )

int	chan;
int	*xfd;

/* Same as xltbchan(), but traps BEFNO (channel not open) errors. */

{
	register int	i;

	i = xltbchan(chan, xfd);
	if ( i < 0 )
		bberr(BEFNO);		/* trap 'file not open' errors */
	return( i );
	}
