/*************************************************************************
*
*
*	Name:  xcall7.c
*
*	Description:  XCALL 7 and STMA 21  statements. 
*
*
*	History:
*	Date		By		Comments
*
*	4/20/83	waf
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */
#include	"/bb/include/ptype.h"


xcall7 ( scrndes, f, xrow, xpos, xcol, xwid, xflgs )

STRDES	scrndes;		/* SCRN$ descriptor */
int		f;
NUMDES	xrow, xpos, xcol, xwid, xflgs;

{
	register char	*ptr, *endptr ;
	int	row, fld ;
	int	currow, retcol, retpos, curfld;
	int	b;
	int	ftype;		/* type of f ( f < 0, 0 < f < 100, f > 100 ) */
	int	pos, endpos ;

	ptr = scrndes.data ;		/* ptr to SCRN$ */
	endptr = ptr + scrndes.curlth ;		/* end of SCRN$ */
	endpos = scrndes.curlth ;		/* (pos + x) must be < endpos */

	/** get fld & row ( field# and row# ), and type of f **/
	if ( f < 0 ) {
		/* f = reletive field # */
		fld = -f ;
		ftype = 1 ;
		}
	else {
		if ( f > 100 ) {
			/* f = RRFF */
			fld = f % 100 ;
			row = f / 100 ;
			ftype = 3 ;
			}
		else {
			/* f = field #, xrow = row # */
			fld = f ;
			row = getvj( &xrow ); 
			ftype = 2 ;
			}
		}

	/** get pos of our field **/
	/* if f>0, fld & row = field# & row#
			else fld = reletive field# */
	curfld = 0 ; 
	currow = 1 ;		/* init row & field cntrs */
	pos = 0 ;		/* init SCRN$ ptr */
	forever {
		if ( pos >= endpos ) {
			/* bad end of $ */
			pos = -1 ;
			goto xc7ret ;
			}

		/** chk out next field **/
		b = (int) (*(ptr + pos) & 255);		/* next byte */
		if ( b == 0 ) {

			/** new row **/
			currow++ ;		/* inc row cnt */
			curfld = 0 ;	/* reset fld cntr */
			}

		else {

			/** next field **/
			curfld++ ;		/* inc field cnt for this row */
			switch ( ftype ) {

			case 1 :		/* fld = reletive field # */
				if ( b != 0 )
					if ( --fld == 0 )
						goto xc7ret ;		/* reletive field # found */
				break ;		/* keep looking */

			case 2 :
			case 3 :		/* row = row #, fld = fld # */
				if ( currow > row ) {
					/* not enough fields on target row */
					pos = -1 ;
					goto xc7ret ;
					}
				if ( currow != row )
					/* not at our row yet */
					break ;
				/* we are at our row, are we at our field yet? */
				if ( curfld == fld )
					goto xc7ret ;		/* this is our field */
				}		/* end switch */
			}

		pos += 3 ;		/* ptr to next {col,wid,flg} group in SCRN$ */
		}		/* loop until we're at our field */


xc7ret:		/** return values **/
	/* pos = position of field or -1 */
	/* currow = current row# */
	retpos = (pos == -1)? -1 : (pos + 1) ;
	putvl( &xpos, (long) retpos );			/* return pos */
	putvl( &xrow, (long) currow );		/* return row# */
	if ( isvar(&xcol) == FALSE )  return ;
	putvl( &xcol, (long) b );		/* return col */
	if ( isvar(&xwid) == FALSE )  return ;
	if ( pos + 1 < endpos )
		putvl( &xwid, (long) (*(ptr + (pos + 1)) & 255) );
	if ( isvar(&xflgs) == FALSE )  return ;
	if ( pos + 2 < endpos )
		putvl( &xflgs, (long) (*(ptr + (pos + 2)) & 255) );
	}

