/*************************************************************************
*
*
*	Name:  ustinit.c
*
*	Description:  Initializes the User Status Table
*
*
*	History:
*	Date		By	Comments
*
*	03/15/83	mas
*	04/14/83	WEB	changed '/bbsyslib' to '/bb/syslib'
*	04/20/83	mas	changed to turn on ust.noikey
*	06/29/83	mas	changed to not use ust.noikey for run-only
*				state as this leaves a window during a swap
*				by having the START p-code clear the 
*				noikey flag and then the first  stmtx causes
*				an IKEY msg
*	10/28/83	waf	Use chanloop() macro.
*				
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"

extern int errno;	/* XENIX error number */
extern long lseek();

ustinit()
{
	register int	i;
	int	fd;
	register char	*cp;
	struct	specialno numrec;

	/* Clear User Status Table */
	for (i=0, cp=(char *)&ust; i<sizeof(ust); ++i)
		*cp++ = '\0';

	ust.termtype = defterm;		/* found in crts.c */

	prctl(-19,0);			/* reset UST */

	ust.slibfd = IDLE;
	ust.ulibfd = IDLE;

	time(&ust.logintime);		/* set start of p-machine execution */

	strcpy(ust.libdir,xlibdir);
	strcpy(ust.sysdir,ust.libdir);

	strcpy(ust.defoutput,"?LPT");

	/* set all file table entries to IDLE */
	chanloop( i )
		ust.ftab[i].xfd    = IDLE;

	/* set all lock table entries to IDLE */
	for (i=0; i<LCKTBLSIZ; ++i)
		ust.ltab[i].lfd    = IDLE;

	/* get job number from basic.no */
	if ((fd = open(xnumfile,2)) < 0) {
		bbxerrno();
		}

	if (locking(fd,1 /*LOCK*/,0L) < 0)
		bbxerrno();

	if (read(fd,(char *)&numrec,sizeof(numrec)) < sizeof(numrec))
		bbxerrno();

	for (i=0; i<JOBMAX; ++i)
		if ((int)numrec.jobno[i] == IDLE)
			break;

	if (i < JOBMAX) {
		numrec.jobno[i] = TRUE;
		lseek(fd,0L,0);  /* position for write */
		if (write(fd,(char *)&numrec,sizeof(numrec)) < sizeof(numrec))
			bbxerrno();
		ust.pjobno = (long)i;
		lseek(fd,0L,0);  /* position for UNLOCK */
		if (locking(fd,0 /*UNLOCK*/,0L) < 0)
			bbxerrno();
		} 
	else
		bberr(BEIJN);

	close(fd);
	return;
	}

