/*************************************************************************
*
*
*	Name: 	stma9.c
*
*	Description:  STMA 9
*
*
*	History:
*	Date		By	Comments
*
*	03/02/83	WEB
*	04/28/83	mas	changed to use bpopen instead of popen
*	06/10/83	WEB	added acntcode variable
*	06/27/83	mas	added registers where possible
*	07/22/83	waf	Added conditional code for BB/PC -
*					STMA 9,0 returns 'AAAAA' in BB/PC.
*	07/25/83	waf	Added conditonal code for BB/PC -
*					uses getdir() MSDOS fn for STMA 9,1
*	09/09/83	waf	STMA 9,1 - added call to bpclose().
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */

/*************************************************************/
/*                                                           */
/*                          N O T E                          */
/*                          -------                          */
/*	This routine uses several section (3) items	     */
/*	which increase the size of the object module	     */
/*	significantly. It is reccommended that local	     */
/*	versions of getpwent for STMA 9,0 and the pipe	     */
/*	for the use of pwd in STMA 9,1 be written to	     */
/*	reduce the amount of code generated.		     */
/*************************************************************/

/* Notes -

09/09/83	waf
  Previously, STMA 9,1 code did not call bpclose(). This left a 'defunct'
  process lying around. (The process was apparantly cleaned up by the 
  terminaion of the parent 'bb' process).

.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include <stdio.h>
#include <pwd.h>

#define MSGLEN 133
#define ACCTLEN 32

static char acntcode[ACCTLEN] = '\377';


stma9 (id, string)

int id;
STRDES string;
{
	int pfile;
	char msg[MSGLEN];
	register char *cptr;
	register int i;

	switch (id) {

	case 0:					/** account code **/
		if (acntcode[0] == '\377') {

#if	BB_X86		/* BB/X86 uses login name */
			cptr = getlogin();			/* get login name */
#endif
#if	BB_PC			/* BB/PC uses constant val of 'AAAAA' */
			cptr = "AAAAA";
#endif

			if (cptr == (char *) 0)
				cptr = "\0";
			strcpy(acntcode, cptr);		/* save it for next time */
			}
		movbd(acntcode, ACCTLEN, &string);	/* copy to output string */
		break;


	case 1:					/** current directory **/

#if	BB_X86		/* BB/X86 uses shell call to get current dir */
		pfile = bpopen("/bin/pwd", 0/*READ*/);		/* invokde "pwd" */
		cptr = msg ;		/* buf ptr */
		i = MSGLEN ;
		while ( read(pfile,cptr,1) == 1 && *cptr != '\n' && i-- > 0 )
			cptr++ ;
		*cptr = '\0' ;		/* term string */
		bpclose( pfile );		/* close the pipe */
#endif
#if	BB_PC			/* BB/PC uses MSDOS specific getdir() fn */
		msg = getdir();
		if ( msg == (char *)0 )
			i = errxlat( errno );
		bberr( i );
#endif

		movbd(msg, strlen(msg), &string);	/* copy to output string */
		break;


	case 2:					/** current program **/
		movbd(ust.pname, PATHSIZE, &string);
		break;

	
	case 3:					/** current output file **/
		movbd(ust.defoutput, PATHSIZE, &string);
		break;


	case 4:					/** library directory **/
		movbd(ust.libdir, PATHSIZE, &string);
		break;


	case 5:					/** system directory **/
		movbd(ust.sysdir, PATHSIZE, &string);
		break;

	default:					/* all others just exit */
		return;

		} /* end-switch */

	updcl(&string);				/* update current length */

	} /* end-stma9 */

