/*************************************************************************
*
*
*	Name:  stma1.c
*
*	Description:  STMA 1, 2, 3, 4, 5, 6, 7
*
*
*	History:
*	Date		By		Comments
*
*	3/25/83	waf	
*	4/1/83		mas		made stma 7,0 call termctl as 7,7
*	05/24/83	WEB		added call to setik1 for STMA 4,6
*	6/24/83 	mas		changed to use registers where possible
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> Items 16, 17, 18, & 19 in STMA 3 & 4 are not implemented.

> Items 7 & 8 in STMA 5, 6, & 7 are not compatable with BBIII.


.SH
*/
#include	"/bb/include/ptype.h"
#include "/bb/include/pextern.h"
/*


			** STMA 1 & 2 **
*/

stma1 ( field, numvar )

int	field;
NUMDES	numvar;
	{
register int	*ptr ;

	ptr = get1addr( field );		/* get addr of field */
	if ( ptr != -1 )  putvj( &numvar, *ptr );
	}

stma2 ( field, value )

int	field, value ;
	{
register int	*ptr ;

	ptr = get1addr( field );
	if ( ptr != -1 )  *ptr = value ;
	}


get1addr ( field )

int	field ;

/* return addr of user table entry corresponding to field */

	{
	switch ( field )
		{
		case 0 :	return( &ust.termtype );	/* term type */
		case 1 : return( &ust.swaperr );		/* err code */
		case 2 : return( &ust.user1 );		/* word 1 */
		case 3 : return( &ust.user2 );		/* word 2 */
		case 4 : return( &ust.security );	/* security code */
		default :	return( -1 );
		}
	}

/* 
.SH
			** STMA 3 & 4 **
*/

int	intflag;		/* flags int refs to ust entries */


stma3 ( field, numvar )

int	field;
NUMDES	numvar;
	{
register int	*iptr;
register char	*bptr;

	iptr = get3addr( field );
	bptr = iptr ;
	if ( iptr != -1 )
		if ( intflag == 0 )
			putvj( &numvar, ((int) *bptr) & 255 );
		else
			putvj( &numvar, *iptr );
	}

stma4 ( field, value )

int	field, value;
	{
register char	*bptr;
register int	*iptr;

	iptr = get3addr( field );
	bptr = iptr ;
	if ( iptr != -1 )
		if ( intflag == 0 )
			*bptr = (char) value ;
		else
			*iptr = value ;

	if (field == 6)
		setik1(ust.ikey1);
	}


get3addr ( field )

int	field;

/* get addr of field for stma 3 & 4 */

	{

	intflag = 0 ;		/* assume byte/char field */
	switch ( field )
		{
		case 0 :	return( -1 );					/* de-attach char */
		case 1 : return( &ust.lcan );			/* line cancel */
		case 2 : return( &ust.dele );			/* char delete echo */
		case 3 : return( &ust.del );			/* char delete char */
		case 4 : return( &ust.unpend1 );		/* primary unpend */
		case 5 : return( &ust.unpend2 );		/* secondary unped */
		case 6 : return( &ust.ikey1 );		/* primary int char */
		case 7 : return( &ust.ikey2 );		/* secondary int char */
		case 8 : intflag = 1 ;
					return( &ust.pagewidth); 	/* page width */
		case 9 : intflag = 1 ;
					return( &ust.tabsiz );		/* tab size */
		case 10 : intflag = 1 ;
					return( &ust.inputmax );	/* max input chars */
		case 11 : return( -1 );
		case 12 : return( &ust.lcane1 );		/* primary line cancel char */
		case 13 : return( &ust.lcane2 );		/* secondary line cancel char */
		case 14 : return( &ust.pad );			/* pad char */
		case 15 : intflag = 1 ;
					return( &ust.padcnt );		/* # pad chars sent */
		default : return( -1 );
		}
	}

/* 
.SH
			** STMA 5, 6, & 7 **
*/

stma5 ( flag, numvar )

int	flag;
NUMDES	numvar;
	{
register int	val;

	switch ( flag )
		{
		case 0 : 
			{
			val = ust.noecho ;			/* no echo */
			break;
			}
		case 1 :
			{
			val = ust.lower ;			/* allow lower case */
			break;
			}
		case 2 :
			{
			val = ust.ctlchar ;			/* allow cntrl chars */
			break;
			}
		case 3 :
			{
			val = ust.nocolumn ;		/* disable column cntr */
			break;
			}
		case 4 :
			{
			val = ust.nomsgs ;			/* no messages allowed */
			break;
			}
		case 5 :
			{
			val = ust.noikey ;			/* disallow int's */
			break;
			}
		case 6 :
			{
			val = -1 ;
			break;
			}
		case 7 :
			{
			val = ust.noecho ;			/* no echo */
			break;
			}
		case 8 :
			{
			val = ust.xfrcrlf ;			/* NAS */
			break;
			}
		default : val = -1 ;
		}
	if ( val != -1 )  putvj( &numvar, val );
	}

stma6 ( flag )

int	flag;
	{

	termctl( -18, flag, -1 );		/* use termctl code */
	}

stma7 ( flag )

int	flag;
	{

	if (flag == 0)
		flag = 7;	/* can't tell -0 from 0 */

	termctl( -18, -flag, -1 );		/* use termctl code */
	}
