/*************************************************************************
*
*
*	Name:  prul
*
*	Description:  numeric print-using formats
*
*
*	History:
*	Date		By	Comments
*
*	03/09/83	WEB
*	06/16/83	mas	memory and speed squeeze
*	06/30/83	WEB	fix problem with zero suppress (O)
*	07/08/83	WEB	fix problem with overflow on Fw.d
*	07/14/83	mas	changed zero suppression to blank entire mask
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


prul(value, pbufx)
long	value;
PRUDES	*pbufx;
{
   register PRUDES *pbuf;
   register int e, i, j, w, d, count, sign, iolength, tlength, decimal;
   char tmp1[32], tmp2[32], digit, fmtchar, *ioptr, *tptr;
   char getdigit(), getfmt();

   pbuf = pbufx;
					/* check for end of format */
   if (pbuf->prfmtptr >= pbuf->prfmtend)

      if (pbuf->practivecount == 0)

	 return;			/* exit if no active formats */

      else {
					/* otherwise start over again */
	 pbuf->prfmtptr = pbuf->prfmtdes.data;

	 chkpru(pbuf);

      }

   fmtchar = getfmt(pbuf);

   switch (fmtchar) {

      case 'L':				/* variable repeat count */
	 if (getfmt(pbuf) != '9')
	    bberr(BEIFS);		/* error if not L9 */

	 pbuf->prrptcnt = (int) value;	/* use input value as repeat count */

	 pbuf->prrptptr = pbuf->prfmtptr;

	 pbuf->practivecount++;		/* L9 counts as an active */

	 break;

      case 'D':				/* alphanumeric formats */
      case 'E':
      case 'F':
      case 'K':

	 w = getnum(pbuf, &count);	/* get field width */

	 if (count == 0)
	    w = 0;			/* default is 0 */
	 
	 if (fmtchar == 'K') {		/* convert to octal for K */

	    i = 0; j = 0;

	    do {			/* convert in reverse order */
	       tmp2[i++] = ((char)(value & 7L)) + '0';
	       value = (value >> 3L) & 536870911L;
	    } while (value > 0L);

	    while (i > 0)		/* reverse into destination as result */
	       tmp1[j++] = tmp2[--i];

	    tmp1[j] = '\0';		/* null terminate the result */

	    d = 0;			/* set unused items to 0 & FALSE */

	    sign = FALSE;

	    decimal = FALSE;

	 } else {			/* convert to decimal for all others */

	    if (getfmt(pbuf) != '.')
	       bberr(BEIFS);		/* error if . missing */

	    d = getnum(pbuf, &count);	/* get decimal width */

	    if (count == 0)
	       d = 0;			/* default is 0 *

					/* set sign flag */
	    sign = (value < 0) ? TRUE : FALSE;
	    
	    if (sign == TRUE)		/* make sure value is now positive */
	       value = -value;

					/* set decimal flag */
	    decimal =  (d > 0) ? TRUE : FALSE;

	    cbdl(tmp1, value, 0);	/* convert number to string */

	 }

	 tlength = strlen(tmp1);	/* set length of number  */

	 tptr = tmp1;			/* set pointer to number */

	 iolength = w;			/* set length of i/o field  */

	 ioptr = pbuf->prioptr;		/* set pointer to first i/o column */

	 if (value == 0L && pbuf->przerosuppress == TRUE) {

	    while (iolength > 0) {	/* fill with spaces for 0 suppress */
	       /*if (*ioptr == pbuf->proverwrite)*/
	       /*  *ioptr = ' ';*/
	       *ioptr++ = ' ';
	       iolength--;
	    }

	 } else {			/* otherwise format value */

					/* insert sign here for D */
	    if (fmtchar == 'D' && sign == TRUE) {
	       *ioptr = '-';		/* IGNORING over-write character */
	       ioptr++;
	       iolength--;
	    }

					/* now re-start from the back */
	    tptr = tptr + tlength - 1;

	    ioptr = ioptr + iolength - 1;

	    e = 0;

	    if (fmtchar == 'E') {	/* insert sign here for E */
	       if (sign == TRUE)
		  *ioptr = '-';		/* IGNORING over-write character */
	       else
		  *ioptr = ' ';		/* E inserts space if positive */
	       ioptr--;
	       iolength--;
	    }

					/* move number */
	    while (e == 0 && iolength > 0 &&
		  (tlength > 0 || (decimal == TRUE && d >= -1))) {
	       if (decimal == TRUE && d == 0)
		  e = puto('.', &ioptr, &iolength, pbuf->proverwrite);
	       else {
		  digit = getdigit(&tptr, &tlength);
		  if (digit == '\0')
		     digit = (d >= -1) ? '0' : ' ';
		  e = puto(digit, &ioptr, &iolength, pbuf->proverwrite);
	       }
	       d--;
	    }

	    				/* insert sign here for F if it fits */
	    if (fmtchar == 'F' && sign == TRUE)
	       if (iolength > 0) {
		  *ioptr = '-';		/* IGNORING over-write character */
		  ioptr--;
		  iolength--;
	       } else
		  e = 1;		/* set flag for overflow if won't fit */

	  				/* insert overflow character */
	    if (e != 0 || tlength > 0 || (decimal == TRUE && d > -1)) {
	       *pbuf->prioptr = '*';	/*    in first column */
	       iolength = 0;		/* set length to 0 to stop it all */
	    }

					/* pad with fillchar if D or E */
	    if (fmtchar == 'D' || fmtchar == 'E')
	    while (iolength > 0) {
	       *ioptr = pbuf->prfillchar;
	       ioptr--;
	       iolength--;
	    }

	 }

					/* update the PRUDES buffer */
	 pbuf->proverwrite = ' ';	/* reset over-write to space */
				
	 pbuf->przerosuppress = FALSE;	/* clear zero suppression */

					/* save last active field pointer */
	 pbuf->prlastactive = pbuf->prioptr;

	 pbuf->practivecount++;		/* numerics count as active */

	 pbuf->prioptr += w;		/* move i/o pointer past field */

	 break;

      default:
	 bberr(BEIFS);			/* others are an error */

   } /* end-switch */

   chkpru(pbuf);			/* process literals, etc. */

} /* end-prul */

char getdigit(string, length)
char	**string;
int	*length;
{
   register char c;

   if (*length > 0) {
      
      c = **string;			/* get digit from number if possible */
      (*string)--;
      (*length)--;

   } else

      c = '\0';				/* otherwise use a null */
   
   return(c);

} /* end-getdigit */

puto(c, ptr, length, overwrite)
char	c;
char	**ptr;
int	*length;
char	overwrite;
{
   while (*length > 0)
      if (**ptr == overwrite) {		/* insert digit if overwritable */

	 **ptr = c;
	 (*ptr)--;
	 (*length)--;
	 return(0);			/* and return success */

      } else {

	 (*ptr)--;			/* otherwise try next column */
	 (*length)--;

      }

   return(1);				/* return failure if out of room */

} /* end-puto */
