/*************************************************************************
*
*
*	Name:  pmdump.c
*
*	Description:  Dumps the p-code, stack, UST, and line number table
*			to push file or pmd (.pm) file.
*
*
*	History:
*	Date		By	Comments
*
*	03/04/83	mas
*	04/21/83	mas	Added mode to not append .pm to post 
*				mortum dump file name
*	05/13/83	mas	changed to zero line table size if it 
*				wasn't loaded
*	05/16/83	mas	removed unused variables and used registers
*				where possible
*	07/28/83	mas	changed to set pushstk on push to push file
*	09/02/83	waf		Pass SYSER_XIT code to pexit().
*	11/18/83	waf		Added code for pgm overlays.
*						Rewrote chksum computation code.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	This function dumps the pmd file or the push file for a swap
	or a break to the debugger. These are referred to as PUSH,
	which is what happens during a normal SWAP (no UST written).
	The PMD refers to creating and writing the post-mortum dump.
	The PMD has the UST written in it. When the BREAK p-code
	is encountered, the debugger is swapped to. In this case the
	PMD file is written to the push file. In both the normal PUSH
	and the debugger PUSH, pushfd is assumed to be opened as the
	push file and the caller must position to the correct spot to 
	begin writing to the push file.

11/18/83	waf
  Overlays -
  If this is a push (e.g. SWAP), and the current pgm contains base and overlay
segments, only the overlay segment is written out.
  If this is a pmd or a setup for a debugger call, all code is written out.
An OVLYPGM file is converted to a NORMPGM file (codsiz & bcdsiz are adjusted).
(Note that file type 'BASEPGM' is converted to NORMPGM by loadpc()).

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/pexit.h"


pmdump (PC,SP,mode)

POINTER	PC,SP;
int	mode;	/* mode 0 = PUSH
					1 = PMD
					2 = Push info for Debugger call ( Push w/ UST ).
					3 = PMD w/o .pm appended to name */
{
	register int	i;
	register unsigned *uptr;
	int		fd;
	char	pname[PATHSIZE];
	struct phead pmdhead;
	long	lpos;
	unsigned savftype;
	char	*cptr;


#ifdef	dbug
	printf("pmdump: mode,magic = %d %u\n", mode,pcheader.magic);
#endif
	pmdsw = FALSE;		/* turn off pmd switch to prevent error loop */

	/* chk push depth */
	if (mode == 0 && ust.pushcnt >= 10)
		bberr(BESWP);


	/** Set up header **/
	spscan(ust.pname);	/* remove trailing spaces and stuff */
	pmdhead = pcheader;	/* get local copy */
	if ( pmdhead.magic == BASEPGM )
		panic() ;		/* should have been converted by loadpc() */

	/* chk file type.
	   If PMD or Debug push of OVLYPGM file,
	   force type to NORMPGM */
	if ( mode > 0 )		/* PMD or Debug push */
		if ( pmdhead.magic == OVLYPGM ) {
			/* convert ovly pgm */
			pmdhead.codsiz += pmdhead.bcdsiz ;	/* get total code size */
			pmdhead.bcdsiz = 0 ;		/* bcdsiz must be 0 in normal pgms */
			pmdhead.magic = NORMPGM ;	/* change type */
			}

	pmdhead.symsiz = 0;
	pmdhead.stksiz = SP.B - (char *)BFP;
	pmdhead.maxsiz = 0;

	if (pmdhead.noltab == TRUE)	/* zero line table size if not loaded*/
		pmdhead.ltabsiz = 0;

	if (mode > 0)
		pmdhead.ustsiz = sizeof(ust);
	else
		pmdhead.ustsiz = 0;

	pmdhead.totsiz = pmdhead.codsiz + pmdhead.ltabsiz +
		pmdhead.symsiz + pmdhead.stksiz + pmdhead.ustsiz +
		pmdhead.bcdsiz ;											/* ??? */

	pmdhead.lasterrno = lasterrno;
	pmdhead.begmem = begmem;
	pmdhead.pcerr = pcerr;
	pmdhead.pclast = pclast;
	pmdhead.lastfileno = lastfileno;
	pmdhead.randseed = randseed;
	pmdhead.timeleft = timeleft;

	for (i = 0; i<4; ++i)
		pmdhead.cram[i] = cram[i];

	pmdhead.pc  = PC;
	pmdhead.fp  = FP;
	pmdhead.bfp = BFP;
	pmdhead.gfp = GFP;
	pmdhead.sp  = SP;

	pmdhead.pcstmtx.sxflag = ust.stmtx.sxflag;

	if (mode == 0/*PUSH*/) {
		pmdhead.derror = FALSE;
		pmdhead.dikey = FALSE;
		pmdhead.dbreak = FALSE;
		}

	pmdhead.dcontin = FALSE;
	pmdhead.dabort = FALSE;
	pmdhead.dabortp = FALSE;

	/* compute checksum */
	pmdhead.chksum = hdchksum(&pmdhead) ;


	/* get fd for push file */
	if (mode == 1 /*PMD*/ || mode == 3/*PMD w/o .pm*/) {
		/* make pmd file name */
		strcpy(pname,ust.pname);
		if (mode == 1)
			strcat(pname,".pm");

		/* open pmd file */
		if ((fd = creat(pname,0666)) < 0) {
			bberr(BESWP);
			pexit(SYSER_XIT);
			}
		} 
	else /* PUSH | Debug push */
		fd = pushfd;	/* PUSH file */

	lpos = lseek(fd,0L,1);	/* get current position */


	/* write out header */
	if (write(fd,(char *)&pmdhead,sizeof(pmdhead)) < sizeof(pmdhead)) {
		bberr(BESWP);
		pexit(SYSER_XIT);
		}

	if (mode == 3) {  /* save or replace  throw out 2 char extensions*/
		i = strlen(ust.pname) - 3;
		if (i > 0 && ust.pname[i] == '.')
			ust.pname[i] = '\0';
		}

	/* write out p-code name */
	if (write(fd,ust.pname,PATHSIZE) < PATHSIZE) {
		bberr(BESWP);
		pexit(SYSER_XIT);
		}

	lseek(fd,lpos + 512L,0); /* leave a sector for the header */

	/* write out code */
	cptr = begmem ;			/* code start */
	i = pmdhead.codsiz + pmdhead.bcdsiz ;	/* total code size */
	if ( pmdhead.magic == OVLYPGM ) {
		/* PUSH of ovly pgm - write only ovly code */
		i -= pmdhead.bcdsiz ;		/* subtract base code size */
		cptr += pmdhead.bcdsiz ;	/* inc code start ptr */
		}
#ifdef	dbug
	printf("pmdump: writing code\n");
#endif
	writuns( fd, cptr, i );

	/* write out line table.
	   i = size of code written, cptr = start of code written. */
	if (pmdhead.noltab == FALSE) {
#ifdef	dbug
		printf("pmdump: writing line table\n");
#endif
		writuns(fd, cptr+i, pmdhead.ltabsiz);
		}

	/* write out stack */
#ifdef	dbug
	printf("pmdump: writing stk\n");
#endif
	writuns(fd,(char *)BFP,pmdhead.stksiz);

	/* write out UST if needed */
	if (mode > 0 /* PMD | Debug push */ ) {
#ifdef	dbug
		printf("pmdump: writing ust\n");
#endif
		writuns(fd,(char *)&ust,sizeof(ust));
		}

	if (mode == 1 /* PMD */)
		close(fd);

	if (mode == 0)
		pushstk[ust.pushcnt+1] = lseek(fd,0L,1); /* save current pos */

	return;
	}

writuns (fd,where,amount)
int	fd;
char	*where;
unsigned amount;
{
	register int	j;


#ifdef	dbug
	printf("writeuns: fd,where,amount = %d %u. %u.\n",fd,where,amount );
#endif
	/* do 0x7fff bytes at a time because write wants integers */
	while (amount != 0) {
		j = (amount > 0x7fff) ? 0x7fff : (int)amount;
		if (write(fd,where,j) != j)
			bbxerrno();
		amount -= (unsigned)j;
		where += j;
		}
	return;
	}
