/*************************************************************************
*
*
*	Name:  pmach3.c
*
*	Description:  calls STMA, STMC, QCALL, and other procedures
*
*
*	History:
*	Date		By	Comments
*
*	03/11/83	mas
*	04/20/83	mas	added xcall16, xcall14(extract), and stma14
*	05/09/83	mas	moved PSAVE, PREPLACE, and SYSTEM to pmach2.c
*	05/09/83	mas	added call to phinc();
*	06/29/83	mas	changed to call bpause instead of pause
*				bpause handles interrupts 
*	08/26/83	waf		Return error var for STMC 23,24.
*	08/30/83	waf		Added STMC 11. Returns value to calling process
*					(exit(n)).
*	09/02/83	waf		Return NORM_XIT code to pexit() in STMC28.
*	11/11/83	waf		Combine code for STMC 39,40,41,42,44.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

waf	8/26/83
  Note - STMC 43 can not handle an error.


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/opcodes.h"
#include "/bb/include/pextern.h"
#include <signal.h>
#include "/bb/include/pexit.h"
#include "/bb/include/pcondcomp.h"


extern int sexit();
extern int onikey2();


pmach3 (pc,sp)
POINTER	pc,sp;
{
	register POINTER PC;
	register POINTER SP;
	int	i,j;
	long	l,m;
	unsigned u,v;
	char	*cptr;

	PC = pc;
	SP = sp;

#ifdef PHIST
	phinc(*PC.B,3);
#endif

	switch (((*PC.B++)&0x00ff)+768) {

/**/
		/**  STMA  **/

		case STMA1:
			stma1(*--SP.J,*--SP.N);
			break;
		case STMA2:
			stma2(*--SP.J,*--SP.J);
			break;
		case STMA3:
			stma3(*--SP.J,*--SP.N);
			break;
		case STMA4:
			stma4(*--SP.J,*--SP.J);
			break;
		case STMA5:
			stma5(*--SP.J,*--SP.N);
			break;
		case STMA6:
			stma6(*--SP.J);
			break;
		case STMA7:
			stma7(*--SP.J);
			break;
		case STMA8:
			stma8(*--SP.J);
			break;
		case STMA9:
			stma9(*--SP.J,*--SP.S);
			break;
		case STMA10:
			stma10(*--SP.J,*--SP.S);
			break;
		case STMA11:
			stma11(*--SP.L,*--SP.N,*--SP.N,*--SP.N);
			break;
		case STMA12:
			stma12(*--SP.N,*--SP.J,*--SP.J,*--SP.J);
			break;
		case STMA13:
			stma13(*--SP.S,*--SP.S);
			break;
		case STMA14:
			stma14(*--SP.S,*--SP.J);
			break;
		case STMA15:
			stma15(*--SP.S,*--SP.S,*--SP.N);
			break;
		case STMA19:
			bberr(*--SP.J);
			break;
		case STMA20:
			stma20(*--SP.J);
			break;

/**/
		/**  STMC  **/

		case STMC45:
			--SP.S;	/* throw away date and time */
		case STMC0:
		case STMC52:
			stmc0(*--SP.N,*--SP.S,*--SP.L);
			break;
		case STMC5:
			--SP.L;	/* throw away sector count */
		case STMC1:
			stmc1(*--SP.N,*--SP.S);
			break;
		case STMC46:
		case STMC47:
			--SP.S;	/* throw away date and time */
		case STMC6:
		case STMC7:
			stmc7(*--SP.N,*--SP.S);
			break;
		case STMC8:
			stmc8(*--SP.N,*--SP.S);
			break;
		case STMC9:
			stmc9(*--SP.N,*--SP.S);
			break;
		case STMC11:		/* .ERTN */
			pexit(*--SP.J);		/* exit p-mach with (type J) return value */
		case STMC17:
			stmc17(*--SP.N,*--SP.S);
			break;
		case STMC21:
			stmc21(*--SP.N,*--SP.S,*--SP.S);
			break;
		case STMC22:
			stmc22(*--SP.N,*--SP.S);
			break;
		case STMC23:
			/* set ikeys to ust values */
			setiks(ust.ikey1,ust.ikey2);
			signal(SIGQUIT,onikey2);
			goto noerr;
		case STMC24:
			setiks(ust.ikey1,oldchar.t_quitc);
			signal(SIGQUIT,sexit);
			noerr:	/* return -1 to err var */
			putvj( --SP.N, -1 );
			break;
		case STMC25:
			stmc25(*--SP.N,*--SP.S,*--SP.S);
			break;
		case STMC28:		/* .RTN */
			pexit(NORM_XIT);
		case STMC29:
			stmc29(*--SP.N,*--SP.J,*--SP.J,*--SP.J);
			break;
		case STMC34:
			stmc34(*--SP.N,*--SP.J,*--SP.J,*--SP.J);
			break;
		case STMC35:
			stmc35(*--SP.N,*--SP.S);
			break;
		case STMC36:
			stmc36(*--SP.N,*--SP.J);
			break;

		case STMC39:
		case STMC40:
		case STMC41:
		case STMC42:
		case STMC44:
			stmcopn(((*(PC.B-1)-(char)STMC39)),*--SP.N,*--SP.S,*--SP.J,*--SP.J);
			break;

		case STMC43:
			signal(SIGQUIT,SIG_DFL); /* set quit to default*/
			kill(getpid(),SIGQUIT); /* send it to ourselves */
			bpause(); 					/* wait for it */

/**/
		/**  USER CALLS  **/

		case STRPOS:
			strpos(*--SP.N,*--SP.S,*--SP.S,*--SP.J,*--SP.J);
			break;
		case VALUE:
			value(*--SP.N,*--SP.S,*--SP.N,*--SP.N);
			break;
		case QLOAD:
			qload(*--SP.S,*--SP.L);
			break;
		case QSTORE:
			qstore(*--SP.N,*--SP.S);
			break;
		case QADD:
			qadd(*--SP.S,*--SP.S,*--SP.S);
			break;
		case QSUB:
			qsub(*--SP.S,*--SP.S,*--SP.S);
			break;
		case QMUL:
			qmul(*--SP.S,*--SP.L,*--SP.L);
			break;
		case QDIV:
			qdiv(*--SP.N,*--SP.S,*--SP.L,*--SP.N,*--SP.N);
			break;
		case STMA21:
			xcall7(*--SP.S,*--SP.J,*--SP.N,*--SP.N,*--SP.N,
						       *--SP.N,*--SP.N);
			break;
		case XCAL11:
			xcall11(*--SP.S,*--SP.S,*--SP.J);
			break;
		case SWHILE:
			xcall12(*--SP.N,*--SP.S,*--SP.S,*--SP.J);
			break;
		case SUNTIL: 
			xcall13(*--SP.N,*--SP.S,*--SP.S,*--SP.J);
			break;
		case EXTRACT:
			xcall14(*--SP.S,*--SP.S,*--SP.S,*--SP.N);
			break;
		case XCAL15:
			xcall15(*--SP.S,*--SP.J,*--SP.J);
			break;
		case XCAL16:
			xcall16(*--SP.S,*--SP.J);
			break;
		default:
			panic();
		}
	TPC = PC.B;
	TSP = SP.B;
	return;
	}

