/*************************************************************************
*
*
*	Name:  paka, pakl and pakd
*
*	Description:  pack into a string variable
*
*
*	History:
*	Date		By		Comments
*
*	04/06/83	WEB
*	05/17/83	WEB		added 'register', etc to improve
*					performance
*	06/22/83	mas		memory and speed squeeze
*	11/10/83	waf		Return BEIFS error if bad char in format string.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/

#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"


paka(src, xpbuf)				/* pack alphanumeric */
STRDES src;
PAKDES *xpbuf;
{
	register int length;
	char fmtchar;
	register PAKDES *pbuf;

	pbuf = xpbuf;

	if (pbuf->pkfmtptr >= pbuf->pkfmtend)
		bberr(BEIFS);			/* error if nothing left in format */

	fmtchar = *pbuf->pkfmtptr++;		/* save and move over format */

	if (fmtchar != 'A' && fmtchar != 'S')
		bberr(BERDT);			/* wrong data type */

	if ((length = getlength(pbuf)) == -1)
		length = 1;			/* default is 1 for A and S */

	if (pbuf->pkstrptr+length > pbuf->pkstrend)
		bberr(BESSZ);			/* error if length exceeds max. */

	while (length--)			/* move the data */
		if (src.curlth > 0) {
			*pbuf->pkstrptr++ = *src.data++;
			src.curlth--;
			} 
		else
			*pbuf->pkstrptr++ = '\0';	/* move null if past end of source */

	chkpos(pbuf);			/* check for @ and + */

	} /* end-paka */


pakl(value, xpbuf)			/* pack numeric */
long value;
PAKDES *xpbuf;
{
	register int i;
	register PAKDES *pbuf;
	int prec;
	char fmtchar;

	pbuf = xpbuf;

	if (pbuf->pkfmtptr >= pbuf->pkfmtend)
		bberr(BEIFS);			/* error if nothing left in format */

	fmtchar = *pbuf->pkfmtptr++;		/* save and move over format */

	prec = chkprec(value, fmtchar);	/* get numeric precision */

	if (pbuf->pkstrptr+prec > pbuf->pkstrend)
		bberr(BESSZ);			/* error if length exceeds max. */

	if (fmtchar == 'U') {
		if ((i = getlength(pbuf)) == -1)
			i = 0;				/* default is bit 0 */
		if (i > 7)
			bberr(BEIFS);			/* maximum is bit 7 (1 byte) */
		if (value == 0)			/* clear bit if 0, otherwise set */
			*pbuf->pkstrptr &= ~(1 << i);
		else
			*pbuf->pkstrptr |= (1 << i);
		} 
	else {
		for (i = prec-1; i >= 0; i--)  {	/* move data */
			*(pbuf->pkstrptr+i) = value&0377;
			value >>= 8;
			}
		pbuf->pkstrptr += prec;		/* update pointer */
		}

	chkpos(pbuf);			/* check for @ and + */

	} /* end-pakl */


pakd(array, element, xpbuf)		/* pack array */
ARRDES *array;
NPTR   element;
PAKDES *xpbuf;
{
	register int i;
	register PAKDES *pbuf;
	int e;
	int count, prec;
	char fmtchar, *arrayend;
	long temp;

	pbuf = xpbuf;

	if (pbuf->pkfmtptr >= pbuf->pkfmtend)
		bberr(BEIFS);			/* error if nothing left in format */

	fmtchar = *pbuf->pkfmtptr++;		/* save and move over format */

	if (pbuf->pkfmtptr == 'U') {		/* special single element case */

		prec = chkprec(temp, fmtchar);	/* check precision of data */
		if (pbuf->pkstrptr+prec > pbuf->pkstrend)
			bberr(BESSZ);		/* error if length exceeds max. */
		if ((i = getlength(pbuf)) == -1)
			i = 0;				/* default is bit 0 */
		if (i > 7)
			bberr(BEIFS);			/* maximum is bit 7 (1 byte) */
		if ((char *) element.j >= (char *) array->adata.j + array->amaxsiz)
			bberr(BESUB);			/* error if past end of array */
		switch (array->type) {		/* get the array element */
			case 0: 
				temp = (long) *element.j; 
				break;
			case 1: 
				temp = *element.l; 
				break;
			}
		if (temp == 0)			/* clear bit if 0, otherwise set */
			*pbuf->pkstrptr &= ~(1 << i);
		else
			*pbuf->pkstrptr |= (1 << i);

		} 
	else {

		if (*pbuf->pkfmtptr == '*') {	/* process repeat count */
			pbuf->pkfmtptr++;
			if ((count = getlength(pbuf)) == -1)
				count = 1;			/* '*' alone gets default of 1 */
			} 
		else
			count = 1;			/* default repeat count is 1 */
		arrayend = (char *) array->adata.j + array->amaxsiz;
		for (e = 0; e < count; e++) {
			if ((char *) element.j >= arrayend)
				bberr(BESUB);		/* error if past end of array */
			switch (array->type) {		/* get the array element */
				case 0: 
					temp = (long) *element.j++; 
					break;
				case 1: 
					temp = (long) *element.l++; 
					break;
				}
			prec = chkprec(temp, fmtchar);	/* check precision of data */
			if (pbuf->pkstrptr+prec > pbuf->pkstrend)
				bberr(BESSZ);		/* error if length exceeds max. */
			/* move data */
			for (i = prec-1; i >= 0; i--) {
				*(pbuf->pkstrptr+i) = (unsigned) temp&0377;
				temp = temp>>8;
				}
			pbuf->pkstrptr += prec;	/* update pointer */
			} /* end-for */

		}

	chkpos(pbuf);			/* check for @ and + */

	} /* end-pakd */


chkprec(value, fmtchar)
long value;
char fmtchar;
{
	long maxval;
	register int i, p;
	long t1, t2;

	switch (fmtchar) {			/* determine number of bytes */

		case  'I':
		case  'J':
		case  'K':
		case  'L':
			p = ((int) (fmtchar - 'H'));
			i = p * 8;
			t1 = (long) value & (-1L << i);
			t2 = (((long) value >> (i - 1)) & 1L) ? -1L : 0L;
			t2 <<= i;
			if (t1 != t2)
				bberr(BEARI);
			return(p);

		case  'B':
		case  'C':
		case  'D':
			p = ((int) (fmtchar - 'A'));
			maxval = (long) (1L << (p*8)) - 1;
			if (value > maxval || value < 0L)
				bberr(BEARI);
			return(p);

		case  'U':
			return(1);

		default:
			bberr(BEIFS);			/* illegal format string */

		} /* end-switch */

	} /* end-chkprec */
