/*************************************************************************
*
*
*	Name:  getrec & delrec
*
*	Description:  logical file allocation and de-allocation
*
*
*	History:
*	Date		By		Comments
*
*	03/18/83        WEB
*	04/05/83        mas		changed getrec to use a numeric desc
*					to return value
*	04/27/83        WEB		fixed problem with not seeking if the
*					NOLOCK flag is set
*	06/07/83        WEB		fixed problem with not unlocking when
*					an error occurred
*	06/24/83 	mas		changed to use registers where possible
*	07/20/83        WEB		fixed problem with use of rdj/long in
*					getrec by changing to rdj/int
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"

extern int errno;


getrec(xlfileno, retrecno)
int xlfileno;
NUMDES	retrecno;
{
   register int lfileno;
   LFTENT lfent;
   register LFTENT *lfptr;
   char tmp[14];
   unsigned r0len;
   int status;
   long delptr, lstptr, actcnt, recno;

   lfileno = xlfileno;

   if ((lfptr = flftbl(lfileno, &lfent)) == (LFTENT *) 0)
      bberr(BELSE);			/* logical file number out of bounds */

   if (lfptr->lfiletype != 'L')
      bberr(BEIFT);			/* not a linked file */

   if (lfptr->lreclen < 6)
      bberr(BEIRL);			/* must be at least 6 bytes long */

   getr0(tmp, lfptr, &r0len, &status, &delptr, &lstptr, &actcnt);

   recno = -1L;

   if (delptr > 0L) {

      recno = delptr;

      if (recno >= lfptr->lastrecno)
	 gderr(BEIRN, lfptr);

      spos(lfptr->channel, recno*lfptr->lreclen+lfptr->start);

      rdj(&status);
     
      if (status != 0)
	 gderr(BEIRS, lfptr);

      rdl(&delptr);

      if (r0len >= 14)
	 actcnt++;

   } else if (r0len >= 10 && lstptr < lfptr->lastrecno) {

      lstptr++;

      recno = lstptr;

      if (r0len >= 14)
	 actcnt++;

   }

   putr0(tmp, lfptr, &r0len, &status, &delptr, &lstptr, &actcnt);

   putvl(&retrecno, recno);		/* return value */

   return;

} /* end-getrec */

delrec(xlfileno, recno)
int xlfileno;
long recno;
{
   register int lfileno;
   LFTENT lfent;
   register LFTENT *lfptr;
   char tmp[14];
   unsigned r0len;
   int status;
   long delptr, lstptr, actcnt;

   lfileno = xlfileno;

   if ((lfptr = flftbl(lfileno, &lfent)) == (LFTENT *) 0)
      bberr(BELSE);			/* logical file number out of bounds */

   if (lfptr->lfiletype != 'L')
      bberr(BEIFT);			/* not a linked file */

   if (recno > lfptr->lastrecno || recno <= 0L)
      bberr(BEIRN);			/* record number out of bounds */

   if (lfptr->lreclen < 6)
      bberr(BEIRL);			/* must be at least 6 bytes long */

   getr0(tmp, lfptr, &r0len, &status, &delptr, &lstptr, &actcnt);

   spos(lfptr->channel, recno*lfptr->lreclen+lfptr->start);

   wrj(0);				/* write 0 status */

   wrl(delptr);				/* write deleted-record link */

   delptr = recno;

   if (r0len >= 14)
      actcnt--;

   putr0(tmp, lfptr, &r0len, &status, &delptr, &lstptr, &actcnt);

} /* end-delrec */

getr0(buf, xlfptr, r0len, status, delptr, lstptr, actcnt)
char buf[];
LFTENT *xlfptr;
int *status;
unsigned *r0len;
long *delptr, *lstptr, *actcnt;
{
   register LFTENT *lfptr;
   NUMDES err;
   register int i, fd, lockid;

   lfptr = xlfptr;

   err.ndata.J = (int *) 0;		/* set error to undefined */

   lockid = -2;				/* use lock-id of -2 */

   *r0len = (lfptr->lreclen) < 14 ? lfptr->lreclen : 14;

   rdset(lfptr->channel);		/* mark last channel with i/o */

   spos(lfptr->channel, lfptr->start);

   i = xltbchan(lfptr->channel, &fd);	/* get fd for the channel */

   if (i != 2)				/* check fd for errors */
      bberr(BELSE);

					/* seek & lock record 0 if locking */
   if ((lfptr->lflags & LFT_NOLOCK) == FALSE)
      locks(lockid, fd, lfptr->start, (long) lfptr->lreclen, &err);
   else					/* seek if not locking */
      if (lseek(fd, lfptr->start, 0) < 0){
	 errxechk( &err );
	 return;
      }

   valikey = FALSE;			/* disable IKEY */

   read(fd, buf, *r0len);		/* read record 0 */

   swab(buf, (char *) status, 2);	/* extract fields */
   swab(buf+2, (char *) delptr, 4);
   if (*r0len >= 10)
      swab(buf+6, (char *) lstptr, 4);
   if (*r0len >= 14)
      swab(buf+10, (char *) actcnt, 4);

   if (*status != -2)
      gderr(BEIRS, lfptr);		/* record 0 status MUST be -2 */

} /* end-getr0 */

putr0(buf, xlfptr, r0len, status, delptr, lstptr, actcnt)
char buf[];
LFTENT *xlfptr;
int *status;
unsigned *r0len;
long *delptr, *lstptr, *actcnt;
{
   register LFTENT *lfptr;
   register int i, fd, lockid;

   lfptr = xlfptr;

   lockid = -2;				/* use lock-id of -2 */

   wrset(lfptr->channel);		/* mark last channel with i/o */

   spos(lfptr->channel, lfptr->start);

   i = xltbchan(lfptr->channel, &fd);	/* get fd for the channel */

   if (i != 2)				/* check fd for errors */
      bberr(BELSE);

   *status = -2;			/* write status of -2 for record 0 */

   swab((char *) status, buf, 2);	/* insert fields */
   swab((char *) delptr, buf+2, 4);
   if (*r0len >= 10)
      swab((char *) lstptr, buf+6, 4);
   if (*r0len >= 14)
      swab((char *) actcnt, buf+10, 4);

   write(fd, buf, *r0len);		/* write record 0 */

   if ((lfptr->lflags & LFT_NOLOCK) == FALSE)
      unlks(lockid);			/* unlock record 0 */

} /* end-putr0 */

gderr(err, xlfptr)
int err;
LFTENT *xlfptr;
{
   register LFTENT *lfptr;
   int lockid;

   lfptr = xlfptr;

   lockid = -2;				/* use lock-id of -2 */

   if ((lfptr->lflags & LFT_NOLOCK) == FALSE)
      unlks(lockid);			/* unlock record 0 */

   bberr(err);				/* generate B-BASIC error */

} /* end-gderr */
