/*************************************************************************
*
*
*	Name:  cdbl.c 
*
*	Description:
*		cdbl - Ascii decimal to long binary conversion
*		cbdl - Long binary to ascii decimal conversion
*
*
*	History:
*	Date		By		Comments
*
*	03/01/83	mas
*	03/25/83	mas	chk overflow on convert.
*	04/48/83	waf	added cdbln()-cdbl() w/max # chars last arg
*	06/16/83	mas	memory and speed squeeze
*	04/06/84	waf		Re-wrote input algorithm for efficiency.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	  Note that the value -2147483648 (a.k.a. 'minus zero') is not allowed as
	input, even though it is a legal value in BB. This is an artifact of the
	interpreter.

*/

#include "/bb/include/ptype.h"

#define		MAXV	214748364L	/* val of largest # before shift */
#define		MAXD	'7'			/* last digit of largest # */

/*
	Convert decimal string to long value

	Returns -1 on overflow
*/

cdbln(buffer,value,mode,nchars)
BPTR	*buffer;		/* address of byte pointer */
long	*value;			/* address of long value   */
int	mode;			/* conversion mode         */
 				/* 0 = allow decimal point */
				/* 1 = stop on first non-digit */
int	nchars;		/* max # chars to scan ( -1 for 'infinity' ) */
{
	int		sign;
	register char	c;
	long	tl;
	register int	decpos;

	if ( nchars < 0 )
		nchars = 32767 ;		/* nchars = 'infinity' */

	*value = 0;
	decpos = -99;		/* 'dec point not found' flag */
	
	for (; **buffer == ' '; ++(*buffer),nchars--)	/* skip leading space */
		;

	/* chk sign */
	sign = 0 ;		/* assume positive */
	if ( (c = **buffer) == '-' || c == '+' ) {
		++(*buffer);
		nchars--;
		if ( c == '-' )
			sign = -1;
	}

	while ( nchars > 0 ) {
		if ( (c = **buffer) >= '0' && c <= '9' ) {
			/* digit */
			tl = *value;
			/* chk for overflow (before multiplying by 10) */
			if ( tl > MAXV )
				goto cdov ;		/* number too big */
			else if ( tl == MAXV ) {
				/* chk next digit */
				if ( c > MAXD )
					goto cdov ;	/* next digit too big */
				}
			tl = (tl << 2) + tl ;	/* x 5 */
			tl <<= 1 ;				/* x 10 */
			tl += (long) (c & 0x0f) ;	/* + next digit */
			*value = tl;
		}

		else {
			/* not digit */
			if (mode == 1 || c != '.')
				break;
			else {
				/* decimal point */
				if ( decpos >= 0 )
					break;		/* 2nd '.' */
				decpos = -1;		/* start counting digits past '.' */
			}
		}

		/* inc ptrs & cnts */
		decpos++;
		++(*buffer);
		nchars--;
	}

	/* return info */
	if ( sign )
		*value = -(*value) ;
	if ( decpos < 0 )
		decpos = 0 ;		/* dec pos not found */
	return(decpos);	/* mode = 0 - return number of digits after '.' */

	cdov:	/* we overflew */
	return( -1 );			/* flag overflow */
}

cdbl(buffer,value,mode)
BPTR	*buffer;
long	*value;
int	mode;
	{
	return( cdbln(buffer,value,mode,-1) );		/* # chars = 'infinity' */
	}

/*
	Convert long value to decimal string
*/
cbdl(buffer,value,mode)
char	*buffer;		/* pointer to string */
long	value;			/* value to convert  */
int	mode;			/* 0 = string starts with '-' or digit */
{				/* 1 = string starts with ' ' or '-'   */
				/* 2 = same as 1 but w/trailing space */
register int	i,j;
	long	sign,l;
	char	s[20],c;

	if ((sign = value) < 0)
		value = -value;
	
	if (mode == 2) {
		s[0] = ' ';
		i = 1;
	} else
		i = 0;

	do {	/* generate digits in reverse order */
		c = (char)(value % 10);	/* check for negative value(-0)*/
		s[i++] = '0' + ((c<0) ? -c : c); /* get digit */
		value /= 10L;		/* delete it */
		if (value < 0)		/* handle neg zero problem */
			value = -value;
	} while (value > 0);

	if (sign < 0)
		s[i] = '-';
	else
		if (mode == 1 || mode == 2)
			s[i] = ' ';
		else
			--i;
	
	/* reverse the order */
	for (j=0; i >= 0; --i,++j)
		buffer[j] = s[i];
	buffer[j] = '\0';
	return;
}
