/*************************************************************************
*
*
*	Name:  ptype.h
*
*	Description:  Main parameter file for BB/U.
*				  Defines data types & structs.
*
*
*	History:
*	Date		By		Comments
*
*	08/09/83	waf		Added PHHEAD structure for histogram.
*	11/16/83	waf		Added bhead structure.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

.SH*/


#include "/bb/include/pdefine.h"

/*
	numeric data value
*/
typedef union	{
	int		jv;
	long	lv;
	float	xv;
	}
	NUMVAL;

/*
	numeric data pointer
*/
typedef union	numptr {
	int	*j;
	long	*l;
	float	*x;
	}
	NPTR;

/*
	parent string descriptor - found only in variable area
*/
typedef	struct	parentdes {
	char	*pdata;
	unsigned pcurlth;
	unsigned pmaxlth;
	struct  parentdes *ppardes;
	unsigned pmaxsiz;
	}
	PSTRDES;

/*
	stack string descriptor - found only on evaluation stack
*/
typedef struct	stringdes {
	char	*data;
	unsigned curlth;
	unsigned maxlth;
	PSTRDES *pardes;
	}
	STRDES;

/*
	numeric array descriptor - found only in variable area
*/
typedef struct	arraydes {
	NPTR 	adata;
	unsigned type;
	unsigned amaxsiz;
	unsigned numdim;
	unsigned bound[];
	}
	ARRDES;

/*
	numeric decscriptor - found only on evaluation stack
*/
typedef struct	numdes {
	NPTR	ndata;
	unsigned ntype;
	} 
	NUMDES;

/*
	local storage buffer for PRINT-USING
*/

typedef	struct	prudes {
	STRDES	prfmtdes;		/* original STRDES for format */
	char	*prfmtptr;		/* current format pointer */
	char	*prfmtend;		/* end of format pointer */
	char	*prioptr;		/* current i/o buffer pointer */
	char	*prioend;		/* end of i/o buffer pointer */
	char	proverwrite;	/* overwrite character (L7) */
	char	prfillchar;		/* fill character (L8) */
	char	prterminator;	/* terminator (P & Z) */
	char	*prlastactive;	/* last active format pointer (T0) */
	int		przerosuppress;	/* zero suppression (OD, OE & OF) */
	int		practivecount;	/* count of active formats */
	int		prrptcnt;		/* non-group repeat count */
	char	*prrptptr;		/* non-group repeat pointer */
	int		prgrplevel;		/* recursion level for grouping */
	struct	{			/* grouping stack for (...) */
		int		prgrpcnt;	/* grouping repeat count */
		char	*prgrpptr;	/* grouping pointer */
		}	
		prgroup[PRMAXLEVEL];
	} 
	PRUDES;

/*
	pack/unpack decscriptor - found only on evaluation stack
*/
typedef struct	pakdes {
	STRDES  pkfmtdes;
	STRDES  pkstrdes;
	char    *pkfmtptr;
	char    *pkfmtend;
	char    *pkstrptr;
	char    *pkstrend;
	} 
	PAKDES;

/*
	terminal control structure for prctl - this structure
		matches the first 9 items in the ust (ie. the
		structure usrtable) so any changes must be
		reflected in BOTH locations.
*/

typedef struct crt_ctrl {
	char	cdele;			/* character delete echo */
	int 	cpagwid;		/* page width */
	int 	ctabsiz;		/* tab size for print zones */
	int 	cinptmx;		/* input maximum */
	char	cfiller;
	char	clcane1;		/* line cancel echo #1 */
	char	clcane2;		/* line cancel echo #2 */
	char	cpad;			/* pad character */
	int		cpadcnt;		/* pad count */
	char	cikey2;			/* secondary IKEY */
	} 
	CRTCTRL;

/*
	Pointer type definitions
*/

typedef char	*BPTR;
typedef int		*JPTR;
typedef long	*LPTR;
typedef float	*XPTR;
typedef	ARRDES	*ARRPTR;
typedef	STRDES	*STRPTR;
typedef	PSTRDES	*PSTRPTR;
typedef	NUMDES	*NUMPTR;

typedef union {
	char	*B;
	BPTR	*PB;
	int	*J;
	JPTR	*PJ;
	long	*L;
	LPTR	*PL;
	float	*X;
	XPTR	*PX;
	NUMDES	*N;
	NUMPTR	*PN;
	STRDES	*S;
	STRPTR	*PS;
	PSTRDES	*PD;
	PSTRPTR	*PPD;
	ARRDES	*A;
	ARRPTR	*PA;
	} 
	POINTER;

/*
	For/Next Stack element descriptor
*/
typedef struct {
	NPTR	control;
	NUMVAL	limit;
	NUMVAL	step;
	char	*loop;
	} 
	FNDES;

/*
	LFTBL$ entry structure
*/
typedef struct lftentry {	/*******************************/
	int		channel;	/*						       */
	long	start;		/* WARNING - the numeric parts */
	unsigned lflags;	/* must be "swab"ed before use */
	char	lname[10];	/* The function flftbl() will  */
	unsigned lreclen;	/* do this when it copies the  */
	long	lastrecno;	/* LFTENT to the local copy.   */
	char	lfiletype;	/* PACK will create a LFTENT in*/
	char	nextvol;	/* the proper format for flftbl*/
	} 
	LFTENT;				/*						       */
						/*******************************/

/*
	Gosub Stack element
*/
typedef char	*GSDES;

/*
	Line number table structure
*/

struct	lnrec {
	unsigned lineno;
	unsigned pcoffset;
	};

/*
	Global Frame Structure
*/

struct GFRAME {
	POINTER	SPC;		/* saved PC			*/
	POINTER	SFP;		/* saved FP			*/
	POINTER	SGFP;		/* saved GFP			*/
	POINTER	SIFP;		/* saved IFP			*/
	POINTER	ERRVEC;		/* current ERRor VECtor		*/
	POINTER	INTVEC;		/* current INTerrupt VECtor	*/
	POINTER	BSP;		/* current Base Stack Pointer 	*/
	BPTR	*GSP;		/* current Gosub Stack Pointer	*/
	FNDES	*FNSP;		/* current For/Next Stack Ptr	*/
	struct lnrec *LTP;	/* current Line Table Pointer	*/
	POINTER	DTP;		/* current Data Table Pointer	*/
	POINTER	FUNC[26];	/* current FUNCtion def. table	*/
	/* Gosub Stack array DESc	*/
	/* For/Next Stack array DESc	*/
	};

/*
	Global Frame Structure with For/Next and Gosub descriptors
*/

struct GFRAMEA {
	struct	GFRAME	GF;	/* Regular Global frame		*/
	ARRDES	GSADES;		/* Gosub Stack array DESc	*/
	int		GSABND;		/* bound for gsades must be 1 dim */
	ARRDES	FNADES;		/* For/Next Stack array DESc	*/
	int		FNABND[2];	/* bounds for fnades must be 2 dim */
	PSTRDES	LFTDES;		/* LFTABL$ string descr		*/
	};

/*
	System Frame   - preceeds first Global Frame on stack
*/

struct SFRAME {
	POINTER	PCD;		/* saved PC dummy		*/
	POINTER	FPD;		/* saved FP dummy		*/
	POINTER	GFPD;		/* saved GFP dummy		*/
	POINTER	IFPD;		/* saved IFP dummy		*/
	POINTER	SERRVEC;	/* system ERRor VECtor		*/
	POINTER	SINTVEC;	/* system INTerrupt VECtor	*/
	};

/* basic.no file structure */
struct specialno {
	char	uniqueno[4];
	char	jobno[JOBMAX];
	};

/* I/O buffer status structure */
struct	ios {
	unsigned iopos;		/* current position in iobuf */
	unsigned iocount;	/* number of bytes in iobuf */
	int		ifd;		/* file descriptor of input file */
	int		ofd;		/* file descriptor of output file */
	char	ioterm;		/* I/O terminator */
	union	{
		unsigned status;
		struct	{
			unsigned moredata : 1;
			unsigned prtprm   : 1;
			unsigned inusing  : 1;
			unsigned inustring: 2;
			unsigned ineof    : 1;
			unsigned inline   : 1;
			}
			iof;
		}
		iou;
	};

/* Statement execution flags union */
union	stx {
	unsigned sxflag;
	struct	{
		unsigned trace    : 1;
		unsigned ikey     : 1;
		unsigned singstep : 1;
		unsigned debug    : 1;
		}
		stxf;
	};



/* Program library structures */
typedef struct {
	unsigned hashfram;	/* number of "buckets" in index */
	unsigned entrycnt;	/* number of entries in bucket */
	unsigned plmagic;
	} 
	PLHEADER;

typedef struct {
	char	plname[11];	/* program name */
	char	pllink[1];	/* link indicator L=link '\0'=owner */
	long	plloc;		/* location within the prog lib */
	} 
	PLENT;

typedef	struct	{	/* header for histogram data dump file */
	char	phtype[10];	/* type of hist data (pcode/profil) */
	unsigned phwords;	/* size (words) of hist data */
	unsigned phscale;	/* scale factor used in profil() */
	char	phfiller[2]; /* round it out to 16 bytes */
	} 
	PHHEAD;


/* Global flags area.
   This space is used for 'global flags and switches'. */
union	gflg {
	unsigned	wordflag[1];
	struct {
		unsigned inredir	: 1;	/* flags redirected input */
		unsigned outredir	: 1;	/* flags redirected output */
		}
		bitflag ;
	} ;

/* User Status Table structure */

struct	usrtable {
	char	dele;		/**********************************/
	int		pagewidth;	/*         W A R N I N G          */
	int		tabsiz;		/*				  */
	int		inputmax;	/* The first 9 items in this      */
	char	filler_11;	/* table must NOT be changed as   */
	char	lcane1;		/* they are  referenced by offset */
	char	lcane2;		/* in the prctl module. See also  */
	char	pad;		/* the structure CRTCTRL.         */
	int		padcnt;		/**********************************/
	char	lcan;		/* line cancel character */
	char	del;		/* character delete character */
	char	unpend1;	/* primary unpend character */
	char	unpend2;	/* secondary unpend character */
	char	ikey1;		/* primary IKEY character */
	char	ikey2;		/* secondary IKEY character */
	int		pushcnt;
	int		columncnt;
	char	pname[PATHSIZE];
	char	defoutput[PATHSIZE];
	int		termtype;
	int		swaperr;
	int		user1;
	int		user2;
	int		security;
	int		slibfd;
	int		slibhash;
	char	libdir[PATHSIZE];
	char	sysdir[PATHSIZE];
	int		ulibfd;
	int		ulibhash;
	long	pjobno;
	long	logintime;
	char	common[512];
	struct	frec {		/* file channel table */
		int		xfd;		/* file desc */
		int		opmode;		/* open mode */
		int		ino;		/* inode # */
		unsigned dev;		/* device code (major & minor) */
		} 	
		ftab[BBCHANS+1];	/* BBCHANS file chans + console */
	struct	lrec {		/* lock table */
		int		lno;
		int		lfd;
		long	lstart;
		long	lsiz;
		}	
		ltab[LCKTBLSIZ];
	/* Statement execution flags */
	union	stx	stmtx;
	/* flags		*/
	unsigned noecho	  : 1;
	unsigned nocolumn : 1;
	unsigned nomsgs	  : 1;
	unsigned lower	  : 1;
	unsigned ctlchar  : 1;
	unsigned xfrcrlf  : 1;
	unsigned noikey	  : 1;
	unsigned flag2    : 1;
	unsigned alarmflag: 1;
	};

#define NORMPGM	30042	/* 'magic' value for a stand-alone pgm */
#define BASEPGM 30043	/*					   base pgm segment */
#define OVLYPGM 30044	/*					   overlay pgm segment */

/* pcode, PMD, and push file header structure */

struct phead {
	unsigned magic;		/* File type */
	unsigned totsiz;
	unsigned codsiz;	/* Size of code segment */
	unsigned ltabsiz;	/* Size of label table */
	unsigned symsiz;	/* Size of symbol table */
	unsigned iltsiz;	/* Size of interface label table */
	unsigned stksiz;	/* Size of stack */
	unsigned ustsiz;	/* Size of user status table */
	unsigned maxsiz;	/* Maximum memory required while running */
	unsigned bcdsiz;	/* (User defined) size of base code */
	unsigned bvrsiz;	/* Size of base variables */
	unsigned icksum;	/* Interface checksum */
	unsigned bcksum;	/* line table & symbol table chksum */
	char	basnam[32];	/* Name of base program */
	int		lasterrno;
	char	*begmem;
	char	*pcerr;
	char	*pclast;
	int		lastfileno;
	unsigned randseed;
	unsigned timeleft;
	char	cram[4];
	POINTER	pc;
	POINTER	fp;
	struct SFRAME	*bfp;
	struct GFRAME	*gfp;
	POINTER	sp;
	unsigned revision;
	/* the statement execution flags */
	union	stx pcstmtx;
	/* flags passed to debugger */
	unsigned derror  : 1;	/* debug error */
	unsigned dikey   : 1;	/* debug ikey  */
	unsigned dbreak  : 1;   /* debug break */
	unsigned dincbs  : 1;	/* incompatible base program */
	unsigned dfill1  : 12;
	/* flags returned from debugger */
	unsigned dcontin : 1;   /* continue after debug */
	unsigned dabort  : 1;	/* abort current program */
	unsigned dabortp : 1;	/* abort p-machine */
	unsigned dpmdump : 1;	/* dump post mortem file */
	unsigned dfill2  : 12;	/* filler */
	/* compiler flags */
	unsigned compdeb : 1;	/* compiled with the debug switch */
	unsigned runonly : 1;	/* no ikeys, no run at line# */
	unsigned noltab  : 1;	/* don't load line number table*/
	unsigned comperr : 1;   /* compile had errors */
	unsigned cfill1  : 12;  /* filler */
	unsigned chksum;	/* -Checksum of all header words */
	};


/* base file header.
	This header is a subset of the p-code header, used to keep info
	about the current 'base segment'.
*/
struct	bhead {
	unsigned bcodsiz;	/* Size of base p-code.
						   If =0, base pgm is not resident */
	unsigned bbcdsiz;	/* (User defined) size of base code segment */
	unsigned bicksum;	/* Interface checksum */
	unsigned bbcksum;	/* line table & symbol table chksum */
	char bbasnam[32];	/* Name of base program */
	} ;
