: This program compares two listing files produced by the BASIC
: de-complier and prints all lines which differ
:
:       Rev 1.01:       Ignores lines beginning with ":" and properly
:                       traps error conditions

0010 Rem - LSTCOM.bb
:
:       Initialization section
0070 ON IKEY THEN GOTO 7700
0080 DIM BUF1$[132],BUF2$[132],T9$[512],F1$[128]
0090 DIM F2$[128],LSTFIL$[128],X$[128],N$[4]


0100 REM ***LSTCOM  REV 1.01 5/28/77
0105 STMA 7,5
0108 STMA 6,1
0110 DATA 1,16,0
0120 READ Q9,OFILE,MDE
0125 STMA 9,3,LSTFIL$
0130 GOSUB 7550                              :READ COM FILE
0140 GOSUB 7500                              :READ FIRST FIELD
0145 LET GLOBE=S                             :SAVE GLOBAL SWITCHES
0150 GOSUB 7500                              :READ SECOND FIELD
0160 IF S=-1 THEN GOTO 8000                  :ERROR IF NOT THERE
0170 LET F1$=X$                              :\  OPEN FILE
0175 PRINT X$
0180 OPEN FILE[1,3],X$                       :/  # 1
0190 GOSUB 7500                              :READ SECOND FIELD
0200 IF S=-1 THEN GOTO 8000                  :ERROR IF NOT THERE
0210 LET F2$=X$                              :\  OPEN FILE
0220 OPEN FILE[2,3],F2$                      :/  # 2
0225 IF AND(GLOBE,1048576) THEN GOTO 0260    :GLOBAL /L (LIST ON OUTPUT DEV.)
0230 GOSUB 7500                              :READ THIRD FIELD
0240 IF S=-1 THEN GOTO 0280                  :IF NOT THERE THEN LIST ON $LPT OR $TRO
0250 LET LSTFIL$=X$                          :SET LISTING-FILENAME
0260 LET OFILE=0                             :OUTPUT FILE #
0270 OPEN FILE[0,2],LSTFIL$                  :OPEN IT
0280 GOTO 1000                               :PROCEED

:
: FOLLOWING IS THE MAIN PROGRAM LOOP
: THE FOLLOWING SUBROUTINES ARE CALLED:
:    7100  READ A LINE FROM FILE #1 INTO BUF1$ AND STATEMENT # IN N1
:    7200  READ A LINE FROM FILE #2 INTO BUF2$ AND STATEMENT # IN N2
:    8100  PRINT BUF1$ PRECEDED BY FILENAME #1
:    8200  PRINT BUF2$ PRECEDED BY FILENAME #2
1000 GOSUB 7100                              :READ LINE FROM FILE #1
1010 GOSUB 7200                              :READ LINE FROM FILE #2
1020 IF N1<>N2 THEN GOTO 1100                :IF STATEMENT NO'S NOT EQUAL WE HAVE WORK TO DO
1022 LET MDE=3                               :MDE=3 SIGNIFIES CONTINUOUS STATEMENT NO'S
1025 IF N1=10000 THEN GOTO 7700              :SIGNAL TO STOP 
1030 IF BUF1$=BUF2$ THEN GOTO 1000           :COMPARE 
1035 PRINT FILE[OFILE],                      :BLANK LINE
1040 GOSUB 8100                              :PRINT BUF1$
1050 GOSUB 8200                              :PRINT BUF2$
1070 GOTO 1000                               :NEXT, PLEASE

:
: DECIDE WHETHER LINES HAVE BEEN SKIPPED
1100 IF N1<N2 THEN GOTO 1200                 :FILE #1 MISSING STATEMENTS
1105 IF MDE THEN IF MDE<>1 THEN PRINT FILE[OFILE],                    :BLANK LINE IF NECESSARY
1110 GOSUB 8200                              :OUTPUT BUF2$
1120 GOSUB 7200                              :READ NEXT LINE FROM FILE #2
1125 LET MDE=1
1130 GOTO 1020                               :TRY AGAIN


:WE HAVE DETERMINED THAT FILE #1 DOES NOT HAVE SOME STATEMENT NO'S THAT
: FILE #2 DOES
1200 IF MDE THEN IF MDE<>2 THEN PRINT FILE[OFILE],                    :BLANK LINE IF NECESSARY
1205 GOSUB 8100                              :OUTPUT BUF1$
1210 GOSUB 7100                              :READ LINE FROM FILE #1
1215 LET MDE=2
1220 GOTO 1020                               :TRY AGAIN

:
: CONVERT FIRST 4 CHARS OF N$ TO STATEMENTS NUMBER IN "N"
7000 LET N=0
7002 IF N$[1,1]=":" THEN RETURN 
7004 IF LEN(N$)<4 THEN RETURN 
7010 FOR I=1 TO 4
7020   LET N=N*10+ASC(N$[I,I])-48
7030 NEXT I
:
: READ LINE FROM FILE #1
7040 RETURN 
7100 INPUT FILE[1],USING "",BUF1$
7105 IF EOF(1)=0 THEN GOTO 7110
7106 LET N1=10000
7107 RETURN 
7110 LET N$=BUF1$[1,4]                           : IGNORE COMMENT
7120 GOSUB 7000                                  : IGNORE BLANK LINE
7130 LET N1=N
7140 RETURN 

:
: READ LINE FROM FILE #2
7200 INPUT FILE[2],USING "",BUF2$
7205 IF EOF(2)=0 THEN GOTO 7210
7206 LET N2=10000
7207 RETURN 
7210 LET N$=BUF2$[1,4]                           : IGNORE COMMENT
7220 GOSUB 7000                                  : IGNORE BLANK LINE
7230 LET N2=N
7240 RETURN 
:
%INCLUDE "/bb/syslib/GETCM.SL"
:
: END OF FILES---STOP
7700 CLOSE 
7710 NEW 

8000 PRINT "INCORRECT NUMBER OF ARGUMENTS"
8010 GOTO 7700

:
: PRINT BUF1$
8100 PRINT FILE[OFILE],F1$;":",BUF1$
8110 RETURN 

:
: PRINT BUF2$
8200 PRINT FILE[OFILE],F2$;":",BUF2$
8210 RETURN

9999 END
