/************************************************************************
*
*
*	Name:  debug
*
*	Description:  P-code debugger.
*
*	History:
*	Date		By		Comments
*
*	03/03/83	waf	
*	05/02/83	waf		Multiple statements per line.
*	05/13/83	waf		Allow command abbreviations.
*	05/17/83	waf		PMD ON/OFF command added.
*	05/23/83	waf		Statement offset fix.
*	08/29/83	waf		ERR command added.
*	09/01/83	waf		Added setjmp() for ikey handler.
*	10/25/83	waf		Added shell interface ('!' prefix).
*	11/03/83	waf		Chk for end of line after cmd parsed.
*	11/04/83	waf		Set up longjmp() env for errors.
*	12/07/83	waf		Use hdchksum() fn to find chksum. (Makefile changed).
*	03/09/84	waf		Chk for end of line on some commands.
*
*  This document contains confidential/proprietary information.
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*************************************************************************


/*  Notes -

This program is used to examine pmd (post mortum dump) files and as a debugger
for the runtime support code.

  If an argument is present when the program is invoked, it is assumed that 
a pmd file is being examined.
  If no argument is present, it is assumed this program was invoked by
executing the 'BREAK' command while running a compiled BB program. If this is
so, then channel #3 is the channel of the (already open) push file.

  The debugger returns information to the p-machine in the push file header.


Implementation -
> Array subscripts (in array assignment) are not checked against bounds.
> Arrays are displayed in toto. A particular element can not be displayed.
	Thus, assignment requires subscripts, while displaying does not.
> If an error condition occurs while debugging, the debugger returns
	without setting ANY of the contin/abort flags in the header.
	(At least one of these bits is set on normal return).



08/29/83	waf
  ERR command - This command will display the error code of the most recent 
  error, and the statement number of the statement in which the error occured.

/*
.SH*/

#include	"debug.h"
#include	"/bb/include/opcodes.h"
#include	<signal.h>

extern	int	ikey();	/* ikey handler */


main( argc, argv )

int	argc;
char	*argv[];
{
	int	i,x;

	setup( argc, argv );		/* setup ptrs, etc. */

	/* display break line */
	curos = adr_os( pmhead.pc.B - 1 );		/* code os of current PC */
	curstmt = os_stmt( curos );
	printf( "\n>> Break at stmt# %s,  offset = %d (dec)\n", stmtstr, curos);

	/* set up ikey return env */
	setjmp( ikeyenv );		/* ikey traps to here */
	signal( SIGINT, ikey );
	signal( SIGQUIT, ikey );

	/* set up error return env. */
	setjmp( errenv );


	/** do debug **/
	forever {
		/* show prompt */
		printf( "d: " ) ;
		/* get cmd line */
		getcmd() ;
		/* execute command */
		if ( docmdline() == DQUIT )  break ;
		}

	putchar( '\n' );


	/** return to caller **/
	/* restore term characteristics */
	rset_chars();

	/* update header and eval stk */
	if ( pmcall() ) {
		/* write header */
		pmhead.chksum = hdchksum(&pmhead) ;
		lseek( pmfd, headfp, 0 );
		x = write( pmfd, &pmhead, sizeof(pmhead) );
		if ( x != sizeof(pmhead) )
			printf( "debug: header write error\n" );
		/* write eval stack */
		lseek( pmfd, estkfp, 0 );
		x = write( pmfd, evalstk, estksiz );
		if ( x != estksiz )
			printf( "debug: eval stk write error\n" );
		x = pmhead.dpmdump * 8 + pmhead.dabortp * 4
		    + pmhead.dabort * 2 + pmhead.dabort;
		exit( x ) ;
		}
	}



/* 
.SH
*/

docmdline ()

/*		Execute debugger/system command.

		The command 'help' gives help on debugger commands.
*/

{
	register int	i,n;
	int		x;
	int		rval;

	if (0)
		printf(">> cmd line = >%s<\n", cmdline );

	/**  Chk for shell cmd ( '!' prefix )  **/
	i = 0;
	while ( cmdline[i] == ' ' )
		i++ ;		/* skip blanks */
	if ( cmdline[i] == '!' ) {

		/* execute shell cmd */
		system( cmdline + (i+1) );
		return( 0 );
		}
	
	/**  Execute debugger cmd  **/
	uc_cmd();		/* convert cmdline to upper case */
	rval = docmd();		/* do debug cmd */
	if ( rval == 0 ) {
		/* chk for EOLN */
		gettkn( EOLN );
		}
	return( rval );
	}


docmd ()		/* Execute debugger cmd */
{
	register int	i,n;
	int		x;

	gettkn( -1 );	/* get 1st token */

	/* 
	.SH
					*** HELP cmd ***

	
	*/
	if ( cmdcmp( "HELP" ) == 0 ) {
		printf("  ! <cmd>         = execute shell cmd.\n" );
		printf("  ?/; <var>       = display value of variable.\n" );
		printf("  LET <var>=<const> = assign value to variable.\n");
		printf("  BREAK <line#>   = set break at <line#>.\n");
		printf("  BREAK ALL       = break at start of all statements.\n");
		printf("  BREAK ?         = display break points.\n");
		printf("  CLEAR <line#>   = clear breakpoint at <line#>.\n");
		printf("  CLEAR ALL       = clear all breakpoints.\n");
		printf("  STEP ON/OFF     = turn single step mode on/off.\n");
		printf("  CON             = proceed with program execution.\n");
		printf("  GOTO <line#>    = proceed at statement <line#>.\n");
		printf("  STOP            = 'pop' to prev. push level (END).\n");
		printf("  ABORT           = abort program (BYE).\n");
		printf("  TRACE ON/OFF    = turn trace on/off.\n");
		printf("  DUMP UST        = display user status table.\n");
		printf("  DUMP GF         = display global frame info.\n");
		printf("  DUMP LT [<line#>[,n]] = display all/n line table entries.\n");
		printf("  DUMP VARS       = display all variables.\n");
		printf("  DUMP FILES      = display file descriptors.\n");
		printf("  DUMP LOCKS      = display lock descriptors.\n");
		printf("  DUMP STK        = display evaluation stack.\n");
		printf("  PMD ON/OFF      = if set, creates PMD file upon return.\n");
		printf("  BASE [<base>]   = set/display current base.\n");
		printf("  STATS           = show some stats and ptrs.\n");
		printf("  ERR             = display last error code & stmt#.\n");
		printf("    where <const> = number | string literal in quotes.\n");
		printf("          <line#> = <stmt#> | '@'<pcos>\n");
		printf("          <stmt#> = <label>[+<stmtos>]\n");
		printf("          <label> = line number (32767 for <end>).\n");
		printf("         <stmtos> = offset of stmt in multi-stmt line.\n");
		printf("           <pcos> = pc offset value.\n");
		printf("           <base> = 8 | 10 | 16\n");
		printf("                  (numbers with '_' suffix are in current base)\n" );

		return( 0 );
		}

	/* 
	.SH
				***  LET, ?, ;  ***
			( Variable reference cmds )
	
	*/
	else if ( cmdcmp( "LET" ) == 0 ||
	    (c=token.str[0]) == '?' || c == ';' ) {
		if ( stexists( 1 ) == FALSE )
			return( -1 );

		return( debvar() );		/* in debvar.c */
		}


	/***  DUMP cmd  ***/

	else if ( cmdcmp( "DUMP" ) == 0 )

		return( debdump() );		/* in debdump.c */


	/***  BREAK cmd  ***/

	else if ( cmdcmp( "BREAK" ) == 0 ) {
		if ( pmcall() == FALSE )  return( 0 );
		return( debbreak() );		/* in debbp.c */
		}

	/***  CLEAR cmds  ***/

	else if ( cmdcmp( "CLEAR" ) == 0 ) {
		if ( pmcall() == FALSE )  return( 0 );
		return( debclear() );		/* in debbp.c */
		}
	/* 
	.SH
				***  STEP cmd  ***

	*/
	else if ( cmdcmp( "STEP" ) == 0 ) {
		if ( pmcall() == FALSE )  return( 0 );
		gettkn(-1);
		if ( strcmp( token.str, "ON" ) == 0 ) {

			/* set SS */
			if ( pmhead.pcstmtx.singstep == 0 ) {
				pmhead.pcstmtx.singstep = 1 ;
				printf( "  SS set\n" );
				}
			}

		else if ( strcmp( token.str, "OFF" ) == 0 ) {

			/* reset SS */
			if ( pmhead.pcstmtx.singstep != 0 ) {
				pmhead.pcstmtx.singstep = 0 ;
				printf( "  SS reset\n" );
				}
			}

		else

badsw:		/* Bad switch */
			error( "Bad switch" );

		return( 0 );
		}

	/* 
	.SH
				** BASE & STAT cmds **

	*/
	else if ( cmdcmp( "BASE" ) == 0 ) {
		if ( gettkn(-1) == EOLN ) {

			/* Show current base */
			printf( "  " );
			showbase();
			putchar( '\n' );
			}

		else {

			/* change base */
			x = (int) token.nval ;
			if ( x == 8 || x == 10 || x == 16 ) {
				base = x ;
				printf( "  " );
				showbase();
				putchar( '\n' );
				}
			else
				error( "Base must be 8, 10, or 16");
			}

		return( 0 );
		}


	else if ( cmdcmp( "STATS" ) == 0 ) {
		showptrs();
		return( 0 );
		}

	/* 
	.SH
				** STOP  ABORT  CON  GOTO cmds ***

	*/
	/* STOP */
	else if ( cmdcmp( "STOP" ) == 0 ) {
		chk_eol() ;		/* double chk cmd */
		pmhead.dabort = 1 ;		/* abort current push level */
		pmhead.dcontin = pmhead.dabortp = 0 ;
		return( DQUIT );
		}

	/* ABORT */
	else if ( cmdcmp( "ABORT" ) == 0 ) {
		chk_eol() ;		/* double chk cmd */
		pmhead.dabortp = 1 ;		/* abort p-machine */
		pmhead.dcontin = pmhead.dabort = 0 ;
		return( DQUIT );
		}

	/* CON / GOTO */
	else if ( cmdcmp( "CON" ) == 0 || cmdcmp( "GOTO" ) == 0) {
		if ( pmcall() == FALSE )  return( DQUIT );

		if ( cmdcmp( "GOTO" ) == 0 ) {

			/* get stmt# to goto */
			gettkn(-1);
			stmt_os( -1 );		/* get os of this stmt */
			pmhead.pc.B = (char *)os_adr( x );
			printf( "  offset = %s   addr = %s\n",
			numstr(x), numstr((int) pmhead.pc.B) );
			}

		pmhead.dcontin = 1 ;
		pmhead.dabort = pmhead.dabortp = 0 ;
		return( DQUIT );
		}
	/* 
	.SH
				** TRACE cmd **
*/

	else if ( cmdcmp( "TRACE" ) == 0 ) {
		if ( pmcall == FALSE )  return( 0 );
		gettkn(-1);

		if ( strcmp( token.str, "ON" ) == 0 ) {

			/* tr on */
			if ( pmhead.pcstmtx.trace == 0 ) {
				pmhead.pcstmtx.trace = 1 ;
				printf("  trace set\n" );
				}
			}

		else if ( strcmp( token.str, "OFF" ) == 0 ) {

			/* tr off */
			if ( pmhead.pcstmtx.trace != 0 ) {
				pmhead.pcstmtx.trace = 0 ;
				printf("  trace reset\n" );
				}
			}

		else
			goto badsw;		/* bad switch */

		return( 0 );
		}

	/* 
	.SH */

	/***  PMD  ON/OFF   ***/


	else if ( cmdcmp( "PMD" ) == 0 ) {

		gettkn(-1);		/* get ON/OFF switch */
		if ( strcmp( token.str, "ON" ) == 0 ) {

			/* turn PMD on */
			if ( pmhead.dpmdump == 0 ) {
				pmhead.dpmdump = 1 ;
				printf( "  PMD flag set\n" );
				}
			}

		else if ( strcmp( token.str, "OFF" ) == 0 ) {

			/* turn PMD off */
			if ( pmhead.dpmdump != 0 ) {
				pmhead.dpmdump = 0 ;
				printf( "  PMD flag reset\n" );
				}
			}

		else
			goto badsw;		/* bad switch */
		}

	/*
	.SH*/

	else if ( cmdcmp( "ERR" ) == 0 ) {

		/**  ERR  **/
		printf( "  error code = %d (dec)\n", pmhead.lasterrno );
		os_stmt(adr_os(pmhead.pcerr));		/* get stmtstr */
		printf( "  statement# = %s\n", stmtstr );
		}

	/* 
	.SH */


	else {
		error( "Bad Cmd  - Enter 'help' for cmds" ) ;
		}

	}

