/**	debext - external vars for debug		**/
/* 	This file is built from debug.h by deleting all 'extern' prefixes.
*/
/**	debug.h - param file for debugger.

06/23/83  mas changed token.str to be 512 bytes so that assigning
              value to string wouldn't blow away other stuff
		      also changed cmdline to 512 and LTMAX to 2000
		      also changed rev no to 1.5
11/4/83		waf		Added jmp_buf externs.
*/

#include	"/bb/include/ptype.h"
#include	"/bb/include/vartab.h"
#include	<setjmp.h>


/*  Define some constants  */
#define	DBUG	0		/* debug flag */
int		dbug;

#define	BELL	1		/* sound bell on errors */
#define	DQUIT	-99		/* exit from debugger when this val returned
										after command is executed */

#define	STMT1OS	0		/* offset of 1st statement on line */
#define	LASTSTMT  32767	  /* stmt# of last stmt in program */

#define	VAR1	3		/* offset of first user var in var table */
#define	VARMAX	348		/* max number of vars in var table */



/*  Define caller flags  */
#define		PMACH	1
#define		PMD		2


/*  Define max size of evaluation stack array  */
#define	ESTKSIZE	32000 	/* max # bytes in eval stack array */
int		estksiz;	/* # bytes in eval stack array */
char	evalstk[ESTKSIZE];	/* array of bytes */


/*  Define file channels	*/
#define	PFCHN	3		/* push file chan# if called by p-machine */


/*  Define global variables  */
char	cmdline[512];	/* command input line */
int		clptr;			/* ptr into command line */
char	c;
int		caller;			/* invoker - pmach or pmd */
int		i,j,k;			/* gen purpose ints */
long	lval;			/* gen purpose long */
int		*iptr;			/* int ptr */
char	*bptr;			/* byte/char ptr */
int		sos, cos,ix;	/* eval stk offset, code offset, evalstk index */


/*  Define token structure */
struct {
	int	typ;			/* type of token */
	long	nval;		/* numeric value */
	char	str[512];	/* token $ */
	}
	token ;

/*  Define token types  */
#define	EOLN	0
#define	NUM		1
#define	STR		3
#define	PNUM	8		/* positive number */
#define	OTHER	9


/*  Define header structures  */
struct  phead  pmhead;	/* push/pmd file header */
struct  phead  bphead;	/* pcode file header */


/*  Define line number table parameters  */
#define	LTMAX	2000		/* max # entries in line# table */
struct	lnrec
	linetbl[LTMAX];			/* line# table */
int	ltnent;			/* # of entries in linetbl */
int	ltix;			/* index for line table searches */
#define	ltloop(N)		for ( ltix=N ; ltix < ltnent ; ltix++ )
			/* use this to search line# table, starting at element N */


/*  Other structures  */
struct usrtable	ust;	/* user status table */
struct	SFRAME	sframe;	/* system frame */
struct	GFRAMEA	gframe;	/* global frame, w/ GS & FN */


/*  Define file ptr and file descriptor vars  */
int	pmfd;		/* fd of pmd/push (.pm) file */
int	bpfd;		/* fd of pcode (.bp) file */
int	ltfd,stfd;	/* fd of line# table and symbol table files.
							(can be in .pm or .bp file) */
long	fptr;	/* gen purpose file ptr */
long	headfp,pcdfp,ltfp,
		ustfp,estkfp,gffp,sffp,symfp;		/* ptrs into file */


/*  Define non-integer functions  */
long	getstklw();
long	lseek();
char	*numstr(),*lnumstr();


/* define numstr() params */
#define	nstrsiz	8		/* max # chars in str */
#define	nstrents	8		/* max # diff strs */
char	numstrbuf[nstrsiz*nstrents] ;	/* buffer for numstr() func */
int	nstrptr ;


/*  Other globals  */
char	sv[32];		/* gen purpose $ var */

int	base;		/* current display base */

int	gfbase;		/* memory base addr of global frame */
						/*  Used to convert mem addresses and gf offsets */
int	pcodbase;	/* memory addr of start of p-code */
						/*  Used to convert mem addresses and pcode offsets */

PSTRDES	sdes;	/* parent string desc */
ARRDES	ades;	/* array desc */
unsigned	arydim1, arydim2;	/* space for dim info after ades */

int	curos,curstmt;	/* offset & stmt# of current (break) stmt */

char	stmtstr[10];	/* statement number, string */ 
int	linenum,stmtos;	/* line number and stmt offset, numeric */

/* substr() declarations */
char	*trun();		/* truncate string */
char	trunbuf[16];	/* buffer for trun'ed str */


/* define jmp_buf vars */
jmp_buf	ikeyenv;	/* ikey/quit signal */
jmp_buf	errenv;		/* errors */
