/*************************************************************************
*
*
*	Name:		symbols.c
*
*	Description:	Symbol table manipulation routines
*
*	History:
*	Date		By	Comments
*
*	12/02/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Digital Communications Associates, Inc.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "/bb/include/ptype.h"

#define MAXVTAB 384
struct VTAB {
   char vname[8];
   char vtype;
   char vflags;
   int  numsubs;
   int  voffset;
} vtab[MAXVTAB];
struct VTAB *nxtvtab;
int nxtoffset;

#define typeUNDF (-1)
#define typeJ	0
#define typeL	1
#define typeX	2
#define typeA	3
#define vlocal	1

initvtab()
{
   struct VTAB *p;
   nxtvtab = &vtab[0];
}

struct VTAB *findsym(symbol)
char *symbol;
{
   char sym[8];
   struct VTAB *p;

   strncpy(sym,symbol,8);
   sym[7] = 0;
   for (p = &vtab[0]; p < nxtvtab; p++) {
      if (strcmp(sym,p->vname) == 0) 
	 if ((p->vflags & vlocal) != 0) synerr("Not a GLOBAL variable");
	 else  return(p);
   }
   p = nxtvtab++;
   if (p >= &vtab[MAXVTAB]) panic("symbol table overflow");
   strcpy(p->vname,sym);
   p->vtype = typeUNDF;
   p->vflags = 0;
   p->numsubs = 0;
   return p;
}

makevar(p,type,numdim)
struct VTAB *p;
int type, numdim;
{
   if (p->vtype == typeUNDF) {
      if (type == typeUNDF) type = typeL;
      p->vtype = type;
      p->voffset = nxtoffset;
      p->numsubs = numdim;
      if (numdim == 0) 
	 switch (type) {
	 case typeJ:
	    nxtoffset += sizeof (short);
	    break;
	 case typeL:
	    nxtoffset += sizeof (long);
	    break;
	 case typeA:
	    nxtoffset += sizeof (PSTRDES);
	    break;
	 default:
	    synerr("Illegal variable type");
         }	
      else
	 nxtoffset += sizeof(ARRDES) + sizeof(int)*numdim;
   } else if (p->vtype == type || type == typeUNDF) {
      if (p->numsubs != numdim) synerr("Number of dimensions different");
   } else synerr("Variable type different");
}
