/*************************************************************************
*
*
*	Name:		procall.c
*
*	Description:	Procedure/function argument lists
*
*	History:
*	Date		By	Comments
*
*	04/21/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "vartab.h"
#include "proctab.h"
#include "symbols.h"

funcall()
{
   struct PROCTAB *p;
   char *s;
   int rtype;

   for (p = functab; p->ftoken != 0; p++) 
      if (p->ftoken == token) {
	 gettoken();
	 if (token != LPAREN) synerr("Missing ( in function call");
	 else gettoken();
	 explist(p->fargs);
	 if (token != RPAREN) synerr(") expected in function call");
	 else gettoken();
	 genop(p->fop);
	 return(p->ftype);
      }
}

explist(s)
char *s;
{
   char c;
   int optflag = 0, more, nargflag = 0, rtype, ltype, nargs = 0, sign;
   long defval = 0;

   more = !(token == RPAREN || token == TELSE || token == EOLN);
   while ((c = *s++) != '\0') {
      if (c == '=') {
	 defval = 0; sign = 1;
	 if (*s == '-') {
	    sign = -1; s++;
	 }
	 while ((c = *s) >= '0' && c <= '9') {
	    defval = defval*10 + c-'0';
	    s++;
	 }
	 if (sign < 0) defval = -defval;
      } else if (c == '/') optflag++;
      else if (c == '%') nargflag++;
      else {
	 if (more != 0) {
	    switch (c) {
case 'j':
	       ltype = typeJ;
	       rtype = numexp(ltype);
	       break;
case 'l':
	       ltype = typeL;
	       rtype = numexp(ltype);
	       break;
case 'x':
	       ltype = typeX;
	       rtype = numexp(ltype);
	       break;
case 'a':
	       rtype = strexp();
	       break;
case '#':
	       numdsc();
	       rtype = typeA; /* small lie to prevent fixtos */
	       break;
case '$':
	       strvar();
	       rtype = typeA;
	       break;
default:
	       panic("explist1");
	    }

	    if (rtype != typeA) fixtos(ltype,rtype);
	    if (token == COMMA) {
	       gettoken();
	       more = 1;
	    } else
	       more = 0;
	    nargs++;
	 } else {
	    if (optflag == 0) {
	       synerr("Too few arguments");
	       optflag = 1;
	    } else if (optflag == 2) continue;
	    switch (c) {
case 'j':
	       genLDCJ((int) defval);
	       break;
case 'l':
	       genLDCL(defval);
	       break;
case 'a':
	       genLDCA("",0);
	       break;
case '#':
	       genLDCL(0L);
	       break;
/* this can only happen if something is rotten */
case '$':
	       genLDCA("",0);
	       break;
default:
	       panic("explist2");
	    }
	 }
      }
   }
   if (nargflag) genLDCJ(nargs);
}

procall(t1,t2)
int t1, t2;
{
   struct PROCTAB *p;
   for (p = proctab; p->ftoken != 0; p++)
      if (p->ftoken == t1 && p->ftype == t2) {
	 explist(p->fargs);
	 genop(p->fop);
	 return;
      }
}
