/*************************************************************************
*
*
*	Name:		pfile.c
*
*	Description:	Pcode file routines
*
*	History:
*	Date		By	Comments
*
*	12/02/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "config.h"
#include "stdio.h"
#include "/bb/include/ptype.h"
#include "opcodes.h"
#include "vartab.h"
#include "label.h"

struct phead phead;
unsigned pmstart, cstart, dstart;
unsigned pc, pcoffset;
unsigned fcodepc, ldatapc;
unsigned maxsize, bcdsize, bvrsize, pmode;
FILE *pcout;
char pcname[];
struct VTAB *flocal;
extern gswr, gsws, gswt;
extern comprev;
int maincnt, totalcnt, errcnt, warncnt;
long ftell();
#if MSDOS
   long time()
   {
      int hr, mn, sc;
      gtod(&hr,&mn,&sc);
      return ((hr*3600L) + (mn * 60L) + sc);
   }
#else
   long time();
#endif
long startime;

pinit()
{
   int *ip;

   startime = time(0);
   initlabel();
   initvtab();
   flocal = nxtvtab;

   maincnt = totalcnt = errcnt = warncnt = 0;
   if ((pcout = fopen(pcname,"w")) == NULL) {
      fprintf(stderr,"%s could not be opened.\n",pcname);
      exit(1);
   }
   fseek(pcout,512L,0);
   ldatapc = fcodepc = 0;
   pc = 0;
   pcoffset = 0;
   maxsize = 0;
   bcdsize = bvrsize = 0;

/* Clear all of phead */
   for (ip = &phead; ip <= &phead.chksum; *ip++ = 0);
}

pstart(mode)
int mode;
{
   struct VTAB *s;

   pmode = mode;

   if (pmode == 1) phead.magic = BASEPGM;
   else if (pmode == 2) phead.magic = OVLYPGM;
   else phead.magic = NORMPGM;

   if (mode != 2) {
      nxtoffset = sizeof (struct GFRAME);

/* create gosub/return stack */
      s = findsym("?GOSUB");
      makevar(s,typeL,1);

/* create for/next stack */
      s = findsym("?FORNX");
      makevar(s,typeL,2);

/* create LFTABL$ */
      s = findsym("LFTABL$");
      makevar(s,typeA,0);
   }
   flocal = nxtvtab;

/* first four instructions must always be:
   JMP to start of p-machine pcodes
   JMP to start of user pcodes
   ABORT - (to make up for STMTX in trailer)
   JMP to start of DATA pcodes
*/
   pmstart = genJMP(JMP,-1);
   cstart = genJMP(JMP,-1);
   genop(ABORT);
   dstart = genJMP(JMP,-1);

/* start DATA link list */
   ldatapc = dstart;
}

bstart(bname)
char *bname;
{
   char path[128];
   int i;
   struct phead bhead;
   struct LABEL l;
   FILE *bhin;

   chkpath(bname,path);
   if ((bhin = fopen(path,"r")) == NULL) {
      fprintf(stderr,"Base program file %s could not be openned.\n",path);
      exit(1);
   }
   fread(&bhead,sizeof (bhead),1,bhin);
   if (bhead.magic != BASEPGM) {
      fprintf(stderr,"%s is not a base program.\n",bname);
      exit(1);
   }
   if ((bhead.revision & 0xff00) != (comprev & 0xff00)) {
      fprintf(stderr,"%s is not the current revision.\n",bname);
      exit(1);
   }
   fseek(bhin,(long) bhead.codsiz + 512L,0);
   for (i = bhead.ltabsiz; i > 0; i -= (sizeof(l.lval) + sizeof(l.lpc))) {
      fread(&l.lval,sizeof(l.lval),1,bhin);
      fread(&l.lpc,sizeof(l.lpc),1,bhin);
      if ((l.lval != 0) && (l.lval != 32767)) {
	 l.ltype = lbase;
	 addlabel(&l);
      }
   }
   fread(nxtvtab = &vtab[0],bhead.symsiz,1,bhin);
   nxtvtab += bhead.symsiz/sizeof(*vtab);
   fread(nxtentext = &entext[0],bhead.iltsiz,1,bhin);
   nxtentext += bhead.iltsiz/sizeof(*entext);

   phead.icksum = bhead.icksum;
   phead.bcksum = bhead.bcksum;
   phead.bcdsiz = bhead.bcdsiz;
   phead.bvrsiz = bhead.bvrsiz;
   strcpy(phead.basnam,bname);
   pc = pcoffset = bhead.bcdsiz;
   nxtoffset = bhead.bvrsiz;
   fclose(bhin);
}   

pend()
{
   int i, n, *ip;
   long savepos;
   unsigned labpc, temppc, sum;
   struct VTAB *s;
   struct PATCH p;
   struct LABEL *l;
   struct ENTEXT *e;

/* Jump to faked last statement in case of fall through */
   temppc = genJMP(JMP,-1);

   if (pmode == 1) {
/* Pad space goes here */
      if (bcdsize != 0) {
	 if (pc <= bcdsize) {
	    while (pc < bcdsize)
	       emitop(ABORT);
	 } else synerr("Base code size too small.");
      }
      phead.bcdsiz = pc;

/* Setup base variable size */
      if (bvrsize != 0) {
	 if (nxtoffset <= bvrsize) {
	    nxtoffset = bvrsize;
	 } else synerr("Base data size too small.");
      }
      phead.bvrsiz = nxtoffset;

/* Make local variable local */
      for (s = flocal; s < nxtvtab; s++)
	 s->vflags = vlocal;
   } 

/* All of the following code is overwritted by any overlay program.
   Therefore, the first four instructions must match up with the first
   four instructions in the overlay program
*/
/* make program start here and then jump to init code */
   jmppatch(pmstart,pc);
   pmstart = genJMP(JMP,-1);

/* Fake up a last statement to make everybody happy */
   jmppatch(temppc,pc);
   makelabel(32767,limp);
   makelabel(32767,ldata);
   genop(STMTX);
   temppc = genJMP(DATA,-1);
   jmppatch(ldatapc,pc);
   genop(PEND);
   jmppatch(temppc,pc);
   genop(PEND);
   genop(ABORT);

/* Output external jump table */
   dumpext();

/* Init code starts here */
   jmppatch(pmstart,pc);

/* Initialize static stack space */
   genJ(CLRSTK,(nxtoffset-sizeof(struct GFRAME))/2);

/* create gosub/return stack */
   s = findsym("?GOSUB");
   genLDCJ(6 /* 14 levels */);
   genLDCJ(1);
   genJ(DIML,s->voffset);
   genop(RSTGS);

/* create for/next stack */
   s = findsym("?FORNX");
   genLDCJ((sizeof (FNDES))/4);
   genLDCJ(8 /* 9 levels */);
   genLDCJ(2);
   genJ(DIML,s->voffset);
   genop(RSTFN);

/* Reset data pointer */
   genJMP(RESTOR,7);

/* Setup pointer to label table */
   labpc = genJMP(DFLTBL,-1);

/* make user code start at first statement */
   jmppatch(cstart,fcodepc);

/* Then jump to start of imp statements */
   if (gswr == 0) genop(START);
   genJMP(JMP,3);

/* Even things up */
   if ((pc & 1) != 0) genop(NOP);

   phead.codsiz = pc - pcoffset;
   jmppatch(labpc,pc);

/* Resolve all the backpatches */
   savepos = ftell(pcout);
   resolve();
   fseek(pcout,savepos,0);

/* Dump the label table */
   sum = 0;
   for (l = &label; l < nxtlabel; l++) {
      emitJ(l->lval); emitJ(l->lpc);
      sum -= l->lval + l->lpc;
   }
   phead.ltabsiz = pc-phead.codsiz-pcoffset;

/* Dump the symbol table */
   for (s = &vtab[0]; s < nxtvtab; s++) {
      fwrite(s,sizeof(*s),1,pcout);
      for (i = 0; i < sizeof(*s); i += 2) {
	 sum -= *(unsigned *)(((char *) s)+i);
      }
   }
   phead.symsiz = ((char *) s) - ((char *) &vtab);
   if (pmode == 1) phead.bcksum = sum;

/* Dump the interface label table */
   if (pmode == 1) {
      sum = 0;
      for (e = &entext; e < nxtentext; e++) {
	 fwrite(e,sizeof(*e),1,pcout);
	 phead.iltsiz += sizeof(*e);
	 sum -= e->eval + e->epc + e->etype;
      }
      phead.icksum = sum;
   }

/* setup and output pcode header */
   phead.totsiz = phead.codsiz+phead.ltabsiz+phead.symsiz+phead.iltsiz;
   phead.maxsiz = maxsize;
   strncpy(phead.cram," .,-",4);
   phead.revision = comprev;
   phead.noltab = gswt;

   for (ip = &phead; ip < &phead.chksum; phead.chksum -= *ip++);

   fseek(pcout,0L,0);
   fwrite(&phead,sizeof (phead),1,pcout);

   if (gsws) {
      if ((startime = time(0)-startime) < 0) startime += 86400L;
      fprintf(stderr,"%d lines in main program, %d total lines in %D seconds.\n",maincnt,totalcnt,startime);
      if (errcnt != 0 || warncnt != 0)
	 fprintf(stderr,"%d error(s).  %d warning(s).\n",errcnt,warncnt);
      fprintf(stderr,"Pcode is %d bytes.  Label table is %d bytes. Symbol table is %d bytes.\n",phead.codsiz,phead.ltabsiz,phead.symsiz);
      fprintf(stderr,"Variable space is %d bytes.\n",nxtoffset);
   }
   fclose(pcout);
}
