/*************************************************************************
*
*
*	Name:		emittors.c
*
*	Description:	Generate, list, and output opcodes and operands
*
*	History:
*	Date		By	Comments
*
*	04/05/83	jle
*	02/23/84	jle	logical expressions
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1984 by Digital Communications Associates 
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "stdio.h"
#include "opcodes.h"
#include "vartab.h"

unsigned pc;
FILE *pcout;
extern gswa;

struct optab {
   char *opname;
   int  opval;
} optab[];

char *dasm(op)
int op;
{
   struct optab *opp;
   for (opp = optab; (opp->opname != 0); opp++) 
      if (opp->opval == op) return(opp->opname);
   return("???");
}

emitop(op)
int op;
{
   if (op > 255) {
      fputc((op>>8)&0377,pcout);
      pc++;
   }
   fputc(op&0377,pcout);
   pc++;
}

emitI(i)
int i;
{
   fputc(i,pcout);
   return(pc++);
}

emitJ(j)
int j;
{
   int p;
   fwrite((char *) &j,sizeof (j),1,pcout);
   p = pc; pc += 2;
   return(p);
}

emitL(l)
long l;
{
   int p;
   fwrite((char *) &l,sizeof (l),1,pcout);
   p = pc; pc += 4;
   return(p);
}

genop(op)
int op;
{
   if (gswa) printf("%6d  %6d  %-8s\n",pc,op,dasm(op));
   return(emitop(op));
}

gentop(op,type)
int op; int type;
{
   if (type == typeB) genop(op+typeJ);
   else genop(op+type);
}

genI(op,i)
int op, i;
{
   if (gswa) printf("%6d  %6d  %-8s%-3d\n",pc,op,dasm(op),i);
   emitop(op);
   return(emitI(i));
}

genJ(op,j)
int op, j;
{
   if (gswa) printf("%6d  %6d  %-8s%-6d\n",pc,op,dasm(op),j);
   emitop(op);
   return(emitJ(j));
}

genL(op,l)
int op;
long l;
{
   if (gswa) printf("%6d  %6d  %-8s%-10ld\n",pc,op,dasm(op),l);
   emitop(op);
   return(emitL(l));
}

genJMP(op,npc)
int op;
unsigned npc;
{
   int sz;
   sz = (op < 128)? 1 : 2;
   if (npc != 0xffff) {
      if (gswa) printf("%6d  %6d  %-8s%-6d\n",pc,op,dasm(op),npc-pc-sz);
      emitop(op);
      return(emitJ(npc-pc));
   } else {
      if (gswa) printf("%6d  %6d  %-8s*\n",pc,op,dasm(op));
      emitop(op);
      return(emitJ(-1));
   }
}

genLDCJ(j)
int j;
{
   if (j == 0) return(genop(LD0J));
   else if (j == 1) return(genop(LD1J));
   else if (j >= -127 && j <= 127) return(genI(LDBJ,j));
   else return(genJ(LDCJ,j));
}

genLDCL(l)
long l;
{
   if (l == 0) return(genop(LD0L));
   else if (l == 1) return(genop(LD1L));
   else if (l >= -127 && l <= 127) return(genI(LDBL,(int) l));
   else return(genL(LDCL,l));
}

genLDCA(s,n)
char *s;
int n;
{
   genI(LDCA,n);
   for (; n > 0; n--)
      emitI(*s++);
}

genLDD(op,link,type,offset)
{
   if (gswa) printf("%6d  %6d  %-8s%1d,%-2d%6d\n",pc,op,dasm(op),link,type,offset);
   emitop(op);
   emitI(link);
   emitI(type);
   emitJ(offset);
}

genLDA(op,link,offset)
{
   if (gswa) printf("%6d  %6d  %-8s%-4d%6d\n",pc,op,dasm(op),link,offset);
   emitop(op);
   emitI(link);
   emitJ(offset);
}
