/*************************************************************************
*
*
*	Name:		inout.c
*
*	Description:	Source input/output routines
*
*	History:
*	Date		By	Comments
*
*	12/13/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "stdio.h"
#include "tokens.h"
#include "symbols.h"

char	*lineptr;
char	curline[256];
char	pcname[];
int	lineno, lstlineno, ateof, inlevel;
unsigned pc, linepc;
int	gswa, gswc, gswd, gswl, gswn, gswp;
int	maincnt, totalcnt, errcnt, warncnt;
extern	errno;
FILE	*infile, *incfile[5];
int	infirst;
int	inlast, inclast[5];
char	inname[128], incname[5][128];

initlev(name)
char *name;
{
   for (inlevel = 10; inlevel >= 0; inlevel--)
      incfile[inlevel] = NULL;
   ateof = 0;
   inlevel = -1;
   incfile[0] = stdin;
   pushlev(name,-1,32767);
}

pushlev(name,first,last)
char *name; int first, last;
{
   if (inlevel >= 5) {
      synerr("Include nesting limit exceeded.");
      return;
   }
   inlevel++;
   if (*name == '\0') {
      if (incfile[inlevel] == NULL) {
	 synerr("No filename previously specified.");
	 inlevel--;
	 return;
      } else {
	 infile = incfile[inlevel];
	 infirst = first;
	 inlast = last;
	 strcpy(inname,incname[inlevel]);
	 rewind(infile);
      }
   } else {
      if (incfile[inlevel] == NULL)
	 infile = fopen(name,"r");
      else
	 infile = freopen(name,"r",incfile[inlevel]);
      infirst = first;
      inlast = last;
      if (infile == NULL) {
	 if (inlevel <= 0) {
	    fprintf(stderr,"File %s could not be opened.\n",name);
	    exit(1);
	 } else
	    synerr("File could not be opened");
	 inlevel--;
	 return;
      } else {
	 strcpy(inname,name);
      }
   }
   incfile[inlevel] = infile;
   inclast[inlevel] = inlast;
   strcpy(incname[inlevel],inname);
}

poplev()
{
   if (inlevel <= 0)
      ateof = 1;
   else {
      inlevel--;
      infile = incfile[inlevel];
      infirst = -1;
      inlast = inclast[inlevel];
      strcpy(inname,incname[inlevel]);
   }
}

/* incldir := %INCLUDE ( numlit minus numlit )? STRLIT?
*/
incldir()
{
   int first, last;
   char name[128];

   gettoken();
   if (token == NUMLIT) {
      first = value;
      gettoken();
      if (token == MINUS) gettoken();
      else synerr("- expected");
      if (token == NUMLIT) {
	 last = value;
	 gettoken();
      } else
	 synerr("Line number expected");
   } else {
      first = -1;
      last = 32767;
   }
   if (token == STRLIT) {
      strcpy(name,symbol);
      gettoken();
   } else
      name[0] = '\0';
   pushlev(name,first,last);
   if (token != EOLN) synerr("Statement does not end properly");
   nextline();
}

geti()
{
   int c;
   if (ateof)
      c = EOF; 
   else
      if ((c = *lineptr) != '\n') lineptr++;
   return c;
}

ungeti(c)
int c;
{
   if (c != '\n' && lineptr > curline) lineptr--;
}

/* Start a new line, getting line number if any
*/
nextline()
{
   int c;

   while (!ateof) {
      lineptr = &curline[0];
      while ((c = getc(infile)) != '\n' && c != EOF)
	 if (c != '\r') *lineptr++ = c;
      *lineptr++ = '\n';
      *lineptr = '\0';
      if (c == EOF) {
	 poplev();
	 token = EOF;
	 continue;
      }
      lineptr = &curline[0];
      gettoken();
      if (token == NUMLIT) {
	 if (value >= 32767) synerr("Invalid line number");
	 if ((inlevel >= 0) && (inlast != 32767) && (value > inlast)) {
	    poplev();
	    continue;
	 }
	 if (infirst >= 0)
	    if (value >= infirst)
	       infirst = -1;
	    else
	       continue;
	 lineno = value;
	 if (lineno <= lstlineno && !gswn) synwarn("Line number out of sequence");
	 else lstlineno = lineno;
	 gettoken();
      } else if (token == EOLN) {
	 /* blank lines are ok */
      } else if (symbol[0] == '%') {
	 /* compiler directives don't need line number */
      } else {
	 if (!gswn) synwarn("Line does not begin with line number.");
	 lineno = 0;
      }
      break;
   }
   linepc = pc;
   if (token != EOF) {
      if (gswl || gswa) {
	 if (gswc || gswd) printf("%6d ",linepc);
	 if (inlevel > 0) printf("%%");
	 printf("%s",curline);
      }
      if (inlevel == 0) maincnt++;
      totalcnt++;
   }
   if (token == TINCLUDE) incldir();
}

/* Print syntax error message
*/
synerr(s)
char *s;
{
   char line[256];
   int c;

   strcpy(line,curline);
   strcpy(line+(lineptr-curline)," <- ");
   strcat(line,lineptr);
   fprintf(stderr,"%s",line);
   if (gswa || gswl) printf("%s",line);
   fprintf(stderr,"%s\n",s);
   if (gswa || gswl) printf("%s\n",s);
   errcnt++;
   if (!gswp) unlink(pcname);
   if (errcnt > 50) {
      fprintf(stderr,"Too many errors, aborting\n");
      exit(1);
   }
}

synwarn(s)
char *s;
{
   fprintf(stderr,"Warning - %s\n",s);
   if (gswa || gswl) printf("Warning - %s\n",s);
   warncnt++;
}

panic(s)
char *s;
{
   synerr(s);
   exit(1);
}
