/*************************************************************************
*
*
*	Name:		bbcomp.c
*
*	Description:	Main compiler routine
*
*	History:
*	Date		By	Comments
*
*	06/10/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "stdio.h"

char	pcname[129];
extern	errno;
unsigned comprev=0x0203;
int	gswa=0, gswc=0, gswd=0, gswl=0, gswn=0, gswp=0, gswr=0, gsws=0;
int	gswt=0, gswz=0;

main(argc,argv)
int argc;
char **argv;
{
   char **argp, *s, name[128], srcname[128], lsname[128];
   if (argc < 2) {
      fprintf(stderr,"Usage: bbcomp -options filename(s)\n");
      fprintf(stderr,"\ta  Output pcode listing to list file\n");
      fprintf(stderr,"\tc  Output pc on listed lines\n");
      fprintf(stderr,"\td  Enable debugging statements and list to <name>.ls\n");
      fprintf(stderr,"\tl  List program\n");
      fprintf(stderr,"\tn  Allow line without line numbers\n");
      fprintf(stderr,"\tp  Create pcode file regardless of compile errors\n");
      fprintf(stderr,"\tr  Make program run only\n");
      fprintf(stderr,"\ts  Print summary statistics\n");
      fprintf(stderr,"\tt  Do not load line number table when running\n");
      exit(-1);
   }
   for (argp = argv+1; *argp != 0; argp++)
      if (**argp == '-') {
	 gswa |= (index(*argp,'a') != 0);
	 gswc |= (index(*argp,'c') != 0);
	 gswd |= (index(*argp,'d') != 0);
	 gswl |= (index(*argp,'l') != 0);
	 gswn |= (index(*argp,'n') != 0);
	 gswp |= (index(*argp,'p') != 0);
	 gswr |= (index(*argp,'r') != 0);
	 gsws |= (index(*argp,'s') != 0);
	 gswt |= (index(*argp,'t') != 0);
	 gswz |= (index(*argp,'z') != 0);
      }
   for (argp = argv+1; *argp != 0; argp++)
      if (**argp != '-') {
	 strcpy(name,*argp);
	 if ((s = rindex(name,'.')) != 0 && s > rindex(name,'/')) {
	    *s = '\0';
	    strcpy(srcname,*argp);
	 } else {
	    strcpy(srcname,name);
	    strcat(srcname,".bb");
	 }
	 initlev(srcname);
	 strcpy(pcname,name);
	 strcat(pcname,".bp");
	 if (gswd) {
	    strcpy(lsname,name);
	    strcat(lsname,".ls");
	    if (freopen(lsname,"w",stdout) == NULL) {
	       fprintf(stderr,"%s could not be opened.\n",lsname);
	       exit(errno);
	    }
	    gswl = 1;
	 }
	 fprintf(stderr,"bbcomp 13-Dec-83 Rev %d.%d: %s\n",
	    comprev>>8,comprev & 0377,srcname);
	 program();
      }
}
