.so doc0
.HI
.ce
UKC IO Library
.ce
R.P.A. Collinson
.ce
University of Kent
.ce
Canterbury
.ce
Kent
.sp3
Document Number: DOC/UNIX.K3.10/4
.sp 5
.ce
Contents.
.in+20
.SC 1 Introduction
.SC 2 "Output routines"
.SC 3 "Input routines"
.SC 4 "Miscellaneous routines"
.SC 5 "Manual pages"
.in-20
.SH 1 "Introduction"
.NF
.PG
There appears to be a requirement for a set
of general I/O routines for Unix which are halfway between the "Portable C library"
and the routines supplied by Bell Labs.
The Portable C library
enlarges programs by at least 5k, so if you are not using 'scanf' it is much
better to use a mixture of the routines below and the Bell Lab routines.
The routines
have been designed to fulfill the following requirements:-
.sp
1)	The routines should be small and use very little data space.
.sp
2)	The routines should be fairly simple to use and should not attempt to deal
with every requirement for programs. If more complicated operations are required, the user should
write them himself.
.sp
3)	The routines should deal with most simple cases of multi-file input and output.
.PG
Within these constraints, it seemed logical to extend the existing set
of Bell Lab routines. Consequently, the routines are built around
getchar, putchar and printf. Only two buffers are used (fin and fout). The buffers have
the following structure:
.in+10
.sp
struct iobuf
.br
{	int fd;		/* File descriptor */
.br
	int nleft;	/* No of chars left in buffer */
.br
	char *nextp;	/* next character position in buff */
.br
	char buff[512];	/* the buffer itself */
.br
}
.in-10
.sp
A buffer is deemed to be empty when 'nleft' equals 0. The user may
directly reference the buffer by including the statement:
.in+10
.sp
extern fin, fout;
.sp
.in-10
in the program, but in general this is not
necessary.
.PG
Files are opened and closed by the standard Unix system calls open(II), creat(II)
and close(II).
The open and creat calls return a file descriptor (fd) which is used to reference the file by
the program. As usual with UNIX; channels 0, 1 and 2 are already
open and refer to the standard input, the standard output and the controlling teletype respectively.
.PG
The routines reside in /lib/libu.a and are included in the C program by adding the symbols '-lu'
at the end of the call to cc.
.br
.sp
eg:
	cc fred.c -lu
.SH 2 "Output Routines"
.SB "putchar(ch)"
.PG
.it Putchar
is exactly the same routine described in putchar(III). The routine writes out its argument and returns it
unchanged. Unless other arrangements have been made, putchar writes in unbuffered fashion
to the standard output file. If the file descriptor in fout is greater than 2 the output will be buffered.
.SB "flush()"
.PG
.it Flush
clears the output buffer (fout) and resets 'nleft' and 'nextp'.
It must be called before exit from a program if buffered output has been used. This routine is the same
as that described in putchar(III).
.SB "selop(fd)"
.PG
.it Selop
is used to flush the output buffer and change output streams. Thus
when using this set of routines, there is the concept of 'current output
stream'. When selop is called all succeeding output will be buffered and consequently
flush() must be called when exiting from the program.
.SB "printf([fd], format, args....)"
.PG
.it Printf
calls putchar to output the arguments under control of the format statement.
Since putchar outputs to the channel given by 'fout'
and the contents of fout may be changed with selop, printf
always outputs to the currently selected output stream.
Printf has been lifted almost unchanged from the original
Bell Lab supplied routines.
.PG
It is sometimes useful to be able to call printf to print a single line on 
a different channel from that which is selected.
When a file descriptor is supplied as a first argument, then a call to
selop(fd) is performed before writing takes place. At the
end of the output phase a selop(oldfd) is executed. This allows
writing to an output stream without having to explicitly call selop twice.
.PG
For example: to print an error message on channel 2 when
the currently selected file is not equal to 2, say:
.sp
.in+10
printf(2, "Error no: %d\\n", errno);
.in-10
.sp
This will cause the output to be printed on the teletype and further output to
be sent to the originally selected file.
.SH 3 "Input routines"
.PG
Input routines use fin in much the same way as the routines above
use fout. There is the notion of the currently selected input which at
program start-up is the standard input to the program (fd = 0).
.SB "int getchar()"
.PG
.it Getchar 
returns the next character from the currently selected input stream. The actual
value returned is an integer (without sign-extension). The value is equal to -1
on end of file or if an error occurs. (Note: this routine is different from the original getchar(III)).
.SB "int gets(str) char *str;"
.PG
.it Gets
returns the next line from the current input stream into the
array pointed to by str.
The standard line terminator ('\\n') is replaced by a null ('\\0'). The value
returned by gets is equal to the number of bytes transfered (excluding the null byte),
-1 is returned on end of file or an error.
.SB "selin(fd)"
.PG
.it Selin
selects a new input channel given by fd. Selin does not perform any input but
simply clears the input buffer and sets it up so that the next call to getchar
will read into an empty buffer.
.PG
If the currently selected file was a disc file and a number (say 5)
getchar calls had been executed, fin would contain 512 bytes with nextp pointing at character 
position 6 in the buffer. As the input buffer is not empty on the call to selin,
a seek would be performed so the next 'read' system call (from getchar) on the file
would read 512 bytes starting at character position 6 in the file.
The appearance of a continuous input stream is thus maintained.
.PG
However, pipes and teletypes do not support seeks
and a selin call 'away' from a pipe or a teletype will cause the remainder of the buffer to be lost, - 
see save and rest below.
.SB "unget(ch)"
.PG
.it Unget
stores the character which is its parameter in a one word buffer. The buffer is interrogated
on the next call to getchar. If the one word buffer is
non-zero, the character it contains will be returned by getchar rather than the
next character in fin. The buffer is cleared by selin and consequently only refers
to the currently selected input stream.
.SB "int save(buf) char *buf;"
.PG
.it Save
is an attempt to get over the problem of losing characters mentioned in selin above.
The routine returns the rest of the current input buffer (including the unget'ed character
if appropriate) into a vector pointed to by buf. The routine returns the
number of characters copied and -1 if end of file or error.
The string returned will be a legal C string terminated by null, the null
byte is not included in the returned count.
.SB "int rest(buf) char *buf;"
.PG
.it Rest
loads the input buffer fin with the null terminated string pointed to by buf. The routine
returns the number of bytes copied (excluding the null byte).
Rest
will not operate if fin is not empty and in this case -1 will be returned. In general, a call to rest
must be preceded by a call to selin or save.
.SB "int rdnum(radix)"
.PG
.it Rdnum
is a general purpose integer reading routine. It returns a signed integer from the
currently selected input stream ignoring leading tabs and spaces.
Characters are read using getchar (above).
If radix = 8, the
digits after the optional sign are interpreted in octal; if radix = 10 the digits are
interpreted in decimal; and setting radix = 0
allows C-style integer constants to be read, where the radix
of the digits is set to base 8 if the first digit is '0' and to base 10 otherwise.
.PG
The integer is terminated by any character which is not '0' to '9', when
reading octal the characters '8' and '9' will be processed as if they were
legal digits. On exit from the routine, the terminating character
will be present in "lastch". Include the statement
.in+10
.sp
extern lastch;
.in-10
.sp
to operate on it.
Lastch will contain -1 if the end of file has been reached while searching for or processing an integer.
.PG
If there has been an error, rdnum will return -1. This may prove inconvenient
in some circumstances and the value may be altered by assigning a new value
to "rderr":
.br
e.g.
.sp
.in+10
extern rderr;
	.
	.
	.
	.
	.
	.
.br
rderr = -123;
.in-10
.PG
The value of rderr is returned on end of file and if any character other than
space, tab, '+', '-' is found before encountering digits.
.SB "int readno()"
.PG
.it Readno
calls rdnum, with radix set to 0 and thus reads either a decimal or octal integer
from the currently selected input stream.
.SB "int reado()"
.PG
.it Reado
calls rdnum(8), and thus reads an octal integer.
.SB "int readn()"
.PG
.it Readn
calls rdnum(10) and reads a decimal integer.
.SB "double readf()"
.PG
.it Readf
reads a floating point number from the input stream. The routine must be declared
in a C program by the  statement:
.in+10
.sp
double readf();
.in-10
.sp
to ensure that the C compiler compiles the correct instructions
to obtain the result of the routine.
.PG
Readf accepts numbers in two forms: either as a standard integer or decimal constant (9, 9.97)
or in exponent form (e.g. 9e5, 9e+5, 9.9e4,8.98e-5). The 'e' may be in upper
or lower case but the number must not contain spaces.
.PG
Lastch will be set to the terminating character and readf will return the value of
rderr (converted to floating) on any error. Errors are: end of file on input, no digits
found, more than one decimal point or 'e' symbol found, and non-integral exponent.
.SH 4 "Miscellaneous routines"
.PG
These routines are included because I always found myself doing them the long way.
.SB "int compstr(str1, str2) char *str1, *str2;"
.PG
.it Compstr
compares the strings (null terminated) pointed to by str1 and str2. The value 'true' (non-zero)
is returned if they are exactly the same.
.SB "char *copystr(source, dest) char *source, *dest;"
.PG
.it Copystr
copies the null terminated string from the location pointed to by 'source'
to the location pointed to be 'dest'. The value returned points at the null
byte in dest, so copystr may be used successively,
.br
e.g.
.br
.in+10
.sp
p = copystr("/bin", buf);
p = copystr("/ls", p);
.in-10
.sp
will result in the string "/bin/ls" being copied into buf.
.SB "int execute(file, name, args, 0)"
.PG
.it Execute
performs a fork system call, the parent then execute a wait
call until the child has finished. The child calls "execl" on the arguments passed to the routine.
The argument 'file' contains a string which is the file
which is to be executed, conventionally the second argument to the call
is the name of the program to be executed. The zero last parameter is mandatory.
.PG
Execute returns the exit status of the child, i.e. the value passed back from the
wait. The value -1 will be returned if the fork cannot be performed, and the child calls exit(-1)
if the named file cannot be found. This call will result in a negative value being returned from
execute, but the actual returned value cannot be guaranteed.
.SB "int system(str) char *str;"
.PG
.it System
calls execute (above) to invoke the shell on the string pointed to by str. The string is thus
processed as if it were a command line from the console.
.SH 5 "Manual Pages"
.PG
The routines have been documented for the Unix Programmers manual in three pages:
.sp
.in+20
.ti-20
UKC IO LIB - Input		describes the input routines.
.br
.ti-20
UKC IO LIB - Misc		describes the miscellaneous routines.
.br
.ti-20
UKC IO LIB - Output	describes the output routines.
.in-20
