#include	"mch.c"


tmark(p)
int *p;
{
	register op, p1, *p2;
	int *ap, t;
	struct symtab *sn;
	if ((op = *p & MASK) == 0)
		return(0);
	if (p == 0)
		return(0);
	p2 = *(p+2);
	p1 = *(p+1);
	switch(op) {
		case STRING :
			return(2);
		case CONST :
			return(abs(p1) > 255);
		case LCLID :
			t = *(ap=p1);
			goto tchk;
		case EXTID :
		case PRCALL :
			t = (sn=p1)->s_type;
			goto tchk;
		case SUBSCR :
			p2 = p = p1;
			p2 = *++p2;
			t = *p == LCLID ? *p2 : (sn=p2)->s_type;
		tchk :
			t = gidtyp(t);
			if (indflg == 1) {
				indflg = 0;
				t =& 1;
			}
			return(t);
		default :
			if (op >= PLUS && op <= EQLSH)
				*p =| ((tmark(p1) | tmark(p2)) << BIT12);
			else
				if (op >= ULNEG && op <= DECRB) {
					if (op == UIND)
						indflg = 1;
					else
					if (op == UAND) {
						*p =| (2 << BIT12);
						return(2);
					}
					*p =| (tmark(p1) << BIT12);
				} else
					finmsg("Compiler error(tmark)");
			return((*p >> BIT12) & 3);
	}
}


fold(op, opr1, opr2)
{
	register v1, v2;
	v1 = opr1;
	v2 = opr2;
	switch(op) {
		case PLUS :
			return(v1 + v2);
		case MINUS :
			return(v1 - v2);
		case MUL :
			return(v1 * v2);
		case DIV :
			return(v1 / v2);
		case AND :
			return(v1 & v2);
		case OR :
			return(v1 | v2);
		case UPARR :
			return(v1 ^ v2);
		case MOD :
			return(v1 % v2);
		case RSHIFT :
			return(v1 >> v2);
		case LSHIFT :
			return(v1 << v2);
	}
}


char *mnem(op)
{
	switch(op) {
		case INCRA :
		case INCRB :
			return("inc");
		case DECRA :
		case DECRB :
			return("dec");
		case PLUS  :
			return("add");
		case MINUS :
			return("sub");
		case AND   :
			return("and");
		case OR    :
			return("ora");
		case UPARR :
			return("eor");
		case LSHIFT:
			return("asl");
		case RSHIFT:
			return("asr");
		case DIV :
			return("div");
		case MUL :
			return("mul");
		case MOD :
			return("mod");
		case CLR :
			return("clr");
		case CMP :
			return("cmp");
	}
}


code(ms, f, a1, a2)
char *ms;
{
	printf("\t%s\t", ms);
	printf(f, a1, a2);
}


updsp(incr)
{
	if (incr) {
		lastsp = sp_inc =- incr;
		ins_des(incr, 1);
		putm("tsx");
	}
}


gidtyp(t)
{
	register i;
	i = 0;
	if (t & PNTR)
		i = 2;
	if (t & INT)
		i++;
	return(i);
}

char *jbrstr(opt, flag)
{
	register op, ptyp;
	op = opt;
	if (!flag)
		if (op&1)
			op++;
		else
			op--;
	ptyp = cevm & 2;
	switch(op) {
		case EQEQ : return("jeq");
		case NEQ : return("jne");
		case LT : return(ptyp ? "jcs" : "jlt");
		case GT : return(ptyp ? "jhi" : "jgt");
		case LE : return(ptyp ? "jls" : "jle");
		case GE : return(ptyp ? "jcc" : "jge");
	}
}

negate(x)
{
	putm("negb");
	if (x)
		printf("\tnega\n\tdeca\n");
}

terminal(p)
int *p;
{
	register op;
	return((op = *p) == CONST ||
		op == LCLID ||
		op == EXTID ||
		op == STRING ||
		(op == SUBSCR && simplesubsc(*(p+1))));
}

simplesubsc(p)
int *p;
{
	register *exp;
	register struct symtab *sp;
	exp = *(p+3);
	return(*exp == CONST ||
		(*exp == EXTID &&
			gidtyp((sp = *++p)->s_type) == 0));
}

lvalue(lvop)
{
	register op;
	if ((op = lvop & MASK) == EXTID ||
		op == LCLID || op == UIND || op == SUBSCR)
		return(1);
	mcerror("Lvalue required");
	return(0);
}

setcevm(p)
int *p;
{
	register *yp;
	yp = p+3;
	switch(*p & MASK) {
		case EXTID : case LCLID :
		case CONST : case SUBSCR :
			yp--;
		case PRCALL : case STRING :
			break;
		default :
			cevm = (*p >> BIT12) & 3;
	}
	yyline = *yp;
	return(cevm);
}


mainexp(p)
int *p;
{
	register *p1;
	p1 = *(p+1);
	switch(*p) {
		case LCLID : case EXTID :
		case STRING : case CONST :
			return;
		case INCRA	:
		case DECRA	:
		case INCRB	:
		case DECRB	:
			if (lvalue(*p1)) {
				tmark(p);
				outcode(p, *p1, *(p1+1), 0);
			}
			return;
		case UAND : case UIND :
			if (terminal(p1))
				return;
		default :
			tmark(p);
			exprnode(p);
	}
}


maincexp(p, lbl, cond)
int *p;
{
	register op, *p1, aftflg;
	aftflg = 0;
	p1 = *(p+1);
	switch(op = *p) {
		case CONST :
			if (p1 == 0)
				outbranch(0, lbl);
			return;
		case LCLID : case EXTID :
		case STRING:
			setpargs(op, p1);
			break;
		case INCRB : case DECRB :
			mainexp(p);
			break;
		case INCRA : case DECRA :
			if (!lvalue(*p1))
				return;
			tmark(p);
			setpargs(*p1, *(p1+1));
			aftflg++;
			break;
		case UIND :
			if (terminal(p1)) {
				ldindx(p1);
				break;
			}
		default :
			tmark(p);
			condexp(p, lbl, cond);
			return;
	}
	code("tst", hfmt, hbarg);
	outbranch(NEQ, lbl, cond);
	if (ctyp) {
		code("tst", lfmt, lbarg);
		outbranch(NEQ, lbl, cond);
	}
	if (aftflg)
		mainexp(p);
}
