.na
.ce
A Multiplexer For UNIX
.sp 2
This paper describes
a new multiplex driver (MPX) for UNIX.
Conceptually,
the MPX drives a single full duplex
channel to another MPX on another UNIX
(the target machine.)
The driver can be looped back to itself
for test purposes since the interface is
symmetric.
In this case,
half of the interface would be the local machine and
half would be the target machine.
The driver is capable of carrying on
multiple independent synchronous full duplex
I/O streams on this single channel.

There exists a directory of character special
files /dev/mpx/J.
(J is an integer from 0 to a maximum of 127.)
The driver accepts the following primitives:

.in 3
.ti -3
1. f = open("/dev/mpx/J", mode)
.br
This opens a file.
I/O cannot be done on the resultant file descriptor until
a connection (see below) is made.

.ti -3
2. stty(f, [1,J])
.br
(The
[x,y] denotes a pointer to an integer array containing
the initialized values x and y.)
This call attempts a connection between the
open file described by f on this machine to the open file
associated with /dev/mpx/J on the target machine.
This call is rejected if f is already connected,
if /dev/mpx/J on the other machine is not open or
if /dev/mpx/J on the other machine is already connected.
After this connection,
read and write calls work as in pipes.

.ti -3
3. stty(f, [2])
.br
The previously established connection between f and
the target machine is broken.
After this, the open file f is in the same state
as when first opened.
In particular, it may be connected to another target file.
If an open file described by f is issued this call from
the target machine, subsequent IO calls on f are rejected.
In this case, f is not available for reconnection until
this call is issued.
An automatic disconnect is performed on last close.

.ti -3
4. stty(f, [3])
.br
This call waits until a connect call on this descriptor
is initiated from the target machine.

.ti -3
5. read/write(f, b, n)
.br
As you would expect.

.ti -3
6. close(f)
.br
Also no surprises.


.in 0
I propose that a MPX daemon be executed in
each of several UNIX systems.
This daemon would open /dev/mpx/0 and wait for
a connection from other systems.
When a connection comes,
it will open another MPX channel, J,
write the single byte J on its open channel 0,
disconnect,
create a child and loop back waiting for
another connect.
The child will open channel J,
wait for a connect
(timing out after a reasonable period),
read a line from channel J and then
execute that line as would the shell.
At this point,
there are two arbitrary programs on
two UNIX machines with channel J open between them.
These programs may then use the channel however they wish.
They may create new channels in the same way
as the daemon.

A third level of protocol
(as yet still sketchy)
would have a master shell (MS)
in one UNIX create a slave shell (SS) in
another UNIX by way of the MPX daemon on the
second UNIX.
The MS would read a syntax similar to
the Shell.
Each command and IO indirection, but not arguments,
may be prefixed with ! to denote that this command
(file) is on the other machine.
Thus:

	pr <!file

would print locally a file that exists on the other machine.

	!pr file

is the same.
Simple file transfer is

	cat <!file >file

or

	!cat file >file

If the other machine has a line printer and
the local machine doesnt,

	pr files | !lpr

One MS may drive several SS's
with a syntax extension such as 1!, 2!, ...
(A connection to a second machine would consist of
a second directory of special files.)

The MPX driver may be used for other things
such as remote peripheral drivers.

Acknowledgments:
The syntax was stolen from AGF and
the MPX looks very like MERT ports.

KT
