/ character list handlers

nlist	= 10.
ncblock	= 100.

/ initialized character list by freeing all
/ blocks

clinit:
	mov	$bfreespace,r1		/ blocks must be 2 mod 8
	bic	$7,r1
	tst	(r1)+
	mov	nlist,r0
1:
	jsr	pc,putb
	add	$10,r1
	sob	r0,1b
	rts	pc


/ allocate character list
/	jsr	pc,allocl
/	(list in r1)

allocl:
	clr	r1
	mov	$nlist,-(sp)
1:
	tstb	c.alloc(r1)
	beq	1f
	inc	r1
	dec	(sp)
	bne	1b
	halt
1:
	tst	(sp)+
	ash	$3,r1
	clr	c.first(r1)
	clr	c.last(r1)
	clr	c.count(r1)
	clr	c.wait(r1)
	ash	$-3,r1
	rts	pc

/ free list
/	(list in r1)
/	jsr	pc,freel
freel:
	clrb	c.alloc(r1)
	rts	pc


/ get block:
/	jsr	pc,getb
/		br none
/	(block in r1)

getb:
	mov	bfrelst,r1
	beq	1f
	mov	(r1),bfrelst
	add	$2,(sp)
1:
	rts	pc

/ free a block
/	(block in r1)
/	jsr	pc,putb

putb:
	mov	bfrelst,(r1)
	mov	r1,bfrelst
	rts	pc

/ get/put:
/	c.first(r1)		first char in list
/	c.last(r1)		last in list
/	c.count(r1)		# chars in list
/	c.wait(r1)		processes waiting on list

/ first and last are 0 if count is

/ get a character
/	(list in r1)
/	jsr	pc,getc
/		br none
/	(char in r0)

getc:
	ash	$3,r1
	mov	c.first(r1),r0
	beq	1f			/ none in list
	add	$2,(sp)			/ success return
	movb	(r0)+,-(sp)		/ the character
	bit	$7,r0			/ last in block?
	beq	3f
	cmp	c.count(r1),$1		/ last in list?
	bne	2f
	bis	$7,r0
	inc	r0
3:
	mov	r1,-(sp)
	mov	(r0),-(sp)
	mov	r0,r1
	sub	$6,r1			/ free used block
	jsr	pc,putb
	mov	(sp)+,r0
	mov	(sp)+,r1
2:
	mov	r0,c.first(r1)		/ new char ptr
	dec	c.count(r1)
	bne	2f
	clr	c.first(r1)		/ first ptr
	clr	c.last(r1)		/ last ptr
2:
	movb	(sp)+,r0
1:
	ash	$-3,r1
	rts	pc

/ put a character
/	(char in r0)
/	(list in r1)
/	jsr	pc,putc
/		br noroom

putc:
	ash	$3,r1
	mov	r0,-(sp)
	mov	c.last(r1),r0
	bit	$7,r0			/ test block full
	bne	1f			/ success
	mov	r1,-(sp)
	jsr	pc,getb
		br 2f			/ no room
	mov	r1,r0
	clr	6(r0)			/ block's next-ptr
	mov	(sp)+,r1
	tst	c.count(r1)	
	bne	3f
	mov	r0,c.first(r1)
	br	1f
3:
	mov	r0,*c.last(r1)
1:
	movb	(sp),(r0)+
	inc	c.count(r1)
	mov	r0,c.last(r1)
	mov	(sp)+,r0
	add	$2,(sp)
	ash	$-3,r1
	rts	pc
2:
	mov	(sp)+,r1
	mov	(sp)+,r0
	ash	$-3,r1
	rts	pc

.bss
/ keep next 3 together:
	.=.+6
bfreespace:
	.=.+[ncblocks*8.] + 2

bfrelst:.=.+2
c.alloc:.=.+nlist

c.first:.=.+2
c.last:	.=.+2
c.count:.=.+2
c.wait:	.=.+2

	. = c.first + [nlist*8]

.text
