/ DC-11 driver

dcaddr	= 174000		/ address of first DC-11
dcvec	= 300			/ vector for first DC-11
ndc = 12.			/ # DC's
hiwater = 30.
lowater = 10.

ps = 177776

.globl	devdc

i.addr	= i.param
i.mode	= i.param+2
i.ctl	= i.param+4
i.rawiq	= i.param+5
i.caniq	= i.param+6
i.canoq	= i.param+7
i.delct	= i.param+10
i.colct	= i.param+11

devdc:
	dcread
	dcwrite
	dcoread
	dcowrite
	dcclread
	dcclwrite

dcwrite:
	mov	r0,r2			/ character
	bic	$!177,r2
1:
	cmp	c.count(r1),$hiwater
	ble	1f
	jsr	pc,sleep
	br	1b
1:
	jsr	pc,ttyoutput
		br 2f			/ no room
	jsr	pc,startdc
	rts	pc
2:
	jsr	pc,timeout
	br	1b

dcread:
	movb	i.caniq(r4),r1
	jsr	pc,getc			/ any characters?
		br 2f
	cmpb	r0,$377			/ EOF marker
	beq	3f
	add	$2,(sp)
3:
	rts	pc
2:
	jsr	pc,canon
	br	dcread

dcoread:
dcowrite:
	jsr	pc,ttyopen		/ set up queues
	cmpb	i.nused(r4),$1		/ first open?
	bne	1f
	movb	i.dev+1(r4),r0		/ DC #
	mov	r0,r1
	add	$240,r1			/ DC # + DC priority level
	asl	r0
	mov	r4,dcinode(r0)		/ set inode #
	asl	r0
	asl	r0
	add	$dcvec,r0		/ generate interrupt vec addr
	mov	$dcrint,(r0)+		/ receiver vector
	mov	r1,(r0)+
	mov	$dcxint,(r0)+		/ transmitter vector
	mov	r1,(r0)+
	add	$dcaddr-dcvec-8.,r0
	mov	r0,i.addr(r4)		/ set address
1:
	mov	i.addr(r4),r3
1:
	bit	$4,(r3)			/carrier present?
	bne	1f
	mov	$101,(r3)		/ terminal ready+rcvr IE
	movb	i.rawiq(r4),r1
	jsr	pc,sleep		/ wait for carrier
	br	1b
1:
	cmpb	i.nused(r4),$1		/ first open?
	bne	1f
	mov	$101,(r3)		/ terminal ready+rcvr IE
	mov	$100,4(r3)		/ xmitter IE
1:
	rts	pc

dcclread:
dcclwrite:
	cmpb	i.nused(r4),$1		/ last close?
	bne	1f
	jsr	pc,ttyclose
	movb	i.dev+1(r4),r0		/ DC #
	asl	r0
	clr	dcinode(r0)		/ clear inode record
1:
	rts	pc

/ start DC output, both at transmitter
/ interrupt and on the top half

startdc:
	mov	i.addr(r4),r3
	tstb	4(r3)			/ DC TSCR
	bpl	1f			/ still busy
	tstb	i.ctl(r4)		/ test timeout going on
	bmi	1f
	movb	i.canoq(r4),r1		/ get character
	jsr	pc,getc
		br 1f			/ none
	bmi	2f			/ char is delay
	mov	r0,6(r3)		/ send character
1:
	rts	pc
2:
	negb	r0			/ get pos delay
	bic	$!177,r0
	bisb	$200,i.ctl(r4)		/ note timeout
	jsr	pc,ccall		/ timeout
		br 1f			/ after a few clicks
	rts	pc
1:
	bicb	$200,i.ctl(r4)		/ clear time-out
	br	startdc

/ DC receiver interrupt

dcrint:
	mov	*$ps,dcno
	jsr	r0,setisp
	jsr	pc,getdc
	bit	$40,r0			/ check parity
	bne	1f
	tstb	i.mode(r4)
	bpl	dcret			/ 37 parity not allowed
1:
	bitb	$100,i.mode(r4)
	bne	dcret			/ non-37 parity not allowed
1:
	mov	2(r3),r0		/ get character
	jsr	pc,ttyinput
	br	dcret

/ DC transmitter interrupt

dcxint:
	mov	*$ps,dcno
	jsr	r0,setisp
	jsr	pc,getdc
	jsr	pc,startdc
	movb	i.canoq(r4),r1
	cmp	c.count(r1),$lowater
	bge	dcret
	jsr	pc,wakeup		/ wake up top half
	br	dcret

getdc:
	mov	dcno,r3
	bic	$!17,r3			/ get DC #
	asl	r3
	mov	r3,r4
	mov	dcinode(r4),r4
	asl	r3
	asl	r3
	add	$dcaddr,r3		/ generate address
	mov	(r3),r0			/ get rcvr SR
	bpl	2f			/ no error
	bit	$40000,r0		/ carrier transition?
	beq	1f			/ no, ignore
	bit	$4,r0			/ carrier on?
	bne	1f
	tst	r4			/ DC open?
	beq	3f
	clr	r0
	jsr	pc,signal		/ hangup signal
3:
	clr	(r3)			/ carrier off, turn off CD lead
	mov	r3,r4
	mov	$30.,r0			/ for .5 secs
	jsr	pc,ccall
		br 9f
	br	1f
2:
	tst	r4			/ check inode #
	beq	1f			/ not open
	cmpb	i.dev(r4),$14.		/ make sure it's a DC
	bne	1f
	rts	pc
1:
	tst	(sp)+
dcret:
	jmp	retisp

/ turn CD lead back on after hang-up timeout
9:
	mov	$101,(r4)
	rts	pc


.bss
dcno:	.=.+2
dcinode:.=.+[2*ndc]
.text

