int	nsu;
int	nspc;
int	nld;
double	fprice;
double	fmaint;
double	fdisc[10];
char	*ndisc[10]
{
	"None  ",
	"Type 1",
	"Type 2",
	"Module",
	"GT 40 ",
	0,
};
char	item[400];
struct
{
	char	*name1;
	char	*name2;
	int	count;
} preq[];
struct
{
	int price;
	int maint;
	int code;
	char *name;
	char *descr;
} table[];
char	*pkg[];
int	fin;
char	buf[100];

main(argc, argv)
char *argv[];
{
	int i, c, n;
	int flag;
	double fmul();

	fprice = 0.;
	fmaint = 0.;
	nsu = 0;
	nspc = 0;
	nld = 0;

	for(i=1; i<argc; i++) {
		if(argv[i][0] == '-') {
			if(compos(1, argv[i]+1))
				printf("%s: bad arg\n", argv[i]+1);
			continue;
		}
		fin = open(argv[i], 0);
		if(fin < 0) {
			printf("%s: cannot open\n", argv[i]);
			exit();
		}
	}

loop:

	/*
	 * read in quantity
	 * ignore space and tab
	 */

	n = 1;
	c = getchar();
	while(c==' ' || c=='	')
		c = getchar();
	if(c>='0' && c<='9') {
		n = 0;
		while(c>='0' && c<='9') {
			n = n*10 + c-'0';
			c = getchar();
		}
	}

	/*
	 * read up to item name
	 */

	while(c==' ' || c=='	')
		c = getchar();

	/*
	 * read in item name
	 * terminate with null
	 */

	for(i=0; i<99; i++) {
		if(c == '\n')
			break;
		if(c == '\0')
			goto pass2;
		buf[i] = c;
		c = getchar();
	}

	/*
	 * ignore blank lines
	 */

	if(i == 0)
		goto loop;
	buf[i] = '\0';
	if(compos(n, buf))
		printf("%s: cannot recognize\n", buf);
	goto loop;

pass2:

	/*
	 * examine for contigencies
	 */

	flag = 0;
	i = lookup("preq");
	if(item[i])
	for(i=0; preq[i].name1 != 0; i++) {
		c = lookup(preq[i].name1);
		if(c < 0)
			goto badpreq;
		n = preq[i].count;
		n = (item[c] + n - 1)/n;
		if(n <= 0)
			continue;
		c = lookup(preq[i].name2);
		if(c < 0) {
		badpreq:
			printf("bad preq table:\n\t%s\n", preq[i].name1);
			continue;
		}
		n =- item[c];
		if(n > 0) {
			if(compos(n, preq[i].name2))
					printf("%s: bad preq\n", preq[i].name2);
			flag++;
		}
	}
	if(flag)
		goto pass2;

	/*
	 * clean up system units,
	 * spc's, and loads
	 */

	i = lookup("conf");
	if(item[i]) {
		while(nspc < 0)
			if(compos(1, "dd11-b")) {
				printf("no dd-11\n");
				break;
			}
		while(nld < 0)
			if(compos(1, "db11-a")) {
				printf("no db-11\n");
				break;
			}
		while(nsu < 0) {
			if(compos(1, "h960-da")) {
				printf("no h-960\n");
				break;
			}
			if(nsu < 0 && compos(1, "ba11-f"))
				printf("no ba11\n");
		}
	}

	/*
	 * print pretty table
	 */

pass3:
	i = lookup("list");
	flag = item[i];
	i = lookup("item");
	if(flag || item[i]) {
		for(i=0; i<200; i++)
		if(item[i]!=0 && table[i].price!=1) {
			n = item[i];
			printf("%2d %-8s", n, table[i].name);
			printf("%4.0f", fmul(n, table[i].maint));
			printf("%8.0f", fmul(n, table[i].price));
			if(flag)
				printf(" %s", table[i].descr);
			printf("\n");
		}
		printf("          ");
	}
	printf("%5.0f%8.0f\n", fmaint, fprice);
	printf("\nnsu = %4d\nspc = %4d\nnld = %4d\n\n",
		nsu, nspc, nld);
	for(i=0; ndisc[i]; i++)
		printf("%s%8.0f\n", ndisc[i], fdisc[i]);
}

compos(n, bp)
char *bp;
{
	int i, p[4], d, j;
	double fmul();

	i = lookup(bp);
	if(i >= 0)
		goto found;

	/*
	 * look up in package table
	 */

	for(i=0; pkg[i]; i++) {
		d = 0;
		if(equal(pkg[i], bp))
			d++;
		for(i++; pkg[i]; i++)
			if(d && compos(n, pkg[i]))
				printf("%s: bad pkg\n", pkg[i]);
		if(d)
			return(0);
	}
	return(1);

found:
	item[i] =+ n;
	if(table[i].price == 1)
		return(0);
	d = table[i].code;
	for(j=0; j<4; j++) {
		p[j] = d%10;
		d =/ 10;
	}
	fmaint =+ fmul(n, table[i].maint);
	fprice =+ fmul(n, table[i].price);
	switch(p[0]) {
	case 5:
		p[0] = -17;
		break;

	case 6:
		p[0] = -19;
		break;

	case 7:
		p[0] = -18;
		break;
	}
	nld =- p[0]*n;
	switch(p[1]) {

	case 5:
		p[1] = -3;
		break;

	case 6:
		p[1] = -1;
		break;

	case 7:
		p[1] = -4;
		break;
	}
	nspc =- p[1]*n;
	switch(p[2]) {

	case 5:
		p[2] = -3;
		break;

	case 6:
		p[2] = -7;
		break;

	case 7:
		p[2] = -6;
		break;

	case 8:
		p[2] = -9;
		break;

	case 9:
		p[2] = -18;
		break;
	}
	nsu =- p[2]*n;
	fdisc[p[3]] =+ fmul(n, table[i].price);
	return(0);
}

double fmul(n, p)
{
	double f;

	f = p;
	if(f < 0.)
		f =+ 65536.;
	f =* n;
	return(f);
}

lookup(bp)
char *bp;
{
	int i;

	for(i=0; table[i].price!=0; i++)
	if(equal(table[i].name, bp))
		return(i);
	return(-1);
}

equal(s1, s2)
char *s1, *s2;
{
	register char *c1, *c2;

	c1 = s1;
	c2 = s2;
	while(*c1++ == *c2)
		if(*c2++ == '\0')
			return(1);
	return(0);
}
