#
/*****************************************************************
 **								**
 **		   U C L A  Data Secure Unix			**
 **								**
 **			Copyright 1977				**
 **								**
 **    Mark Kampe, Charles Kline, Gerald Popek, Evelyn Walton	**
 **								**
 *****************************************************************/
#define true 0177777
#define false 000000
#define then  /* */

#include "../../shared/constants.h"
#include "../../shared/shared.h"
#include "../caps.h"
#include "../conf.h"

int queueword;
int quentry[_Q_LENGTH];
struct captab captab[];
/* name:
	drain_q

function:
	To process all events in the kernel communication queue

algorithm:
	while there is anything in the queue;
		build a message;
		vector it off to the appropriate interrupt handler;

parameters:

returns:
	when the queue has been emptied

globals:
	compile time parameters
	captab
	quentry

calls:
	nextqword
	panic
	interrupt handlers (through intrtab)

called by:
	idle
	trap

history:
	designed and coded by Mark Kampe
*/
drain_q()
{	register int length;
	register int i;
	register int capx;


	while( nextqword() )
	{	quentry[0] = queueword;
		length = quentry->q_length;
		for(i = 1; length--; i++)
		{	nextqword();
			quentry[i] = queueword;
		}

		if (quentry->q_type == _CLOCK_INTERRUPT) then
		{	clockint();
			continue;
		}
		/* if it isn't a kernel interrupt, croak */
		if (quentry->q_type != _DEVICE_INTERRUPT)
			then	panic( "spurious queue entry" );

		capx = quentry->q_cindex;
		i = captab[ capx ].c_id[0];	/* major device number */
		if (captab[ capx ].c_access == _READ_ACCESS)
		then
			(*intrtab[i].d_iintr)( quentry );
		else
			(*intrtab[i].d_ointr)( quentry );
	}
}

nextqword()
{	if (comm_blk->c_qfront == comm_blk->c_qrear) then
	{	queueword = 0;
		return( false );
	}

	if (comm_blk->c_qfront == (_Q_LENGTH - 1))
		then comm_blk->c_qfront = 0;
		else comm_blk->c_qfront++;

	queueword = comm_blk->c_q[comm_blk->c_qfront];
	return( true );
}

/* name:
	notified

function:
	to see if I have been notified

algorithm:
	for(all possible notification words)
		for(all bits within that word)
			if it is on, return the associated process index;
	else return(false)

parameters:

returns:
	process index of the first person to have notified me

globals:
	comm_blk->c_nbits

calls:

called by:
	idle

history:
	Designed and coded by Mark Kampe
*/

notified( )
{	register int i;
	register int j;
	register int testword;

	for(i = 0; i < _NUM_NOTIFICATION_WORDS; i++)
	{	testword = comm_blk->c_nbits[i];
		for( j = 0; j < 16; j++ )
			if (testword & (1<<j))
			then	return( (i<<4) | j );
	}
	return( false );
}
/* name:
	spurious

function:
	to log spurious interrupts

algorithm:

parameters:
	pointer to associated  queue entry

returns:

globals:

calls:
	printf

called by:
	drainq through intrtab

history:
*/
spurious( qent )
 struct dev_int *qent;
{	register struct dev_int *q;
	register int capx;

	q = qent;
	capx = q->q_cindex;
	printf("Spurious interrupt for capx %d, ", capx );
	printf("dev = < %d , %d >\r\n", captab[capx].c_id[0], 
					captab[capx].c_id[1] );
}

